/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.texture;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.logging.Logger;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw3d.graphics3d.DisplayListManager;
import org.eclipse.draw3d.graphics3d.lwjgl.font.LwjglFontManager;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglGraphics;
import org.eclipse.draw3d.graphics3d.lwjgl.texture.AbstractLwjglTexture;
import org.eclipse.draw3d.util.BufferUtils;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.draw3d.util.ImageConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class LwjglTextureFbo
extends AbstractLwjglTexture {
    private static final int ATTRIB_MASK = 537164109;
    private static FboSupport fboSupport = FboSupport.UNKNOWN;
    private static final Logger log = Logger.getLogger(LwjglTextureFbo.class.getName());
    private LwjglFontManager m_fontManager;
    private int m_glFrameBuffer = 0;
    private int m_glTexture = 0;
    private Graphics m_graphics;
    private int m_height = -1;
    private int m_width = -1;
    private DisplayListManager m_displayListmanager;

    private static int createFbo() {
        int n;
        IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
        try {
            buffer.rewind();
            EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)buffer);
            n = buffer.get(0);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
        return n;
    }

    private static int createTexture(int i_width, int i_height) {
        int n;
        IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
        try {
            buffer.rewind();
            GL11.glGenTextures((IntBuffer)buffer);
            int glTexture = buffer.get(0);
            GL11.glBindTexture((int)3553, (int)glTexture);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9987);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)i_width, (int)i_height, (int)0, (int)6408, (int)5121, null);
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)glTexture, (int)0);
            GL11.glBindTexture((int)3553, (int)0);
            n = glTexture;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
            throw throwable;
        }
        Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
        return n;
    }

    private static void deleteFbo(int i_glFrameBuffer) {
        if (i_glFrameBuffer > 0) {
            IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
            try {
                buffer.rewind();
                buffer.put(i_glFrameBuffer);
                EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)buffer);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
        }
    }

    private static void deleteTexture(int i_glTexture) {
        if (i_glTexture > 0) {
            IntBuffer buffer = Draw3DCache.getIntBuffer((int)1);
            try {
                buffer.rewind();
                buffer.put(i_glTexture);
                GL11.glDeleteTextures((IntBuffer)buffer);
            }
            catch (Throwable throwable) {
                Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
                throw throwable;
            }
            Draw3DCache.returnIntBuffer((IntBuffer[])new IntBuffer[]{buffer});
        }
    }

    public static boolean isSuppported() {
        if (fboSupport == FboSupport.UNKNOWN) {
            fboSupport = FboSupport.UNSUPPORTED;
            ContextCapabilities contextCapabilities = GLContext.getCapabilities();
            if (contextCapabilities == null || !contextCapabilities.GL_EXT_framebuffer_object) {
                return false;
            }
            int glFrameBuffer = 0;
            int glTexture = 0;
            try {
                glFrameBuffer = LwjglTextureFbo.createFbo();
                glTexture = LwjglTextureFbo.createTexture(32, 32);
                int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
                if (status != 36053) {
                    return false;
                }
            }
            finally {
                LwjglTextureFbo.deleteTexture(glTexture);
                LwjglTextureFbo.deleteFbo(glFrameBuffer);
            }
            fboSupport = FboSupport.SUPPORTED;
            return true;
        }
        return fboSupport == FboSupport.SUPPORTED;
    }

    public LwjglTextureFbo(int i_width, int i_height, DisplayListManager i_displayListmanager, LwjglFontManager i_fontManager) {
        if (i_displayListmanager == null) {
            throw new NullPointerException("i_displayListmanager must not be null");
        }
        if (i_fontManager == null) {
            throw new NullPointerException("i_fontManager must not be null");
        }
        this.m_displayListmanager = i_displayListmanager;
        this.m_fontManager = i_fontManager;
        this.setDimensions(i_width, i_height);
        this.m_glFrameBuffer = LwjglTextureFbo.createFbo();
    }

    public void activate() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        GL11.glFlush();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.m_glFrameBuffer);
        if (!this.m_valid) {
            this.m_graphics = new LwjglGraphics(this.m_width, this.m_height, this.m_displayListmanager, this.m_fontManager);
            LwjglTextureFbo.deleteTexture(this.m_glTexture);
            this.m_glTexture = LwjglTextureFbo.createTexture(this.m_width, this.m_height);
            this.m_valid = true;
            int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
            if (status != 36053) {
                throw new RuntimeException(this.getStatus(status));
            }
        }
        GL11.glPushAttrib((int)537164109);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glDisable((int)32925);
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2884);
        GL11.glHint((int)3154, (int)4354);
        GL11.glEnable((int)2848);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluOrtho2D((float)0.0f, (float)this.m_width, (float)this.m_height, (float)0.0f);
        GL11.glViewport((int)0, (int)0, (int)this.m_width, (int)this.m_height);
    }

    public void clear(Color i_color, int i_alpha) {
        if (i_color == null) {
            throw new NullPointerException("i_color must not be null");
        }
        float[] color = ColorConverter.toFloatArray((Color)i_color, (int)i_alpha, null);
        GL11.glClearColor((float)color[0], (float)color[1], (float)color[2], (float)color[3]);
        GL11.glClear((int)16384);
    }

    public void deactivate() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        GL11.glFlush();
        GL11.glBindTexture((int)3553, (int)this.m_glTexture);
        EXTFramebufferObject.glGenerateMipmapEXT((int)3553);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
    }

    public void dispose() {
        if (this.m_disposed) {
            return;
        }
        LwjglTextureFbo.deleteTexture(this.m_glTexture);
        this.m_glTexture = 0;
        LwjglTextureFbo.deleteFbo(this.m_glFrameBuffer);
        this.m_glFrameBuffer = 0;
        if (this.m_graphics != null) {
            this.m_graphics.dispose();
            this.m_graphics = null;
        }
    }

    private void dump() {
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.m_width * this.m_height * 4));
        GL11.glReadPixels((int)0, (int)0, (int)this.m_width, (int)this.m_height, (int)6408, (int)5121, (ByteBuffer)buffer);
        ImageData imageData = ImageConverter.colorBufferToImage((ByteBuffer)buffer, (int)6408, (int)5121, (int)this.m_width, (int)this.m_height);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        String path = "/Users/kristian/Temp/texture" + this.m_glTexture + "_" + System.currentTimeMillis() + ".png";
        imageLoader.save(path, 5);
    }

    public Graphics getGraphics() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        if (!this.m_valid) {
            throw new IllegalStateException("texture not valid");
        }
        if (this.m_graphics == null) {
            throw new IllegalStateException("texture not initialized");
        }
        return this.m_graphics;
    }

    private String getStatus(int i_status) {
        switch (i_status) {
            case 36053: {
                return "GL_FRAMEBUFFER_COMPLETE_EXT";
            }
            case 36054: {
                return "GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT";
            }
            case 36055: {
                return "GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT";
            }
            case 36058: {
                return "GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT";
            }
            case 36059: {
                return "GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT";
            }
            case 36060: {
                return "GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT";
            }
        }
        return "unknown status code " + i_status;
    }

    public int getTextureId() {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        return this.m_glTexture;
    }

    public void setDimensions(int i_width, int i_height) {
        if (this.m_disposed) {
            throw new IllegalStateException("texture is disposed");
        }
        if (i_width <= 0 || i_height <= 0) {
            throw new IllegalArgumentException("texture dimensions must be positive (" + i_width + " * " + i_height + ")");
        }
        this.m_valid = this.m_valid && this.m_width == i_width && this.m_height == i_height;
        this.m_width = i_width;
        this.m_height = i_height;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FboSupport {
        SUPPORTED,
        UNKNOWN,
        UNSUPPORTED;

    }
}

