/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.offscreen;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBufferConfig;
import org.eclipse.draw3d.graphics3d.Graphics3DOffscreenBuffers;
import org.lwjgl.opengl.GL11;

public class LwjglOffscreenBackBuffers
implements Graphics3DOffscreenBuffers {
    private Graphics3DOffscreenBufferConfig m_bufferConfig;
    private int m_height;
    private int m_width;

    public LwjglOffscreenBackBuffers(int i_height, int i_width, Graphics3DOffscreenBufferConfig bufferConfig) {
        this.m_height = i_height;
        this.m_width = i_width;
        this.m_bufferConfig = bufferConfig;
    }

    public boolean isBackBuffer() {
        return true;
    }

    public void dispose() {
    }

    public void init() {
    }

    public void initBuffers() {
    }

    public void postRender(ByteBuffer i_colorBuffer, FloatBuffer i_depthBuffer) {
        int width = this.m_width;
        int height = this.m_height;
        Graphics3DOffscreenBufferConfig bufferConfig = this.m_bufferConfig;
        if (bufferConfig.isEnabled(16384)) {
            int format = bufferConfig.getColorPixelFormat();
            int type = bufferConfig.getColorDataType();
            GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)i_colorBuffer);
        }
        if (bufferConfig.isEnabled(256)) {
            int type = bufferConfig.getDepthDataType();
            GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6402, (int)type, (FloatBuffer)i_depthBuffer);
        }
    }

    public void preRender() {
    }

    public void setHeight(int i_height) {
        this.m_height = i_height;
    }

    public void setWidth(int i_width) {
        this.m_width = i_width;
    }

    public void setBufferConfig(Graphics3DOffscreenBufferConfig i_bufferConfig) {
        this.m_bufferConfig = i_bufferConfig;
    }
}

