/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf3d;

import org.eclipse.amp.agf.IGraphicsAdapter;
import org.eclipse.amp.agf.gef.AgentEditPart;
import org.eclipse.amp.agf3d.AgentFigure3D;
import org.eclipse.amp.agf3d.IGraphics3DAdapter;
import org.eclipse.amp.agf3d.IShape3DProvider;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.Figure3D;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.swt.graphics.Color;

public class AgentEdit3DPart
extends AgentEditPart {
    private IGraphics3DAdapter graphics3DAdapter;
    boolean update = true;
    IShape3DProvider shapeProvider;

    public AgentEdit3DPart(IGraphics3DAdapter graphics3DAdapter, IGraphicsAdapter graphicsAdapter, boolean update) {
        super(graphicsAdapter);
        this.graphics3DAdapter = graphics3DAdapter;
        this.update = update;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.shapeProvider = (IShape3DProvider)this.getGraphics3DAdapter().getAdapter(model, IShape3DProvider.class);
    }

    protected IFigure buildFigure(IFigure figure) {
        if (figure == null) {
            figure = new AgentFigure3D(this);
            IVector3f size3d = this.shapeProvider.getSize3D(this.getModel());
            size3d = new Vector3fImpl(size3d.getX(), size3d.getY(), -size3d.getZ());
            ((Figure3D)figure).getPosition3D().setSize3D(size3d);
        }
        if (this.getColorProvider() != null) {
            Color foreground = this.getColorProvider().getForeground(this.getModel());
            if (figure.getForegroundColor() != foreground) {
                figure.setForegroundColor(foreground);
            }
            Color background = this.getColorProvider().getBackground(this.getModel());
            if (figure.getBackgroundColor() != background) {
                figure.setBackgroundColor(background);
            }
        }
        return figure;
    }

    protected void refreshVisuals() {
        if (this.getFigureProvider() == null || !this.getFigureProvider().isHandlingColor(this.getModel()) && this.getFigureProvider().isColorMutable(this.getModel())) {
            this.updateColor(this.figure);
        }
    }

    protected IFigure createFigure() {
        IFigure3D buildFigure = (IFigure3D)this.buildFigure(null);
        return buildFigure;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public IVector3f getRelativeLocation3D() {
        return this.shapeProvider.getRelativeLocation3D(this.getModel());
    }

    public IShape3DProvider getShapeProvider() {
        return this.shapeProvider;
    }

    public IGraphics3DAdapter getGraphics3DAdapter() {
        return this.graphics3DAdapter;
    }
}

