/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3d.ui.actions;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw3d.Export3DOperation;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DRegistry;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchPart;

public class Export3DAction
extends WorkbenchPartAction {
    public static final String ID = Export3DAction.class.getName();
    public final String rendererID;

    public static final String actionID(String rendererID) {
        return String.valueOf(ID) + "_" + rendererID;
    }

    public Export3DAction(IWorkbenchPart i_part, String i_rendererID) {
        super(i_part);
        if (i_rendererID == null) {
            throw new NullPointerException("rendererID must not be null");
        }
        this.rendererID = i_rendererID;
        this.setId(Export3DAction.actionID(this.rendererID));
        this.init();
    }

    protected void init() {
        if (this.rendererID != null) {
            super.init();
            Graphics3DDescriptor descr = Graphics3DRegistry.getRenderer((String)this.rendererID);
            if (descr != null) {
                this.setText("Export " + descr.getName());
                this.setToolTipText(descr.getDescription());
                this.setId(this.getId());
            }
        }
    }

    protected boolean calculateEnabled() {
        return Graphics3DRegistry.getRenderer((String)this.rendererID) != null;
    }

    public void run() {
        FileDialog fd = new FileDialog(this.getWorkbenchPart().getSite().getShell(), 8192);
        fd.setText("Export");
        String strExportFile = fd.open();
        if (strExportFile != null) {
            GraphicalViewer viewer = this.getEditPartViewer();
            LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
            IFigure figure = lm.getLayer((Object)"Printable Layers");
            IFigure3D fig3D = figure instanceof IFigure3D ? (IFigure3D)figure : Figure3DHelper.getAncestor3D((IFigure)figure);
            Export3DOperation operation = new Export3DOperation(strExportFile, this.rendererID, fig3D);
            operation.run();
        }
    }

    protected GraphicalViewer getEditPartViewer() {
        return (GraphicalViewer)this.getWorkbenchPart().getAdapter(GraphicalViewer.class);
    }
}

