/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.core;

import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.core.IStateListener;
import org.eclipse.amp.axf.core.LifeCycleState;

public class LifecycleObservationAdapter
implements IStateListener {
    ILifeCycleListener lifeCycleListener;

    public LifecycleObservationAdapter(ILifeCycleListener lifeCycleListener) {
        this.lifeCycleListener = lifeCycleListener;
    }

    public void stateChange(Object notifyType, Object observed) {
        if (notifyType instanceof LifeCycleState && observed instanceof IObservationProvider) {
            IObservationProvider provider = (IObservationProvider)observed;
            switch ((LifeCycleState)((Object)notifyType)) {
                case OBSERVED: {
                    this.lifeCycleListener.observing(provider);
                    return;
                }
                case CREATE: {
                    this.lifeCycleListener.observeCreate(provider);
                    return;
                }
                case INITIALIZE: {
                    this.lifeCycleListener.observeInitialize(provider);
                    return;
                }
                case START: {
                    this.lifeCycleListener.observeStart(provider);
                    return;
                }
                case UPDATE: {
                    this.lifeCycleListener.observeUpdate(provider);
                    return;
                }
                case STOP: {
                    this.lifeCycleListener.observeStop(provider);
                    return;
                }
                case END: {
                    this.lifeCycleListener.observationEnd(provider);
                    return;
                }
                case ENDING: {
                    this.lifeCycleListener.observationEnding(provider);
                    return;
                }
            }
        }
    }
}

