/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.List;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw3d.AbstractSurface;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public class FigureSurface
extends AbstractSurface {
    private FigureListener m_figureListener = new FigureListener(){

        public void figureMoved(IFigure i_source) {
            FigureSurface.this.coordinateSystemChanged();
        }
    };
    private IFigure3D m_host;

    public FigureSurface(IFigure3D i_host) {
        if (i_host == null) {
            throw new NullPointerException("i_host must not be null");
        }
        this.m_host = i_host;
        this.m_host.addFigureListener(this.m_figureListener);
    }

    protected void calculateNormal(Vector3f io_normal) {
        io_normal.set(IVector3f.Z_AXIS_NEG);
        IMatrix4f rotation = this.m_host.getPosition3D().getAbsoluteRotationMatrix();
        Math3D.transform((IVector3f)io_normal, (IMatrix4f)rotation, (Vector3f)io_normal);
    }

    public IFigure findFigureAt(int i_sx, int i_sy, TreeSearch i_search) {
        if (i_search != null && i_search.prune((IFigure)this.m_host)) {
            return null;
        }
        IFigure hit = null;
        ConnectionLayer connectionLayer = this.m_host.getConnectionLayer(null);
        if (connectionLayer != null && (hit = i_search != null ? connectionLayer.findFigureAt(i_sx, i_sy, i_search) : connectionLayer.findFigureAt(i_sy, i_sy)) != null && hit != connectionLayer) {
            return hit;
        }
        List children = this.m_host.getChildren();
        for (IFigure child : children) {
            if (child instanceof IFigure3D || (hit = i_search != null ? child.findFigureAt(i_sx, i_sy, i_search) : child.findFigureAt(i_sx, i_sy)) == null) continue;
            return hit;
        }
        if (i_search == null || i_search.accept((IFigure)this.m_host)) {
            return this.m_host;
        }
        return null;
    }

    public IFigure3D getHost() {
        return this.m_host;
    }

    protected Vector3f getOrigin(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Position3D position3d = this.getHost().getPosition3D();
        IMatrix4f matrix = position3d.getRotationLocationMatrix();
        result.set(IVector3f.NULLVEC3f);
        result.transform(matrix);
        return result;
    }

    public Vector3f getSurfaceRotation(Vector3f o_result) {
        Vector3f vector3f;
        Vector3f result = o_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        Position3D absolute = Draw3DCache.getPosition3D();
        try {
            this.m_host.getPosition3D().getAbsolute(absolute);
            result.set(absolute.getRotation3D());
            vector3f = result;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{absolute});
            throw throwable;
        }
        Draw3DCache.returnPosition3D((Position3D[])new Position3D[]{absolute});
        return vector3f;
    }

    protected Vector3f getXAxis(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(IVector3f.X_AXIS);
        this.rotateVector(result);
        return result;
    }

    protected Vector3f getYAxis(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(IVector3f.Y_AXIS);
        this.rotateVector(result);
        return result;
    }

    protected Vector3f getZAxis(Vector3f io_result) {
        Vector3f result = io_result;
        if (result == null) {
            result = new Vector3fImpl();
        }
        result.set(IVector3f.Z_AXIS);
        this.rotateVector(result);
        return result;
    }

    public boolean is2DHost() {
        return true;
    }

    private void rotateVector(Vector3f i_vector) {
        Matrix4f rot = Math3DCache.getMatrix4f();
        try {
            IVector3f angles = this.m_host.getPosition3D().getRotation3D();
            Math3D.rotate((IVector3f)angles, (IMatrix4f)IMatrix4f.IDENTITY, (Matrix4f)rot);
            i_vector.transform((IMatrix4f)rot);
        }
        catch (Throwable throwable) {
            Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
            throw throwable;
        }
        Math3DCache.returnMatrix4f((Matrix4f[])new Matrix4f[]{rot});
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Figure surface for host [");
        b.append(this.m_host);
        b.append("]");
        return b.toString();
    }
}

