/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.ide;

import org.eclipse.amp.amf.ide.Configurator;
import org.eclipse.amp.amf.ide.RuntimeConfigurator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaLaunchTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.metaabm.SContext;
import org.metaabm.SImplementation;
import org.metaabm.xsd.MetaABMPersist;

public class LaunchConfigTab
extends JavaLaunchTab {
    private WidgetListener fListener = new WidgetListener();
    private Text projText;
    private Button projButton;
    private Text launchFileText;
    private Button metaABMFileButton;
    private Path metaABMPath;
    private IResource metaABMModel;
    protected Text modelClassText;
    private Configurator runtimeConfig = RuntimeConfigurator.METAABM_CONFIGURATOR;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.projButton = this.createPushButton(parent, "&Browse...", null);
        this.projText = this.createGroup(comp, "&Project:", this.projButton, null);
        this.createVerticalSpacer(comp, 1);
        this.metaABMFileButton = this.createPushButton(parent, "&Search...", null);
        this.launchFileText = this.createGroup(comp, "metaABM Model:", this.metaABMFileButton, null);
        this.createVerticalSpacer(comp, 1);
        this.modelClassText = this.createGroup(comp, "(Main Class:)", null, null);
        this.modelClassText.setEnabled(false);
    }

    private Text createGroup(Composite comp, String title, Button searchButton, Button[] checkButtons) {
        Font font = comp.getFont();
        Group group = new Group(comp, 0);
        group.setText(title);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setFont(font);
        Text text = new Text((Composite)group, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setFont(font);
        text.addModifyListener((ModifyListener)this.fListener);
        if (searchButton != null) {
            searchButton.setParent((Composite)group);
            searchButton.addSelectionListener((SelectionListener)this.fListener);
        }
        if (checkButtons != null) {
            Button[] buttonArray = checkButtons;
            int n = checkButtons.length;
            int n2 = 0;
            while (n2 < n) {
                Button button = buttonArray[n2];
                button.setParent((Composite)group);
                GridData gd = new GridData();
                gd.horizontalSpan = 2;
                button.setLayoutData((Object)gd);
                button.addSelectionListener((SelectionListener)this.fListener);
                ++n2;
            }
        }
        return text;
    }

    private void setMetaABMText(String fullName) {
        this.metaABMPath = new Path(fullName);
        String projectName = this.projText.getText().trim();
        int pos = fullName.indexOf(projectName);
        if (projectName.length() > 0 && pos >= 0) {
            this.launchFileText.setText(fullName.substring(pos + projectName.length() + 1));
        } else {
            this.launchFileText.setText(fullName);
        }
        if (!this.metaABMPath.isEmpty() && this.getJavaProject() != null && this.getJavaProject().getProject() != null) {
            String osPath = String.valueOf(this.getJavaProject().getProject().getLocation().toOSString()) + "/" + this.metaABMPath;
            try {
                SContext context = MetaABMPersist.create((String)osPath).load();
                SImplementation impl = context.getImplementation();
                this.modelClassText.setText(impl.getQualifiedName());
            }
            catch (Exception e) {
                this.setErrorMessage("Invalid metaabm file: " + osPath + ": " + e);
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        try {
            this.projText.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, ""));
            this.setMetaABMText(config.getAttribute("org.eclipse.amp.amf.gen.metaABMFile", ""));
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String text = this.launchFileText.getText().trim();
        if (text.length() > 0) {
            IProject project = this.getWorkspaceRoot().getProject(this.projText.getText().trim());
            if (project != null) {
                if (project.getFile((IPath)this.metaABMPath) == null) {
                    this.setErrorMessage("Specified file does not exist.");
                    return false;
                }
            } else {
                this.setErrorMessage("Specify a project.");
            }
        } else {
            this.setMessage("Specify a model file.");
        }
        return super.isValid(launchConfig);
    }

    public String getName() {
        return "Main";
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        try {
            IProject project = this.getWorkspaceRoot().getProject(this.projText.getText().trim());
            if (project != null && !this.metaABMPath.isEmpty()) {
                this.metaABMModel = project.getFile((IPath)this.metaABMPath);
                this.getConfigurator().configure(config, this.metaABMModel);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        this.getConfigurator().configure(config, this.metaABMModel);
    }

    private void handleMetaABMButtonSelected() {
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)this.getWorkspaceRoot(), 1);
        dialog.setTitle("Select starting workflow file.");
        dialog.setMessage("Select starting workflow file.");
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            this.setMetaABMText(file.getProjectRelativePath().toString());
        }
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.projText.setText(projectName);
    }

    private IJavaProject chooseJavaProject() {
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle("Project Selection:");
        dialog.setMessage("Choose a metaABM project containing your model and generated classes.");
        try {
            dialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects());
        }
        catch (JavaModelException jme) {
            throw new RuntimeException(jme);
        }
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        String projectName = this.projText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public Configurator getConfigurator() {
        return this.runtimeConfig;
    }

    public void setRuntimeConfig(Configurator runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    private class WidgetListener
    implements ModifyListener,
    SelectionListener {
        private WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            LaunchConfigTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == LaunchConfigTab.this.projButton) {
                LaunchConfigTab.this.handleProjectButtonSelected();
            } else if (source == LaunchConfigTab.this.metaABMFileButton) {
                LaunchConfigTab.this.handleMetaABMButtonSelected();
            } else {
                LaunchConfigTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

