/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry.intersection;

import org.eclipse.draw3d.geometry.IVector2f;
import org.eclipse.draw3d.geometry.intersection.Segment;

public class Intersection {
    private Segment m_first;
    private Segment m_overlap;
    private IVector2f m_point;
    private Segment m_second;
    private Type m_type;

    public Intersection(Segment i_first, Segment i_second, IVector2f i_point) {
        this.m_type = Type.POINT;
        this.m_first = i_first;
        this.m_second = i_second;
        this.m_point = i_point;
    }

    public Intersection(Segment i_first, Segment i_second, Segment i_overlap) {
        this.m_type = Type.OVERLAP;
        this.m_first = i_first;
        this.m_second = i_second;
        this.m_overlap = i_overlap;
    }

    public Segment getFirst() {
        return this.m_first;
    }

    public Segment getOverlap() {
        if (this.m_type != Type.OVERLAP) {
            throw new AssertionError();
        }
        return this.m_overlap;
    }

    public IVector2f getPoint() {
        if (this.m_type != Type.POINT) {
            throw new AssertionError();
        }
        return this.m_point;
    }

    public Segment getSecond() {
        return this.m_second;
    }

    public Type getType() {
        return this.m_type;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OVERLAP,
        POINT;

    }
}

