/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.geometry;

import java.util.EnumSet;
import org.eclipse.draw3d.geometry.IHost3D;
import org.eclipse.draw3d.geometry.IMatrix4f;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Math3DCache;
import org.eclipse.draw3d.geometry.Matrix4f;
import org.eclipse.draw3d.geometry.Matrix4fImpl;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DUtil;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public abstract class AbstractPosition3D
implements Position3D {
    private transient Matrix4fImpl m_absoluteRotationMatrix;
    private Vector3f m_center = new Vector3fImpl();
    private boolean m_invertible = false;
    private transient Matrix4fImpl m_rayDirectionMatrix;
    private transient Matrix4fImpl m_rayOriginMatrix;
    protected Vector3f m_rotationAngles = new Vector3fImpl();
    private transient Matrix4fImpl m_rotationLocationMatrix;
    private transient Matrix4fImpl m_transformationMatrix = new Matrix4fImpl();
    protected boolean m_updatingBounds = false;
    private boolean m_valid = false;

    public AbstractPosition3D() {
        this.m_rotationLocationMatrix = new Matrix4fImpl();
        this.m_rayOriginMatrix = new Matrix4fImpl();
        this.m_rayDirectionMatrix = new Matrix4fImpl();
        this.m_absoluteRotationMatrix = new Matrix4fImpl();
    }

    public void expand(float i_delta) {
        Vector3f location = Math3DCache.getVector3f();
        Vector3f size = Math3DCache.getVector3f();
        try {
            float d = 0.5f * i_delta;
            location.set(this.getLocation3D());
            location.translate(-d, -d, -d);
            this.setLocation3D(location);
            size.set(this.getSize3D());
            size.translate(d, d, d);
            this.setSize3D(size);
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(location, size);
            throw throwable;
        }
        Math3DCache.returnVector3f(location, size);
    }

    protected void firePositionChanged(IPosition3D.PositionHint hint, IVector3f delta) {
        if (this.getHost() != null) {
            this.getHost().positionChanged(EnumSet.of(hint), delta);
        }
    }

    public Position3D getAbsolute(Position3D o_result) {
        Position3D parentPosition;
        Position3D result = o_result;
        if (result == null) {
            result = Position3DUtil.createAbsolutePosition();
        }
        if ((parentPosition = this.getParentPosition()) != null) {
            Position3D position3D;
            Vector3f location = Math3DCache.getVector3f();
            Vector3f rotation = Math3DCache.getVector3f();
            try {
                Math3D.transform(IVector3f.NULLVEC3f, this.getRotationLocationMatrix(), location);
                result.setLocation3D(location);
                rotation.set(this.getRotation3D());
                IHost3D parent = this.getHost().getParentHost3D();
                while (parent != null) {
                    Math3D.add(parent.getPosition3D().getRotation3D(), rotation, rotation);
                    parent = parent.getParentHost3D();
                }
                result.setRotation3D(rotation);
                result.setSize3D(this.getSize3D());
                position3D = result;
            }
            catch (Throwable throwable) {
                Math3DCache.returnVector3f(location, rotation);
                throw throwable;
            }
            Math3DCache.returnVector3f(location, rotation);
            return position3D;
        }
        result.setLocation3D(this.getLocation3D());
        result.setSize3D(this.getSize3D());
        result.setRotation3D(this.getRotation3D());
        return result;
    }

    public IMatrix4f getAbsoluteRotationMatrix() {
        this.validate();
        return this.m_absoluteRotationMatrix;
    }

    public IVector3f getCenter3D() {
        this.validate();
        return this.m_center;
    }

    private Position3D getParentPosition() {
        IHost3D parent;
        IHost3D host = this.getHost();
        if (host != null && (parent = host.getParentHost3D()) != null) {
            return parent.getPosition3D();
        }
        return null;
    }

    public Position3D getRelative(IPosition3D i_position3D, Position3D o_result) {
        Position3D position3D;
        Position3D result = o_result;
        if (result == null) {
            result = Position3DUtil.createRelativePosition(this.getHost());
        }
        Position3D abs = Math3DCache.getPosition3D();
        Vector3f tmp = Math3DCache.getVector3f();
        try {
            this.getAbsolute(abs);
            Math3D.sub(i_position3D.getLocation3D(), abs.getLocation3D(), tmp);
            result.setLocation3D(tmp);
            Math3D.sub(i_position3D.getRotation3D(), abs.getRotation3D(), tmp);
            result.setRotation3D(tmp);
            result.setSize3D(i_position3D.getSize3D());
            position3D = result;
        }
        catch (Throwable throwable) {
            Math3DCache.returnPosition3D(abs);
            Math3DCache.returnVector3f(tmp);
            throw throwable;
        }
        Math3DCache.returnPosition3D(abs);
        Math3DCache.returnVector3f(tmp);
        return position3D;
    }

    public IVector3f getRotation3D() {
        return this.m_rotationAngles;
    }

    public IMatrix4f getRotationLocationMatrix() {
        this.validate();
        return this.m_rotationLocationMatrix;
    }

    public IMatrix4f getTransformationMatrix() {
        this.validate();
        return this.m_transformationMatrix;
    }

    public void invalidate() {
        this.m_valid = false;
    }

    public boolean isValid() {
        if (!this.m_valid) {
            return false;
        }
        Position3D parentPosition = this.getParentPosition();
        return parentPosition == null || parentPosition.isValid();
    }

    public void setCenter3D(IVector3f i_center) {
        Vector3f delta = Math3DCache.getVector3f();
        Vector3f location = Math3DCache.getVector3f();
        try {
            Math3D.sub(this.getCenter3D(), i_center, delta);
            if (!IVector3f.NULLVEC3f.equals(delta)) {
                Math3D.sub(this.getLocation3D(), delta, location);
                this.setLocation3D(location);
            }
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(delta, location);
            throw throwable;
        }
        Math3DCache.returnVector3f(delta, location);
    }

    public void setPosition(IPosition3D i_position3D) {
        Position3D absNew = Math3DCache.getPosition3D();
        Position3D absParent = Math3DCache.getPosition3D();
        Vector3f location = Math3DCache.getVector3f();
        Vector3f rotation = Math3DCache.getVector3f();
        try {
            i_position3D.getAbsolute(absNew);
            location.set(absNew.getLocation3D());
            rotation.set(absNew.getRotation3D());
            Position3D parentPosition = this.getParentPosition();
            if (parentPosition != null) {
                IMatrix4f m = parentPosition.getRotationLocationMatrix();
                Matrix4f inv = Math3D.invert(m, null);
                location.transform(inv);
                parentPosition.getAbsolute(absParent);
                Math3D.sub(rotation, absParent.getRotation3D(), rotation);
            }
            this.setLocation3D(location);
            this.setRotation3D(rotation);
            this.setSize3D(i_position3D.getSize3D());
        }
        catch (Throwable throwable) {
            Math3DCache.returnPosition3D(absNew, absParent);
            Math3DCache.returnVector3f(location, rotation);
            throw throwable;
        }
        Math3DCache.returnPosition3D(absNew, absParent);
        Math3DCache.returnVector3f(location, rotation);
    }

    public void setRotation3D(IVector3f i_rotation) {
        if (i_rotation == null) {
            throw new NullPointerException("i_rotation must not be null");
        }
        if (this.m_rotationAngles.equals(i_rotation)) {
            return;
        }
        Vector3fImpl delta = new Vector3fImpl();
        Math3D.sub(i_rotation, this.m_rotationAngles, delta);
        this.m_rotationAngles.set(i_rotation);
        this.invalidate();
        this.firePositionChanged(IPosition3D.PositionHint.ROTATION, delta);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("l=").append(this.getLocation3D());
        result.append(", s=").append(this.getSize3D());
        result.append(", r=").append(this.getRotation3D());
        result.append(", host=").append(this.getHost());
        return result.toString();
    }

    public boolean transformRay(Vector3f i_origin, Vector3f i_direction) {
        this.validate();
        if (!this.m_invertible) {
            return false;
        }
        i_origin.transform(this.m_rayOriginMatrix);
        i_direction.transform(this.m_rayDirectionMatrix);
        return true;
    }

    private void validate() {
        if (this.isValid()) {
            return;
        }
        Vector3f halfSize = Math3DCache.getVector3f();
        Vector3f location = Math3DCache.getVector3f();
        try {
            Position3D parent = this.getParentPosition();
            if (parent != null) {
                Math3D.transform(this.getLocation3D(), parent.getRotationLocationMatrix(), location);
                this.m_rotationLocationMatrix.set(IMatrix4f.IDENTITY);
                this.m_rotationLocationMatrix.a41 += location.getX();
                this.m_rotationLocationMatrix.a42 += location.getY();
                this.m_rotationLocationMatrix.a43 += location.getZ();
                this.m_absoluteRotationMatrix.set(parent.getAbsoluteRotationMatrix());
            } else {
                Math3D.translate(IMatrix4f.IDENTITY, this.getLocation3D(), this.m_rotationLocationMatrix);
                this.m_absoluteRotationMatrix.setIdentity();
            }
            if (!IVector3f.NULLVEC3f.equals(this.getRotation3D())) {
                Math3D.rotate(this.getRotation3D(), this.m_rotationLocationMatrix, this.m_rotationLocationMatrix);
                Math3D.rotate(this.getRotation3D(), this.m_absoluteRotationMatrix, this.m_absoluteRotationMatrix);
            }
            this.m_transformationMatrix.set(this.m_rotationLocationMatrix);
            Math3D.scale(this.getSize3D(), this.m_transformationMatrix, this.m_transformationMatrix);
            if (this.getSize3D().getX() == 0.0f || this.getSize3D().getY() == 0.0f || this.getSize3D().getZ() == 0.0f) {
                this.m_invertible = false;
            } else {
                this.m_invertible = true;
                Math3D.invert(this.m_transformationMatrix, this.m_rayOriginMatrix);
                Math3D.scale(this.getSize3D(), this.m_absoluteRotationMatrix, this.m_rayDirectionMatrix);
                Math3D.invert(this.m_rayDirectionMatrix, this.m_rayDirectionMatrix);
            }
            this.m_center.set(0.5f, 0.5f, 0.5f);
            this.m_center.transform(this.m_transformationMatrix);
            this.m_valid = true;
        }
        catch (Throwable throwable) {
            Math3DCache.returnVector3f(halfSize, location);
            throw throwable;
        }
        Math3DCache.returnVector3f(halfSize, location);
    }
}

