/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.vis;

import org.ascape.util.vis.DrawFeature;
import org.ascape.util.vis.Drawable;
import org.eclipse.draw2d.Graphics;

public abstract class DrawSymbol
extends DrawFeature
implements Drawable {
    private static final long serialVersionUID = 1L;
    public static final DrawSymbol FILL_RECT = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.fillRectangle(0, 0, width - 1, height - 1);
        }
    };
    public static final DrawSymbol DRAW_RECT = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.drawRectangle(0, 0, width - 1, height - 1);
        }
    };
    public static final DrawSymbol DRAW_RECT_2 = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.drawRectangle(0, 0, width - 1, height - 1);
            g.drawRectangle(1, 1, width - 3, height - 3);
        }
    };
    public static final DrawSymbol FILL_OVAL = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.fillOval(0, 0, width - 1, height - 1);
        }
    };
    public static final DrawSymbol DRAW_OVAL_2 = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.drawOval(0, 0, width - 1, height - 1);
            g.drawOval(1, 1, width - 3, height - 3);
        }
    };
    public static final DrawSymbol DRAW_OVAL = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.drawOval(0, 0, width - 1, height - 1);
        }
    };
    public static final DrawSymbol DRAW_OVOID = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.drawLine(0, 1, 0, height - 2);
            g.drawLine(1, 0, width - 2, 0);
            g.drawLine(width - 1, 1, width - 1, height - 2);
            g.drawLine(1, height - 1, width - 2, height - 1);
        }
    };
    public static final DrawSymbol FILL_OVOID = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.fillRectangle(1, 1, width - 2, height - 2);
        }
    };
    public static final DrawSymbol DRAW_X = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            g.drawLine(0, 0, width - 1, height - 1);
            g.drawLine(width - 1, 0, 0, height - 1);
        }
    };
    public static final DrawSymbol DRAW_HATCH = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            int x = 0;
            while (x < width) {
                g.drawLine(x, 0, x, height);
                x += 2;
            }
            int y = 0;
            while (y < height) {
                g.drawLine(0, y, width, y);
                y += 2;
            }
        }
    };
    public static final DrawSymbol DRAW_HATCH_G1_W2 = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            int x = 0;
            while (x - 1 < width) {
                g.drawLine(x, 0, x, height);
                g.drawLine(x + 1, 0, x + 1, height);
                x += 3;
            }
            int y = 0;
            while (y - 1 < height) {
                g.drawLine(0, y, width, y);
                g.drawLine(0, y + 1, width, y + 1);
                y += 3;
            }
        }
    };
    public static final DrawSymbol DRAW_HATCH_G2_W1 = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            int x = 0;
            while (x < width) {
                g.drawLine(x, 0, x, height);
                x += 3;
            }
            int y = 0;
            while (y < height) {
                g.drawLine(0, y, width, y);
                y += 3;
            }
        }
    };
    public static final DrawSymbol DRAW_HATCH_G2_W2 = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            int x = 0;
            while (x < width - 1) {
                g.drawLine(x, 0, x, height);
                g.drawLine(x + 1, 0, x + 1, height);
                x += 4;
            }
            int y = 0;
            while (y < height - 1) {
                g.drawLine(0, y + 1, width, y + 1);
                g.drawLine(0, y + 1, width, y + 1);
                y += 4;
            }
        }
    };
    public static final DrawSymbol DRAW_HATCH_G3_W1 = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            int x = 0;
            while (x < width) {
                g.drawLine(x, 0, x, height);
                x += 4;
            }
            int y = 0;
            while (y < height) {
                g.drawLine(0, y, width, y);
                y += 4;
            }
        }
    };
    public static final DrawSymbol DRAW_HATCH_G3_W2 = new DrawSymbol(){
        private static final long serialVersionUID = 1L;

        public void draw(Graphics g, int width, int height) {
            int x = 0;
            while (x < width) {
                g.drawLine(x, 0, x, height);
                g.drawLine(x + 1, 0, x + 1, height);
                x += 5;
            }
            int y = 0;
            while (y < height) {
                g.drawLine(0, y, width, y);
                g.drawLine(0, y + 1, width, y + 1);
                y += 5;
            }
        }
    };

    public final void draw(Graphics g, Object object, int width, int height) {
        this.draw(g, width, height);
    }
}

