/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.adata;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScaleType implements Enumerator
{
    INDIVIDUAL(0, "Individual", "INDIVIDUAL"),
    COUNT(1, "Count", "COUNT"),
    SUM(2, "Sum", "SUM"),
    AVERAGE(3, "Average", "AVERAGE"),
    MINIMUM(4, "Minimum", "MINIMUM"),
    MAXIMUM(5, "Maximum", "MAXIMUM"),
    STANDARD_DEVIATION(6, "StandardDeviation", "STAMDARD_DEVIATION"),
    VARIANCE(7, "Variance", "VARIANCE"),
    CUSTOM(1000, "Custom", "CUSTOM");

    public static final int INDIVIDUAL_VALUE = 0;
    public static final int COUNT_VALUE = 1;
    public static final int SUM_VALUE = 2;
    public static final int AVERAGE_VALUE = 3;
    public static final int MINIMUM_VALUE = 4;
    public static final int MAXIMUM_VALUE = 5;
    public static final int STANDARD_DEVIATION_VALUE = 6;
    public static final int VARIANCE_VALUE = 7;
    public static final int CUSTOM_VALUE = 1000;
    private static final ScaleType[] VALUES_ARRAY;
    public static final List<ScaleType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ScaleType[]{INDIVIDUAL, COUNT, SUM, AVERAGE, MINIMUM, MAXIMUM, STANDARD_DEVIATION, VARIANCE, CUSTOM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ScaleType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScaleType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScaleType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScaleType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScaleType get(int value) {
        switch (value) {
            case 0: {
                return INDIVIDUAL;
            }
            case 1: {
                return COUNT;
            }
            case 2: {
                return SUM;
            }
            case 3: {
                return AVERAGE;
            }
            case 4: {
                return MINIMUM;
            }
            case 5: {
                return MAXIMUM;
            }
            case 6: {
                return STANDARD_DEVIATION;
            }
            case 7: {
                return VARIANCE;
            }
            case 1000: {
                return CUSTOM;
            }
        }
        return null;
    }

    private ScaleType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

