/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.graphics;

import java.nio.IntBuffer;
import org.eclipse.draw3d.graphics.optimizer.PrimitiveSet;
import org.eclipse.draw3d.graphics.optimizer.classification.PrimitiveClass;
import org.eclipse.draw3d.graphics.optimizer.primitive.OutlineRenderRule;
import org.eclipse.draw3d.graphics.optimizer.primitive.PolylinePrimitive;
import org.eclipse.draw3d.graphics.optimizer.primitive.Primitive;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.ILodHelper;
import org.eclipse.draw3d.graphics3d.lwjgl.graphics.LwjglVertexPrimitiveVBO;
import org.eclipse.draw3d.util.ColorConverter;
import org.eclipse.swt.graphics.Color;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class LwjglPolylineVBO
extends LwjglVertexPrimitiveVBO {
    private float[] m_color = new float[4];
    private IntBuffer m_indexBuffer;
    private IntBuffer m_countBuffer;

    public LwjglPolylineVBO(PrimitiveSet i_primitives) {
        super(i_primitives);
        PrimitiveClass clazz = i_primitives.getPrimitiveClass();
        if (!clazz.isPolyline()) {
            throw new IllegalArgumentException(i_primitives + " does not contain polylines");
        }
        int count = i_primitives.getSize();
        if (count > 1) {
            this.m_indexBuffer = BufferUtils.createIntBuffer((int)count);
            this.m_countBuffer = BufferUtils.createIntBuffer((int)count);
            int index = 0;
            for (Primitive primitive : i_primitives.getPrimitives()) {
                PolylinePrimitive polyline = (PolylinePrimitive)primitive;
                int vertexCount = polyline.getVertexCount();
                this.m_countBuffer.put(vertexCount);
                this.m_indexBuffer.put(index);
                index += vertexCount;
            }
            this.m_indexBuffer.rewind();
            this.m_countBuffer.rewind();
        }
        OutlineRenderRule rule = clazz.getRenderRule().asOutline();
        ColorConverter.toFloatArray((Color)rule.getColor(), (int)rule.getAlpha(), (float[])this.m_color);
    }

    public void dispose() {
        this.m_indexBuffer = null;
        this.m_countBuffer = null;
        super.dispose();
    }

    protected void doRender(Graphics3D i_g3d, ILodHelper i_lodContext) {
        i_g3d.glColor4f(this.m_color);
        GL11.glPolygonMode((int)1032, (int)6913);
        if (this.m_indexBuffer != null && this.m_countBuffer != null) {
            GL14.glMultiDrawArrays((int)3, (IntBuffer)this.m_indexBuffer, (IntBuffer)this.m_countBuffer);
        } else {
            GL11.glDrawArrays((int)3, (int)0, (int)this.getVertexCount());
        }
    }
}

