/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.swt.opengl.GLCanvas;

public class RenderContext {
    private static final Logger log = Logger.getLogger(RenderContext.class.getName());
    private GLCanvas m_Canvas;
    private Graphics3D m_g3d = null;
    private boolean m_redraw2DContent;
    private Map<RenderFragment.RenderType, List<RenderFragment>> m_renderFragments = new HashMap<RenderFragment.RenderType, List<RenderFragment>>();
    private IScene m_scene;

    public void activate() {
        this.m_Canvas.setCurrent();
    }

    public void addRenderFragment(RenderFragment i_fragment) {
        if (i_fragment == null) {
            throw new NullPointerException("i_fragment must not be null");
        }
        RenderFragment.RenderType renderType = i_fragment.getRenderType();
        if (renderType == RenderFragment.RenderType.IGNORE) {
            return;
        }
        List<RenderFragment> list = this.m_renderFragments.get((Object)renderType);
        if (list == null) {
            list = new ArrayList<RenderFragment>();
            this.m_renderFragments.put(renderType, list);
        }
        list.add(i_fragment);
    }

    public void clear() {
        this.m_renderFragments.clear();
        this.m_scene = null;
        this.m_redraw2DContent = false;
    }

    public synchronized void dispose() {
        this.m_g3d.dispose();
    }

    public Graphics3D getGraphics3D() {
        return this.m_g3d;
    }

    public IScene getScene() {
        return this.m_scene;
    }

    public boolean isRedraw2DContent() {
        return this.m_redraw2DContent;
    }

    public void renderFragments() {
        Graphics3D g3d = this.getGraphics3D();
        g3d.glEnable(2929);
        this.renderFragments(RenderFragment.RenderType.OPAQUE);
        this.renderFragments(RenderFragment.RenderType.TRANSPARENT);
        g3d.glDisable(2929);
        try {
            this.renderFragments(RenderFragment.RenderType.SUPERIMPOSED);
        }
        finally {
            g3d.glEnable(2929);
        }
    }

    private void renderFragments(RenderFragment.RenderType i_type) {
        List<RenderFragment> fragments = this.m_renderFragments.get((Object)i_type);
        if (fragments != null) {
            i_type.orderFragments(this, fragments);
            for (RenderFragment fragment : fragments) {
                fragment.render(this);
            }
        }
    }

    public void setCanvas(GLCanvas i_canvas) {
        this.m_Canvas = i_canvas;
    }

    public void setGraphics3D(Graphics3D i_g3d) {
        this.m_g3d = i_g3d;
    }

    public void setRedraw2DContent() {
        this.m_redraw2DContent = true;
    }

    public void setScene(IScene i_scene) {
        this.m_scene = i_scene;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RenderContext[render fragments: ");
        builder.append(this.m_renderFragments.size());
        builder.append("]");
        return builder.toString();
    }
}

