/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnettest;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class DotnetTestDelegate
extends LaunchConfigurationDelegate
implements ILaunchShortcut {
    public static final String CONFIGURATION = "CONFIGURATION";
    public static final String FRAMEWORK = "FRAMEWORK";
    public static final String TEST_SELECTION_TYPE = "TEST_SELECTION_TYPE";
    public static final String TEST_FILTER = "TEST_FILTER";
    public static final String TEST_CLASS = "TEST_CLASS";
    public static final String TEST_METHOD = "TEST_METHOD";
    public static final String PROJECT_BUILD = "PROJECT_BUILD";
    public static final String PROJECT_RESTORE = "PROJECT_RESTORE";
    public static final String ALL_TESTS = "ALL";
    public static final String MATCHING_TESTS = "MATCHING";
    public static final String SELECTED_TEST = "SELECTED";

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                IResource resource = null;
                if (element instanceof IResource) {
                    resource = (IResource)element;
                } else if (element instanceof IAdaptable) {
                    resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
                }
                if (resource == null) continue;
                try {
                    ILaunchConfiguration launchConfig = this.getLaunchConfiguration(mode, resource);
                    launchConfig.launch(mode, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DotnetTestDelegate_runTestError_title, (String)Messages.DotnetTestDelegate_runTestError_message_badSelection));
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        try {
            ILaunchConfiguration launchConfig = this.getLaunchConfiguration(mode, (IResource)file);
            launchConfig.launch(mode, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String projectLocation = configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "");
        String projectConfiguration = configuration.getAttribute(CONFIGURATION, "Debug");
        String projectFramework = configuration.getAttribute(FRAMEWORK, "");
        String testSelectionMethod = configuration.getAttribute(TEST_SELECTION_TYPE, ALL_TESTS);
        String selectionFilter = configuration.getAttribute(TEST_FILTER, "");
        String selectionClass = configuration.getAttribute(TEST_CLASS, "");
        String selectionMethod = configuration.getAttribute(TEST_METHOD, "");
        boolean buildProject = configuration.getAttribute(PROJECT_BUILD, true);
        boolean restoreProject = configuration.getAttribute(PROJECT_RESTORE, true);
        File projectFile = new File(projectLocation);
        if (projectFile != null && projectFile.isFile()) {
            projectFile = projectFile.getParentFile();
        }
        if (!projectFile.exists() || projectFile == null) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.DotnetTestDelegate_runTestError_title, (String)Messages.DotnetTestDelegate_runTestError_message_badLocation);
            return;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        try {
            commandList.add(AcutePlugin.getDotnetCommand());
        }
        catch (Exception e) {
            return;
        }
        commandList.add("test");
        if (!projectConfiguration.isEmpty()) {
            commandList.add("-c");
            commandList.add(projectConfiguration);
        }
        if (!projectFramework.isEmpty()) {
            commandList.add("-f");
            commandList.add(projectFramework);
        }
        if (testSelectionMethod.equals(MATCHING_TESTS) && !selectionFilter.isEmpty()) {
            commandList.add("--filter");
            commandList.add(selectionFilter);
        } else if (testSelectionMethod.equals(SELECTED_TEST) && !selectionClass.isEmpty()) {
            commandList.add("--filter");
            if (selectionMethod.isEmpty()) {
                commandList.add("FullyQualifiedName~" + selectionClass);
            } else {
                commandList.add("FullyQualifiedName=" + selectionClass + "." + selectionMethod);
            }
        }
        if (!buildProject) {
            commandList.add("--no-build");
        }
        if (!restoreProject) {
            commandList.add("--no-restore");
        }
        Process p = DebugPlugin.exec((String[])commandList.toArray(new String[commandList.size()]), (File)projectFile);
        DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)"dotnet test");
    }

    private ILaunchConfiguration getLaunchConfiguration(String mode, IResource resource) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType("org.eclipse.acute.dotnettest.DotnetTestDelegate");
        try {
            ILaunchConfiguration[] launchConfigurations = launchManager.getLaunchConfigurations(configType);
            String configName = resource.getLocation().toFile().isFile() ? NLS.bind((String)Messages.DotnetTestDelegate_configuration, (Object)(String.valueOf(resource.getParent().getName()) + "." + resource.getName())) : NLS.bind((String)Messages.DotnetTestDelegate_configuration, (Object)resource.getName());
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations;
            int n = launchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration iLaunchConfiguration = iLaunchConfigurationArray[n2];
                if (iLaunchConfiguration.getName().equals(configName) && iLaunchConfiguration.getModes().contains(mode)) {
                    return iLaunchConfiguration;
                }
                ++n2;
            }
            configName = launchManager.generateLaunchConfigurationName(configName);
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, configName);
            if (resource.getLocation().toFile().isFile()) {
                if (resource.getFileExtension().equals("cs")) {
                    wc.setAttribute(TEST_SELECTION_TYPE, SELECTED_TEST);
                    wc.setAttribute(TEST_CLASS, resource.getName().replaceFirst("\\.cs$", ""));
                }
                resource = resource.getParent();
            }
            wc.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", resource.getLocation().toString());
            return wc;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

