/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnetnew;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DotnetNewAccessor {
    public static List<Template> getTemplates() {
        try {
            ArrayList<Template> templates = new ArrayList<Template>();
            String listCommand = String.valueOf(AcutePlugin.getDotnetCommand()) + " new --list";
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(listCommand);
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String inputLine;
                Boolean templateListExists = false;
                while ((inputLine = in.readLine()) != null) {
                    if (!inputLine.matches("^-{30,}$")) continue;
                    templateListExists = true;
                    break;
                }
                if (templateListExists.booleanValue()) {
                    while ((inputLine = in.readLine()) != null) {
                        String[] languages;
                        String[] template = inputLine.split("[\\s]{2,}");
                        if (template.length == 3) {
                            templates.add(new Template(template[0], template[1]));
                            continue;
                        }
                        if (template.length <= 3) break;
                        String[] stringArray = languages = template[2].split(",");
                        int n = languages.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String languageStringDirty = stringArray[n2];
                            String languageString = languageStringDirty.replaceAll("[\\s\\[\\]]", "");
                            templates.add(new Template(template[0], template[1], languageString));
                            ++n2;
                        }
                    }
                }
                return templates;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    public static class Template {
        public final @NonNull String id;
        public final @NonNull String label;
        public final @Nullable String languageString;

        public Template(@NonNull String label, @NonNull String id) {
            this(label, id, null);
        }

        public Template(@NonNull String label, @NonNull String id, @Nullable String languageString) {
            this.label = label;
            this.id = id;
            this.languageString = languageString;
        }

        public String toString() {
            if (this.languageString == null) {
                return this.label;
            }
            return String.valueOf(this.label) + " [" + this.languageString + "]";
        }

        public List<String> getCLIOptions() {
            if (this.languageString != null) {
                return Arrays.asList(this.id, "--language", this.languageString);
            }
            return Collections.singletonList(this.id);
        }
    }
}

