/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.themes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.tm4e.ui.internal.themes.ThemeAssociationRegistry;
import org.eclipse.tm4e.ui.themes.ITheme;
import org.eclipse.tm4e.ui.themes.IThemeAssociation;
import org.eclipse.tm4e.ui.themes.IThemeManager;
import org.eclipse.tm4e.ui.themes.ThemeAssociation;

public abstract class AbstractThemeManager
implements IThemeManager {
    private static final String E4_CSS_THEME_PREFERENCE_ID = "org.eclipse.e4.ui.css.swt.theme";
    public static final String E4_THEME_ID = "themeid";
    private static final String E4_DARK = "org.eclipse.e4.ui.css.theme.e4_dark";
    private final Map<String, ITheme> themes = new LinkedHashMap<String, ITheme>();
    private final ThemeAssociationRegistry themeAssociationRegistry = new ThemeAssociationRegistry();

    @Override
    public void registerTheme(ITheme theme) {
        this.themes.put(theme.getId(), theme);
    }

    @Override
    public void unregisterTheme(ITheme theme) {
        this.themes.remove(theme.getId());
    }

    @Override
    public ITheme getThemeById(String themeId) {
        return this.themes.get(themeId);
    }

    @Override
    public ITheme[] getThemes() {
        Collection<ITheme> themes = this.themes.values();
        return themes.toArray(new ITheme[themes.size()]);
    }

    @Override
    public ITheme getDefaultTheme() {
        boolean dark = this.isDarkEclipseTheme();
        return this.getDefaultTheme(dark);
    }

    public ITheme getDefaultTheme(boolean dark) {
        for (ITheme theme : this.themes.values()) {
            if (theme.isDark() != dark || !theme.isDefault()) continue;
            return theme;
        }
        return null;
    }

    @Override
    public ITheme[] getThemes(boolean dark) {
        Collection<ITheme> themes = this.themes.values();
        return themes.stream().filter(theme -> theme.isDark() == dark).collect(Collectors.toList()).toArray(new ITheme[0]);
    }

    @Override
    public String getPreferenceE4CSSThemeId() {
        IEclipsePreferences preferences = this.getPreferenceE4CSSTheme();
        return preferences != null ? preferences.get(E4_THEME_ID, null) : null;
    }

    @Override
    public boolean isDarkEclipseTheme() {
        return this.isDarkEclipseTheme(this.getPreferenceE4CSSThemeId());
    }

    @Override
    public boolean isDarkEclipseTheme(String eclipseThemeId) {
        return E4_DARK.equals(eclipseThemeId);
    }

    protected IEclipsePreferences getPreferenceE4CSSTheme() {
        return InstanceScope.INSTANCE.getNode(E4_CSS_THEME_PREFERENCE_ID);
    }

    @Override
    public ITheme getThemeForScope(String scopeName, boolean dark) {
        IThemeAssociation association = this.themeAssociationRegistry.getThemeAssociationFor(scopeName, dark);
        if (association != null) {
            String themeId = association.getThemeId();
            return this.getThemeById(themeId);
        }
        return this.getDefaultTheme(dark);
    }

    @Override
    public ITheme getThemeForScope(String scopeName) {
        return this.getThemeForScope(scopeName, this.isDarkEclipseTheme());
    }

    @Override
    public IThemeAssociation[] getThemeAssociationsForScope(String scopeName) {
        ArrayList<IThemeAssociation> associations = new ArrayList<IThemeAssociation>();
        IThemeAssociation light = this.themeAssociationRegistry.getThemeAssociationFor(scopeName, false);
        if (light == null) {
            light = new ThemeAssociation(this.getDefaultTheme(false).getId(), scopeName, false);
        }
        associations.add(light);
        IThemeAssociation dark = this.themeAssociationRegistry.getThemeAssociationFor(scopeName, true);
        if (dark == null) {
            dark = new ThemeAssociation(this.getDefaultTheme(true).getId(), scopeName, true);
        }
        associations.add(dark);
        return associations.toArray(new IThemeAssociation[associations.size()]);
    }

    @Override
    public void registerThemeAssociation(IThemeAssociation association) {
        this.themeAssociationRegistry.register(association);
    }

    @Override
    public void unregisterThemeAssociation(IThemeAssociation association) {
        this.themeAssociationRegistry.unregister(association);
    }

    @Override
    public IThemeAssociation[] getAllThemeAssociations() {
        List<IThemeAssociation> associations = this.themeAssociationRegistry.getThemeAssociations();
        return associations.toArray(new IThemeAssociation[associations.size()]);
    }
}

