/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.IAcceleoLanguageServerContext;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class AcceleoSocketServer {
    private static final int BACKLOG = 50;
    private final IAcceleoLanguageServerContext acceleoLanguageServerContext;
    private ServerSocket serverSocket;
    private Thread serverThread;

    public AcceleoSocketServer(IAcceleoLanguageServerContext acceleoLanguageServerContext) {
        this.acceleoLanguageServerContext = acceleoLanguageServerContext;
    }

    public synchronized void start(String host) throws UnknownHostException, IOException {
        this.serverSocket = new ServerSocket(0, 50, InetAddress.getByName(host));
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Socket client = AcceleoSocketServer.this.serverSocket.accept();
                    AcceleoLanguageServer acceleoLanguageServer = new AcceleoLanguageServer(AcceleoSocketServer.this.acceleoLanguageServerContext);
                    Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)acceleoLanguageServer, (InputStream)client.getInputStream(), (OutputStream)client.getOutputStream());
                    launcher.startListening();
                    acceleoLanguageServer.connect((LanguageClient)launcher.getRemoteProxy());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, "Acceleo LS: " + this.serverSocket.getInetAddress().getHostName() + ":" + this.serverSocket.getLocalPort());
        this.serverThread.start();
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public synchronized void stop() throws IOException {
        this.serverSocket.close();
        this.serverThread.interrupt();
    }
}

