/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.completeocl.internal;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.InterpreterContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;

public class CompleteOCLCompilationTask
implements Callable<CompilationResult> {
    private final InterpreterContext context;
    private final EmbeddedXtextEditor editor;

    public CompleteOCLCompilationTask(InterpreterContext context, EmbeddedXtextEditor editor) {
        this.context = context;
        this.editor = editor;
    }

    @Override
    public CompilationResult call() throws Exception {
        boolean nothingToCompile;
        this.checkCancelled();
        boolean bl = nothingToCompile = this.context.getExpression() == null || this.context.getExpression().length() == 0;
        if (nothingToCompile) {
            return null;
        }
        XtextResource resource = this.editor.getResource();
        Model root = null;
        CompilationResult compilationResult = null;
        if (resource != null) {
            Element pivotElement;
            IParseResult result = resource.getParseResult();
            if (result != null && result.getRootASTElement() instanceof Pivotable && (pivotElement = ((Pivotable)result.getRootASTElement()).getPivot()) instanceof Model) {
                root = (Model)pivotElement;
            }
            IStatus status = CompleteOCLCompilationTask.parseProblems((Resource)resource);
            if (root == null) {
                Object actualStatus = status.getSeverity() != 4 ? new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Unexpected error while parsing expression.") : status;
                compilationResult = new CompilationResult(actualStatus);
            } else {
                compilationResult = new CompilationResult(root, status);
            }
        } else {
            compilationResult = new CompilationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", "Unexpected error while parsing expression."));
        }
        return compilationResult;
    }

    private static IStatus parseProblems(Resource resource) {
        ArrayList<Status> problems = new ArrayList<Status>();
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            problems.add(new Status(4, "org.eclipse.acceleo.ui.interpreter.completeocl", diagnostic.getMessage()));
        }
        for (Resource.Diagnostic diagnostic : resource.getWarnings()) {
            problems.add(new Status(2, "org.eclipse.acceleo.ui.interpreter.completeocl", diagnostic.getMessage()));
        }
        if (problems.isEmpty()) {
            return null;
        }
        MultiStatus status = new MultiStatus("org.eclipse.acceleo.ui.interpreter.completeocl", 1, "Problems encountered while compiling expression.", null);
        for (IStatus iStatus : problems) {
            status.add(iStatus);
        }
        return status;
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }
}

