/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.impl.AbstractLanguageServices;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.ScopedEnvironment;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class EvaluationServices
extends AbstractLanguageServices {
    private static final String SERVICE_RETURNED_NULL = "Service %s returned a null value";
    private static final String INTERNAL_ERROR_MSG = "An internal error occured during evaluation of a query";

    public EvaluationServices(IQueryEnvironment queryEnv) {
        super(queryEnv);
    }

    public Object getVariableValue(ScopedEnvironment variableDefinitions, String variableName, Diagnostic diagnostic) {
        try {
            Object result = variableDefinitions.getVariableValue(variableName);
            if (result == null) {
                Nothing placeHolder = this.nothing("Couldn't find the %s variable", variableName);
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
                result = placeHolder;
            }
            return result;
        }
        catch (NullPointerException e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public Object featureAccess(Object context, String featureName, Diagnostic diagnostic) {
        Object result;
        if (context instanceof EObject) {
            EClass eClass = ((EObject)context).eClass();
            EStructuralFeature feature = eClass.getEStructuralFeature(featureName);
            if (feature == null) {
                Nothing placeHolder = this.nothing("Feature %s not found in EClass %s", featureName, eClass.getName());
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
                result = placeHolder;
            } else {
                result = ((EObject)context).eGet(feature);
            }
        } else if (context instanceof List) {
            result = this.applyGetFeatureOnSequence((List)context, featureName, diagnostic);
        } else if (context instanceof Set) {
            result = this.applyGetFeatureOnSet((Set)context, featureName, diagnostic);
        } else if (context != null) {
            Nothing placeHolder = this.nothing("Attempt to access feature (%s) on a non ModelObject value (%s).", featureName, context.getClass().getCanonicalName());
            this.addDiagnosticFor(diagnostic, 2, placeHolder);
            result = placeHolder;
        } else {
            Nothing placeHolder = this.nothing("Attempt to access feature (%s) on a non ModelObject value (%s).", featureName, "null");
            this.addDiagnosticFor(diagnostic, 2, placeHolder);
            result = placeHolder;
        }
        return result;
    }

    private Object applyGetFeatureOnSet(Set<Object> context, String featureName, Diagnostic diagnostic) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>(context.size());
        for (Object element : context) {
            Object newElt = this.featureAccess(element, featureName, diagnostic);
            if (newElt instanceof Nothing) continue;
            if (newElt instanceof Collection) {
                result.addAll((Collection)newElt);
                continue;
            }
            result.add(newElt);
        }
        return result;
    }

    private Object applyGetFeatureOnSequence(List<Object> context, String featureName, Diagnostic diagnostic) {
        ArrayList<Object> result = new ArrayList<Object>(context.size());
        for (Object element : context) {
            Object newElt = this.featureAccess(element, featureName, diagnostic);
            if (newElt instanceof Nothing) continue;
            if (newElt instanceof Collection) {
                result.addAll((Collection)newElt);
                continue;
            }
            result.add(newElt);
        }
        return result;
    }

    private Nothing nothing(String message, Object ... msgArgs) {
        String formatedMessage = String.format(message, msgArgs);
        return new Nothing(formatedMessage);
    }

    private Nothing nothing(String serviceName, Class<?>[] parameterTypes, Exception e) {
        Throwable cause = e instanceof InvocationTargetException && e.getCause() != null ? e.getCause() : e;
        String message = "Exception while calling " + this.serviceSignature(serviceName, parameterTypes);
        return new Nothing(message, cause);
    }

    private Class<?>[] getArgumentTypes(Object[] arguments) {
        Class[] argumentTypes = new Class[arguments.length];
        int i = 0;
        while (i < arguments.length) {
            argumentTypes[i] = arguments[i] == null ? null : arguments[i].getClass();
            ++i;
        }
        return argumentTypes;
    }

    private Object callService(IService service, Object[] arguments, Diagnostic diagnostic) {
        Method method = service.getServiceMethod();
        try {
            Object result = method.invoke(service.getServiceInstance(), arguments);
            if (result == null) {
                Object[] argumentTypes = this.getArgumentTypes(arguments);
                Nothing placeHolder = this.nothing(SERVICE_RETURNED_NULL, this.serviceSignature(method.getName(), argumentTypes));
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
            }
            return result;
        }
        catch (Exception e) {
            Class<?>[] argumentTypes = this.getArgumentTypes(arguments);
            Nothing placeHolder = this.nothing(service.getServiceMethod().getName(), argumentTypes, e);
            this.addDiagnosticFor(diagnostic, 2, placeHolder);
            return placeHolder;
        }
    }

    public Object call(String serviceName, Object[] arguments, Diagnostic diagnostic) {
        Object result;
        if (arguments.length == 0) {
            throw new AcceleoQueryEvaluationException("An internal error occured during evaluation of a query : at least one argument must be specified for service " + serviceName + ".");
        }
        try {
            Object[] argumentTypes = this.getArgumentTypes(arguments);
            IService service = this.queryEnvironment.getLookupEngine().lookup(serviceName, (Class<?>[])argumentTypes);
            if (service == null) {
                if (arguments[0] instanceof EObject) {
                    result = this.callEOperation(serviceName, arguments, diagnostic);
                } else {
                    Nothing placeHolder = this.nothing("Couldn't find the %s service", this.serviceSignature(serviceName, argumentTypes));
                    this.addDiagnosticFor(diagnostic, 2, placeHolder);
                    result = placeHolder;
                }
            } else {
                result = this.callService(service, arguments, diagnostic);
            }
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
        return result;
    }

    private Object callEOperation(String operationName, Object[] parameters, Diagnostic diagnostic) throws InvocationTargetException {
        Object result;
        Object[] arguments = Arrays.copyOfRange(parameters, 1, parameters.length);
        List eClassifiers = this.getEParameters(arguments);
        EOperation eOperation = null;
        Object receiver = parameters[0];
        if (parameters.length > 1) {
            CombineIterator it = new CombineIterator(eClassifiers);
            while (eOperation == null && it.hasNext()) {
                eOperation = this.queryEnvironment.getEPackageProvider().lookupEOperation(((EObject)receiver).eClass(), operationName, (List)it.next());
            }
        } else {
            eOperation = this.queryEnvironment.getEPackageProvider().lookupEOperation(((EObject)receiver).eClass(), operationName, new ArrayList<EParameter>());
        }
        if (eOperation != null) {
            BasicEList eArguments = new BasicEList();
            int i = 1;
            while (i < parameters.length) {
                eArguments.add(parameters[i]);
                ++i;
            }
            result = this.hasEInvoke(receiver) ? ((EObject)receiver).eInvoke(eOperation, (EList)eArguments) : this.eOperationJavaInvoke(operationName, receiver, arguments, diagnostic);
        } else {
            Object[] argumentTypes = this.getArgumentTypes(parameters);
            Nothing placeHolder = this.nothing("Couldn't find the %s service or EOperation", this.serviceSignature(operationName, argumentTypes));
            this.addDiagnosticFor(diagnostic, 2, placeHolder);
            result = placeHolder;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object eOperationJavaInvoke(String operationName, Object receiver, Object[] arguments, Diagnostic diagnostic) throws InvocationTargetException {
        Object result;
        Object[] argumentTypes = this.getArgumentTypes(arguments);
        Object invokeResult = null;
        try {
            try {
                Method method = receiver.getClass().getMethod(operationName, (Class<?>[])argumentTypes);
                invokeResult = method.invoke(receiver, arguments);
                return result;
            }
            catch (NoSuchMethodException e) {
                Nothing placeHolder = this.nothing("Couldn't invoke the %s EOperation (%s)", this.serviceSignature(operationName, argumentTypes), e.getMessage());
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
                result = invokeResult = placeHolder;
                return result;
            }
            catch (SecurityException e) {
                Nothing placeHolder = this.nothing("Couldn't invoke the %s EOperation (%s)", this.serviceSignature(operationName, argumentTypes), e.getMessage());
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
                result = invokeResult = placeHolder;
                return result;
            }
            catch (IllegalAccessException e) {
                Nothing placeHolder = this.nothing("Couldn't invoke the %s EOperation (%s)", this.serviceSignature(operationName, argumentTypes), e.getMessage());
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
                result = invokeResult = placeHolder;
                return result;
            }
            catch (IllegalArgumentException e) {
                Nothing placeHolder = this.nothing("Couldn't invoke the %s EOperation (%s)", this.serviceSignature(operationName, argumentTypes), e.getMessage());
                this.addDiagnosticFor(diagnostic, 2, placeHolder);
                result = invokeResult = placeHolder;
                return result;
            }
        }
        finally {
            result = invokeResult;
        }
    }

    private boolean hasEInvoke(Object object) {
        Method method = null;
        try {
            method = object.getClass().getDeclaredMethod("eInvoke", Integer.TYPE, EList.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {}
        return method != null;
    }

    private List<Set<EParameter>> getEParameters(Object[] objects) {
        ArrayList<Set<EParameter>> result = new ArrayList<Set<EParameter>>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            EParameter parameter;
            Object object = objectArray[n2];
            LinkedHashSet<EParameter> eParamters = new LinkedHashSet<EParameter>();
            if (object instanceof List) {
                parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
                parameter.setUpperBound(-1);
                parameter.setEType(null);
                eParamters.add(parameter);
            } else if (object instanceof EObject) {
                parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
                parameter.setEType((EClassifier)((EObject)object).eClass());
                eParamters.add(parameter);
            } else if (object != null) {
                for (EClassifier eClassifier : this.queryEnvironment.getEPackageProvider().getEClass(object.getClass())) {
                    EParameter parameter2 = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
                    parameter2.setEType(eClassifier);
                    eParamters.add(parameter2);
                }
            } else {
                parameter = EcorePackage.eINSTANCE.getEcoreFactory().createEParameter();
                parameter.setEType(null);
                eParamters.add(parameter);
            }
            result.add(eParamters);
            ++n2;
        }
        return result;
    }

    public Object callOrApply(String serviceName, Object[] arguments, Diagnostic diagnostic) {
        try {
            Object result;
            if (arguments[0] instanceof List) {
                List list = (List)arguments[0];
                result = this.applyCallOnSequence(serviceName, list, arguments, diagnostic);
            } else if (arguments[0] instanceof Set) {
                Set set = (Set)arguments[0];
                result = this.applyCallOnSet(serviceName, set, arguments, diagnostic);
            } else {
                result = this.call(serviceName, arguments, diagnostic);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public Object collectionServiceCall(String serviceName, Object[] arguments, Diagnostic diagnostic) {
        try {
            Object[] newArguments;
            LinkedHashSet receiver = arguments[0];
            if (!(receiver instanceof Collection) && !(receiver instanceof Nothing)) {
                LinkedHashSet newReceiver = new LinkedHashSet();
                newReceiver.add(receiver);
                receiver = newReceiver;
                newArguments = (Object[])arguments.clone();
                newArguments[0] = newReceiver;
            } else {
                newArguments = arguments;
            }
            return this.call(serviceName, newArguments, diagnostic);
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private Object applyCallOnSequence(String serviceName, List<Object> origin, Object[] arguments, Diagnostic diagnostic) {
        try {
            ArrayList<Object> result = new ArrayList<Object>(origin.size());
            Object[] innerArguments = (Object[])arguments.clone();
            Iterator<Object> iterator = origin.iterator();
            while (iterator.hasNext()) {
                Object obj;
                innerArguments[0] = obj = iterator.next();
                Object newResult = this.callOrApply(serviceName, innerArguments, diagnostic);
                if (newResult instanceof Nothing) continue;
                if (newResult instanceof Collection) {
                    result.addAll((Collection)newResult);
                    continue;
                }
                if (newResult == null) continue;
                result.add(newResult);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException("empty argument array passed to callOrApply", e);
        }
    }

    private Object applyCallOnSet(String serviceName, Set<Object> origin, Object[] arguments, Diagnostic diagnostic) {
        try {
            LinkedHashSet<Object> result = new LinkedHashSet<Object>(origin.size());
            Object[] innerArguments = (Object[])arguments.clone();
            Iterator<Object> iterator = origin.iterator();
            while (iterator.hasNext()) {
                Object obj;
                innerArguments[0] = obj = iterator.next();
                Object newResult = this.callOrApply(serviceName, innerArguments, diagnostic);
                if (newResult instanceof Nothing) continue;
                if (newResult instanceof Collection) {
                    result.addAll((Collection)newResult);
                    continue;
                }
                if (newResult == null) continue;
                result.add(newResult);
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryEvaluationException(INTERNAL_ERROR_MSG, e);
        }
    }

    protected String serviceSignature(String serviceName, Object[] argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(serviceName).append('(');
        boolean first = true;
        Object[] objectArray = argumentTypes;
        int n = argumentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Object argType = objectArray[n2];
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            if (argType instanceof Class) {
                builder.append(((Class)argType).getCanonicalName());
            } else if (argType instanceof EClass) {
                builder.append("EClass=" + ((EClass)argType).getName());
            } else if (argType == null) {
                builder.append("Object=null");
            } else {
                builder.append("Object=" + argType.toString());
            }
            ++n2;
        }
        return builder.append(')').toString();
    }

    private void addDiagnosticFor(Diagnostic chain, int severity, Nothing nothing) {
        if (chain instanceof DiagnosticChain) {
            BasicDiagnostic child = new BasicDiagnostic(severity, "org.eclipse.acceleo.query", 0, nothing.getMessage(), new Object[]{nothing.getCause()});
            ((DiagnosticChain)chain).add((Diagnostic)child);
        }
    }
}

