/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.ocl;

import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.eclipse.acceleo.ui.interpreter.language.CompilationResult;
import org.eclipse.acceleo.ui.interpreter.language.InterpreterContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.context.EInvocationContext;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.examples.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLCompilationTask
implements Callable<CompilationResult> {
    private final InterpreterContext context;
    private final EmbeddedXtextEditor editor;
    private final MetaModelManager metaModelManager;

    public OCLCompilationTask(InterpreterContext context, EmbeddedXtextEditor editor, MetaModelManager metaModelManager) {
        this.context = context;
        this.editor = editor;
        this.metaModelManager = metaModelManager;
    }

    @Override
    public CompilationResult call() throws Exception {
        this.checkCancelled();
        boolean nothingToCompile = this.context.getExpression() == null || this.context.getExpression().length() == 0;
        boolean noContext = this.context.getTargetEObjects().isEmpty();
        if (nothingToCompile || noContext) {
            CompilationResult shortcut = null;
            if (noContext) {
                shortcut = new CompilationResult((IStatus)new Status(1, "org.eclipse.acceleo.ui.interpreter.ocl", "No context selected."));
            }
            return shortcut;
        }
        EObject evaluationTarget = (EObject)this.context.getTargetEObjects().get(0);
        ExpressionInOCL expressionInOCL = null;
        CompilationResult compilationResult = null;
        XtextResource resource = this.editor.getResource();
        if (resource instanceof XtextResource) {
            Element pivotElement;
            this.refreshEditor(evaluationTarget);
            this.checkCancelled();
            IParseResult result = resource.getParseResult();
            if (result != null && result.getRootASTElement() instanceof Pivotable && (pivotElement = ((Pivotable)result.getRootASTElement()).getPivot()) instanceof ExpressionInOCL) {
                expressionInOCL = (ExpressionInOCL)pivotElement;
            }
        }
        if (expressionInOCL == null) {
            compilationResult = new CompilationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.ocl", "Unexpected error while parsing expression."));
        } else {
            IStatus status = this.parseProblems((Resource)resource);
            compilationResult = new CompilationResult(expressionInOCL, status);
        }
        return compilationResult;
    }

    private IStatus parseProblems(Resource resource) {
        ArrayList<Status> problems = new ArrayList<Status>();
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            problems.add(new Status(4, "org.eclipse.acceleo.ui.interpreter.ocl", diagnostic.getMessage()));
        }
        for (Resource.Diagnostic diagnostic : resource.getWarnings()) {
            problems.add(new Status(2, "org.eclipse.acceleo.ui.interpreter.ocl", diagnostic.getMessage()));
        }
        if (problems.isEmpty()) {
            return null;
        }
        MultiStatus status = new MultiStatus("org.eclipse.acceleo.ui.interpreter.ocl", 1, "Problems encountered while compiling expression.", null);
        for (IStatus iStatus : problems) {
            status.add(iStatus);
        }
        return status;
    }

    private void refreshEditor(EObject target) {
        final DocumentRefresher refresher = new DocumentRefresher(this.editor, this.metaModelManager, target);
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    OCLCompilationTask.this.editor.getDocument().modify(refresher);
                }
            });
        } else {
            this.editor.getDocument().modify((IUnitOfWork)refresher);
        }
    }

    private void checkCancelled() {
        if (Thread.currentThread().isInterrupted()) {
            throw new CancellationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocumentRefresher
    implements IUnitOfWork<Object, XtextResource> {
        private final EmbeddedXtextEditor editor;
        private final MetaModelManager metaModelManager;
        private final EObject target;

        public DocumentRefresher(EmbeddedXtextEditor editor, MetaModelManager metaModelManager, EObject target) {
            this.editor = editor;
            this.metaModelManager = metaModelManager;
            this.target = target;
        }

        public Value exec(XtextResource resource) throws Exception {
            EClass contextClassifier = this.target.eClass();
            EssentialOCLCSResource csResource = (EssentialOCLCSResource)resource;
            if (csResource != null) {
                EInvocationContext context;
                if (csResource.getParserContext() instanceof EInvocationContext && (context = (EInvocationContext)csResource.getParserContext()).getClassContext().getETarget().equals(contextClassifier)) {
                    return null;
                }
                csResource.setParserContext((ParserContext)new EInvocationContext(this.metaModelManager, resource.getURI(), (EClassifier)contextClassifier, null));
                csResource.reparse(this.editor.getDocument().get());
            }
            return null;
        }
    }
}

