/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.ocl;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import org.eclipse.acceleo.ui.interpreter.language.EvaluationResult;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;

public abstract class AbstractOCLEvaluator {
    protected abstract MetaModelManager getMetaModelManager();

    public EvaluationResult evaluateExpression(ExpressionInOCL expression, EObject evaluationTarget) {
        EvaluationVisitor visitor = this.createEvaluationVisitor(expression, evaluationTarget);
        try {
            Object value = visitor.visitExpressionInOCL(expression);
            EvaluationResult result = value instanceof Value ? new EvaluationResult(this.unwrap((Value)value)) : new EvaluationResult(value);
            return result;
        }
        catch (InvalidValueException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            return new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.ocl", message, (Throwable)e));
        }
    }

    public EvaluationResult evaluateExpression(OCLExpression expression, EObject evaluationTarget) {
        EvaluationResult result = this.internalEvaluateExpression(expression, evaluationTarget);
        if (result.getEvaluationResult() instanceof Value) {
            result = new EvaluationResult(this.unwrap((Value)result.getEvaluationResult()));
        }
        return result;
    }

    protected EvaluationResult internalEvaluateExpression(OCLExpression expression, EObject evaluationTarget) {
        OCLExpression current = expression;
        ArrayList<LetExp> letInContext = new ArrayList<LetExp>();
        while (current != null && !(current instanceof ExpressionInOCL)) {
            if (current instanceof LetExp) {
                letInContext.add((LetExp)current);
            }
            current = current.eContainer();
        }
        if (!(current instanceof ExpressionInOCL)) {
            return new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.ocl", "Compilation error in expression."));
        }
        ExpressionInOCL rootExpression = (ExpressionInOCL)current;
        EvaluationVisitor visitor = this.createEvaluationVisitor(rootExpression, evaluationTarget);
        EvaluationResult result = null;
        try {
            ListIterator letIterator = letInContext.listIterator(letInContext.size());
            while (letIterator.hasPrevious()) {
                LetExp let = (LetExp)letIterator.previous();
                Object variableValue = let.getVariable().accept((Visitor)visitor);
                visitor.getEvaluationEnvironment().add((DomainTypedElement)let.getVariable(), variableValue);
            }
            Object value = expression.accept((Visitor)visitor);
            result = new EvaluationResult(value);
        }
        catch (InvalidValueException e) {
            String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            result = new EvaluationResult((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter.ocl", message, (Throwable)e));
        }
        return result;
    }

    private EvaluationVisitor createEvaluationVisitor(ExpressionInOCL expression, EObject evaluationTarget) {
        PivotEnvironmentFactory environmentFactory = new PivotEnvironmentFactory(null, this.getMetaModelManager());
        PivotEnvironment environment = environmentFactory.createEnvironment();
        EvaluationEnvironment evaluationEnvironment = environmentFactory.createEvaluationEnvironment();
        Object contextValue = this.getMetaModelManager().getIdResolver().boxedValueOf((Object)evaluationTarget);
        evaluationEnvironment.add((DomainTypedElement)expression.getContextVariable(), contextValue);
        DomainModelManager modelManager = evaluationEnvironment.createModelManager((Object)evaluationTarget);
        return new EvaluationVisitorImpl((Environment)environment, evaluationEnvironment, modelManager);
    }

    protected Object unwrap(Value value) {
        AbstractCollection realObject = value.asObject();
        CollectionValue collectionValue = ValuesUtil.isCollectionValue((Object)value);
        if (collectionValue != null) {
            realObject = collectionValue instanceof OrderedSetValue ? new LinkedHashSet() : (collectionValue instanceof SetValue ? new HashSet() : new ArrayList());
            for (Object child : collectionValue.iterable()) {
                ((Collection)realObject).add(child);
            }
        }
        return realObject;
    }
}

