/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.common.internal.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.common.AcceleoCommonPlugin;
import org.eclipse.acceleo.common.internal.utils.AcceleoDynamicMetamodelResourceSetImpl;
import org.eclipse.acceleo.common.internal.utils.LazyEPackageDescriptor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoPackageRegistry
extends HashMap<String, Object>
implements EPackage.Registry {
    public static final AcceleoPackageRegistry INSTANCE = new AcceleoPackageRegistry();
    private static final long serialVersionUID = 5976916017848022583L;
    private EPackage.Registry delegate = EPackage.Registry.INSTANCE;
    private Map<String, String> dynamicEcorePackagePaths = new HashMap<String, String>();

    private AcceleoPackageRegistry() {
    }

    @Override
    public void clear() {
        super.clear();
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value) || this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        Set dynamicEntries = super.entrySet();
        Set globalEntries = this.delegate.entrySet();
        return new AcceleoMultipleSet<Map.Entry<String, Object>>(dynamicEntries, globalEntries);
    }

    @Override
    public Object get(Object key) {
        Object result = super.get(key);
        if (result == null) {
            result = this.delegate.get(key);
        }
        return result;
    }

    public Map<String, String> getDynamicEcorePackagePaths() {
        return this.dynamicEcorePackagePaths;
    }

    public EFactory getEFactory(String nsURI) {
        Object ePackage;
        if (this.containsKey(nsURI) && (ePackage = this.get(nsURI)) instanceof EPackage) {
            EPackage result = (EPackage)ePackage;
            return result.getEFactoryInstance();
        }
        return this.delegate.getEFactory(nsURI);
    }

    public EPackage getEPackage(String nsURI) {
        EPackage found = null;
        if (this.containsKey(nsURI)) {
            Object ePackage = this.get(nsURI);
            if (ePackage instanceof EPackage) {
                found = (EPackage)ePackage;
            } else if (ePackage instanceof EPackage.Descriptor) {
                found = ((EPackage.Descriptor)ePackage).getEPackage();
            }
        }
        if (found == null && (found = this.delegate.getEPackage(nsURI)) == null && nsURI != null && !nsURI.startsWith("'")) {
            found = this.searchInRegisteredEPackageInstances(nsURI);
        }
        return found;
    }

    private EPackage searchInRegisteredEPackageInstances(String nsURI) {
        Collection<Object> values = this.values();
        for (Object object : values) {
            EPackage ePackage;
            Resource eResource;
            URI uri;
            if (!(object instanceof EPackage) || ((EPackage)object).eResource() == null || (uri = (eResource = (ePackage = (EPackage)object).eResource()).getURI()) == null || !nsURI.equals(uri.toString())) continue;
            return ePackage;
        }
        return null;
    }

    public String getRegisteredEcorePackagePath(String nsURI) {
        return this.dynamicEcorePackagePaths.get(nsURI);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.delegate.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        Set dynamicKeys = super.keySet();
        Set globalKeys = this.delegate.keySet();
        return new AcceleoMultipleSet<String>(dynamicKeys, globalKeys);
    }

    @Override
    public Object put(String key, Object value) {
        if (this.dynamicEcorePackagePaths.containsKey(key)) {
            return super.put(key, value);
        }
        return this.delegate.put((Object)key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public List<String> registerEcorePackages(String pathName, ResourceSet resourceSet) {
        ArrayList<String> res = new ArrayList<String>();
        ArrayList<LazyEPackageDescriptor> descriptors = new ArrayList<LazyEPackageDescriptor>();
        URIConverter converter = resourceSet.getURIConverter();
        if (converter == null) {
            converter = new ExtensibleURIConverterImpl();
        }
        URI metaURI = null;
        if (pathName != null && pathName.endsWith(".ecore") && !pathName.startsWith("http://") && !pathName.endsWith("Ecore.ecore")) {
            metaURI = URI.createURI((String)URI.decode((String)pathName));
            if (!metaURI.isPlatform()) {
                metaURI = URI.createPlatformResourceURI((String)pathName, (boolean)true);
            }
            EList resources = resourceSet.getResources();
            for (Resource resource : resources) {
                if (resource.getURI() == null || !resource.getURI().equals(metaURI)) continue;
                resource.unload();
                try {
                    resource.load(new HashMap());
                }
                catch (IOException e) {
                    AcceleoCommonPlugin.log(e, false);
                }
            }
            descriptors.addAll(LazyEPackageDescriptor.create(metaURI, resourceSet, this));
            if (descriptors.size() == 0) {
                metaURI = URI.createPlatformResourceURI((String)pathName, (boolean)false);
                descriptors.addAll(LazyEPackageDescriptor.create(metaURI, resourceSet, this));
            }
            if (descriptors.size() == 0) {
                metaURI = URI.createPlatformPluginURI((String)pathName, (boolean)false);
                descriptors.addAll(LazyEPackageDescriptor.create(metaURI, resourceSet, this));
            }
        }
        ArrayList<LazyEPackageDescriptor> toRemove = new ArrayList<LazyEPackageDescriptor>();
        for (LazyEPackageDescriptor descriptor : descriptors) {
            if (!"".equals(descriptor.getNsURI())) continue;
            toRemove.add(descriptor);
        }
        descriptors.removeAll(toRemove);
        if (descriptors.size() != 0) {
            this.registerOrReplaceInRegistry(this, metaURI, descriptors);
            for (LazyEPackageDescriptor descriptor : descriptors) {
                res.add(descriptor.getNsURI());
            }
            return res;
        }
        res.add(pathName);
        return res;
    }

    private void registerOrReplaceInRegistry(EPackage.Registry registry, URI resourceURI, List<LazyEPackageDescriptor> descriptors) {
        ArrayList toRemove = Lists.newArrayList();
        LinkedHashSet toUnload = Sets.newLinkedHashSet();
        for (Map.Entry entry : registry.entrySet()) {
            if (!(entry.getValue() instanceof LazyEPackageDescriptor)) continue;
            LazyEPackageDescriptor registered = (LazyEPackageDescriptor)entry.getValue();
            if (registered.getResourceURI().equals(resourceURI)) {
                toRemove.add((String)entry.getKey());
            }
            toUnload.add(registered);
        }
        for (String nsURI : toRemove) {
            registry.remove((Object)nsURI);
        }
        for (LazyEPackageDescriptor descriptor : descriptors) {
            this.registerDescriptorsHierarchy(registry, descriptor);
        }
    }

    private void registerDescriptorsHierarchy(EPackage.Registry registry, LazyEPackageDescriptor descriptor) {
        if (!(descriptor.getNsURI() == null || "mtl".equals(descriptor.getNsPrefix()) || "mtlnonstdlib".equals(descriptor.getNsPrefix()) || "mtlstdlib".equals(descriptor.getNsPrefix()) || "oclstdlib".equals(descriptor.getNsPrefix()))) {
            this.dynamicEcorePackagePaths.put(descriptor.getNsURI(), descriptor.getResourceURI().toString());
            registry.put((Object)descriptor.getNsURI(), (Object)descriptor);
        }
        for (LazyEPackageDescriptor child : descriptor.getESubpackages()) {
            this.registerDescriptorsHierarchy(registry, child);
        }
    }

    @Override
    public Object remove(Object key) {
        Object value;
        boolean hasBeenRemoved = false;
        if (this.dynamicEcorePackagePaths.containsKey(key) && EMFPlugin.IS_ECLIPSE_RUNNING) {
            EList resources = AcceleoDynamicMetamodelResourceSetImpl.DYNAMIC_METAMODEL_RESOURCE_SET.getResources();
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                if (key instanceof String && key.equals(resource.getURI().toString())) {
                    iterator.remove();
                    super.remove(key);
                    hasBeenRemoved = true;
                    continue;
                }
                String value2 = this.dynamicEcorePackagePaths.get(key);
                if (!value2.equals(resource.getURI().toString())) continue;
                iterator.remove();
                super.remove(key);
                hasBeenRemoved = true;
            }
        }
        if ((value = this.get(key)) instanceof LazyEPackageDescriptor) {
            super.remove(key);
            hasBeenRemoved = true;
        }
        if (!hasBeenRemoved) {
            return this.delegate.remove(key);
        }
        return null;
    }

    @Override
    public int size() {
        return super.size() + this.delegate.size();
    }

    public void unregisterEcorePackages(String pathName) {
        Iterator<Map.Entry<String, String>> entryIterator = this.dynamicEcorePackagePaths.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, String> dynamicEcore = entryIterator.next();
            if (!dynamicEcore.getValue().endsWith(pathName)) continue;
            this.remove(dynamicEcore.getKey());
            entryIterator.remove();
        }
    }

    @Override
    public Collection<Object> values() {
        Collection dynamicValues = super.values();
        Collection globalValues = this.delegate.values();
        return new AcceleoMultipleCollection<Object>(dynamicValues, globalValues);
    }

    public void registerEcorePackage(EPackage loadedEPackage) {
        this.registerDescriptorsHierarchy(this, LazyEPackageDescriptor.create(loadedEPackage, this));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcceleoMultipleCollection<V>
    extends AbstractCollection<V> {
        private final Collection<V> firstCollection;
        private final Collection<V> secondCollection;

        public AcceleoMultipleCollection(Collection<V> collection1, Collection<V> collection2) {
            this.firstCollection = collection1;
            this.secondCollection = collection2;
        }

        @Override
        public Iterator<V> iterator() {
            return new AcceleoMultipleIterator<V>(this.firstCollection.iterator(), this.secondCollection.iterator());
        }

        @Override
        public int size() {
            return this.firstCollection.size() + this.secondCollection.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.firstCollection.contains(o) || this.secondCollection.contains(o);
        }

        @Override
        public void clear() {
            this.firstCollection.clear();
            this.secondCollection.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcceleoMultipleIterator<E>
    implements Iterator<E> {
        private final Iterator<E> firstIterator;
        private final Iterator<E> secondIterator;
        private Iterator<E> current;

        public AcceleoMultipleIterator(Iterator<E> iterator1, Iterator<E> iterator2) {
            this.firstIterator = iterator1;
            this.secondIterator = iterator2;
            this.current = this.firstIterator;
        }

        @Override
        public boolean hasNext() {
            return this.firstIterator.hasNext() || this.secondIterator.hasNext();
        }

        @Override
        public E next() {
            if (this.firstIterator.hasNext()) {
                return this.firstIterator.next();
            }
            this.current = this.secondIterator;
            return this.secondIterator.next();
        }

        @Override
        public void remove() {
            this.current.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcceleoMultipleSet<K>
    extends AbstractSet<K> {
        private final Set<K> firstSet;
        private final Set<K> secondSet;

        public AcceleoMultipleSet(Set<K> set1, Set<K> set2) {
            this.firstSet = set1;
            this.secondSet = set2;
        }

        @Override
        public Iterator<K> iterator() {
            return new AcceleoMultipleIterator<K>(this.firstSet.iterator(), this.secondSet.iterator());
        }

        @Override
        public int size() {
            return this.firstSet.size() + this.secondSet.size();
        }
    }
}

