/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.evaluation;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.acceleo.ModuleElement;

public class AcceleoCallStack {
    private final String startingModuleQualifiedName;
    private final Deque<ModuleElement> stack;

    public AcceleoCallStack(String startingModuleQualifiedName) {
        this.startingModuleQualifiedName = startingModuleQualifiedName;
        this.stack = new ArrayDeque<ModuleElement>();
    }

    public Deque<ModuleElement> getStack() {
        return this.stack;
    }

    public String getStartingModuleQualifiedName() {
        return this.startingModuleQualifiedName;
    }

    public void push(ModuleElement moduleElement) {
        this.stack.addLast(moduleElement);
    }

    public ModuleElement pop() {
        return this.stack.pollLast();
    }

    public ModuleElement peek() {
        return this.stack.peekLast();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }
}

