/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.workspace;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerServicesUtils;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.aql.ls.services.workspace.command.DocumentRangeParams;
import org.eclipse.acceleo.aql.ls.services.workspace.command.ExtractTemplateCommand;
import org.eclipse.acceleo.aql.ls.services.workspace.command.WrapInForCommand;
import org.eclipse.acceleo.aql.ls.services.workspace.command.WrapInIfCommand;
import org.eclipse.acceleo.aql.ls.services.workspace.command.WrapInLetCommand;
import org.eclipse.acceleo.aql.ls.services.workspace.command.WrapInProtectedCommand;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidChangeWorkspaceFoldersParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbol;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.WorkspaceService;

public class AcceleoWorkspaceService
implements WorkspaceService,
LanguageClientAware {
    private final AcceleoLanguageServer server;
    private LanguageClient languageClient;
    private final AcceleoWorkspace acceleoWorkspace;

    public AcceleoWorkspaceService(AcceleoLanguageServer acceleoLanguageServer) {
        this.server = Objects.requireNonNull(acceleoLanguageServer);
        this.acceleoWorkspace = this.server.connectWorkspace();
    }

    public void connect(LanguageClient newLanguageClient) {
        this.languageClient = newLanguageClient;
    }

    public void disconnect() {
        this.languageClient = null;
    }

    public AcceleoWorkspace getWorkspace() {
        return this.acceleoWorkspace;
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        System.out.println(params);
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        System.out.println(params);
    }

    public void didChangeWorkspaceFolders(DidChangeWorkspaceFoldersParams params) {
        super.didChangeWorkspaceFolders(params);
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        String label;
        CompletableFuture workspaceEdit;
        DocumentRangeParams documentRangeParams = (DocumentRangeParams)new Gson().fromJson((JsonElement)((JsonObject)params.getArguments().get(0)), DocumentRangeParams.class);
        Range range = documentRangeParams.getRange();
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(documentRangeParams.getTextDocument().getUri());
        AcceleoTextDocument document = this.getWorkspace().getDocument(textDocumentUri);
        switch (params.getCommand()) {
            case "extractTemplate": {
                workspaceEdit = CompletableFutures.computeAsync(canceler -> {
                    canceler.checkCanceled();
                    return new ExtractTemplateCommand().exec(document, range);
                });
                label = "Extract Template";
                break;
            }
            case "wrapInFor": {
                workspaceEdit = CompletableFutures.computeAsync(canceler -> {
                    canceler.checkCanceled();
                    return new WrapInForCommand().exec(document, range);
                });
                label = "Wrap in For";
                break;
            }
            case "wrapInIf": {
                workspaceEdit = CompletableFutures.computeAsync(canceler -> {
                    canceler.checkCanceled();
                    return new WrapInIfCommand().exec(document, range);
                });
                label = "Wrap in If";
                break;
            }
            case "wrapInLet": {
                workspaceEdit = CompletableFutures.computeAsync(canceler -> {
                    canceler.checkCanceled();
                    return new WrapInLetCommand().exec(document, range);
                });
                label = "Wrap in Let";
                break;
            }
            case "wrapInProtected": {
                workspaceEdit = CompletableFutures.computeAsync(canceler -> {
                    canceler.checkCanceled();
                    return new WrapInProtectedCommand().exec(document, range);
                });
                label = "Wrap in Protected";
                break;
            }
            default: {
                super.executeCommand(params);
                workspaceEdit = null;
                label = null;
            }
        }
        if (workspaceEdit != null) {
            workspaceEdit.thenAccept(we -> {
                try {
                    this.languageClient.applyEdit(new ApplyWorkspaceEditParams((WorkspaceEdit)we, label)).get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    e.printStackTrace();
                }
            });
        }
        return workspaceEdit;
    }

    public CompletableFuture<Either<List<? extends SymbolInformation>, List<? extends WorkspaceSymbol>>> symbol(WorkspaceSymbolParams params) {
        return super.symbol(params);
    }
}

