/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.EclipseQualifiedNameResolver;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.OSGiQualifiedNameResolver;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.ResolverFactoryRegistryListener;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.workspace.EclipseWorkspaceQualifiedNameResolver;
import org.eclipse.acceleo.query.ide.runtime.namespace.IResolverFactoryDescriptor;
import org.eclipse.acceleo.query.ide.runtime.namespace.workspace.IWorkspaceResolverFactoryDescriptor;
import org.eclipse.acceleo.query.ide.runtime.namespace.workspace.IWorkspaceResolverProvider;
import org.eclipse.acceleo.query.ide.services.configurator.ResourceSetConfiguratorRegistryListener;
import org.eclipse.acceleo.query.ide.services.configurator.ServicesConfiguratorRegistryListener;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class QueryPlugin
extends EMFPlugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.query.ide";
    public static final QueryPlugin INSTANCE = new QueryPlugin();
    private static Implementation plugin;
    private static final List<IResolverFactoryDescriptor> RESOLVER_FACTORY_DESCRIPTORS;
    private static final List<IWorkspaceResolverFactoryDescriptor> WORKSPACE_RESOLVER_FACTORY_DESCRIPTORS;

    static {
        RESOLVER_FACTORY_DESCRIPTORS = new ArrayList<IResolverFactoryDescriptor>();
        WORKSPACE_RESOLVER_FACTORY_DESCRIPTORS = new ArrayList<IWorkspaceResolverFactoryDescriptor>();
    }

    public QueryPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static QueryPlugin getDefault() {
        return INSTANCE;
    }

    public static void log(Exception exception, boolean blocker) {
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
    }

    public static void log(String message, boolean blocker) {
        String errorMessage;
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        if ((errorMessage = message) == null || "".equals(errorMessage)) {
            errorMessage = "Logging null message should never happens.";
        }
        INSTANCE.log(new Status(severity, PLUGIN_ID, errorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerResolverFactory(IResolverFactoryDescriptor descriptor) {
        if (descriptor != null) {
            List<IResolverFactoryDescriptor> list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                RESOLVER_FACTORY_DESCRIPTORS.add(descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterResolverFactory(IResolverFactoryDescriptor descriptor) {
        if (descriptor != null) {
            List<IResolverFactoryDescriptor> list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                RESOLVER_FACTORY_DESCRIPTORS.remove(descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerWorkspaceResolverFactory(IWorkspaceResolverFactoryDescriptor descriptor) {
        if (descriptor != null) {
            List<IWorkspaceResolverFactoryDescriptor> list = WORKSPACE_RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                WORKSPACE_RESOLVER_FACTORY_DESCRIPTORS.add(descriptor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterWorkspaceResolverFactory(IWorkspaceResolverFactoryDescriptor descriptor) {
        if (descriptor != null) {
            List<IWorkspaceResolverFactoryDescriptor> list = WORKSPACE_RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                WORKSPACE_RESOLVER_FACTORY_DESCRIPTORS.remove(descriptor);
            }
        }
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        private final ResolverFactoryRegistryListener resolverFactoryListener = new ResolverFactoryRegistryListener();
        private ServicesConfiguratorRegistryListener serviceRegistryListener = new ServicesConfiguratorRegistryListener();
        private ResourceSetConfiguratorRegistryListener resourceSetConfiguratorRegistryListener = new ResourceSetConfiguratorRegistryListener();

        public Implementation() {
            plugin = this;
        }

        public void start(BundleContext context) throws Exception {
            super.start(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.addListener((IRegistryEventListener)this.resolverFactoryListener, "org.eclipse.acceleo.query.ide.resolverfactory");
            this.resolverFactoryListener.parseInitialContributions();
            registry.addListener((IRegistryEventListener)this.serviceRegistryListener, "org.eclipse.acceleo.query.ide.servicesConfigurator");
            this.serviceRegistryListener.parseInitialContributions();
            registry.addListener((IRegistryEventListener)this.resourceSetConfiguratorRegistryListener, "org.eclipse.acceleo.query.ide.resourceSetConfigurator");
            this.resourceSetConfiguratorRegistryListener.parseInitialContributions();
        }

        public void stop(BundleContext context) throws Exception {
            super.stop(context);
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            registry.removeListener((IRegistryEventListener)this.resourceSetConfiguratorRegistryListener);
            registry.removeListener((IRegistryEventListener)this.serviceRegistryListener);
            registry.removeListener((IRegistryEventListener)this.resolverFactoryListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IQualifiedNameResolver createQualifiedNameResolver(ClassLoader classLoader, EPackage.Registry ePackageRegistry, IProject project, String qualifierSeparator, boolean forWorkspace) {
            ArrayList<IResolverFactoryDescriptor> factoryDescriptors;
            List<IResolverFactoryDescriptor> list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                factoryDescriptors = new ArrayList<IResolverFactoryDescriptor>(RESOLVER_FACTORY_DESCRIPTORS);
            }
            EclipseQualifiedNameResolver res = factoryDescriptors.isEmpty() ? new EclipseQualifiedNameResolver(classLoader, ePackageRegistry, project, qualifierSeparator) : ((IResolverFactoryDescriptor)factoryDescriptors.get(0)).getFactory().createResolver(classLoader, ePackageRegistry, project, qualifierSeparator, forWorkspace);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IQueryWorkspaceQualifiedNameResolver createWorkspaceQualifiedNameResolver(IProject project, IQualifiedNameResolver resolver, IWorkspaceResolverProvider resolverProvider) {
            ArrayList<IWorkspaceResolverFactoryDescriptor> factoryDescriptors;
            List<IWorkspaceResolverFactoryDescriptor> list = WORKSPACE_RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                factoryDescriptors = new ArrayList<IWorkspaceResolverFactoryDescriptor>(WORKSPACE_RESOLVER_FACTORY_DESCRIPTORS);
            }
            EclipseWorkspaceQualifiedNameResolver res = factoryDescriptors.isEmpty() ? new EclipseWorkspaceQualifiedNameResolver(project, resolver, resolverProvider) : ((IWorkspaceResolverFactoryDescriptor)factoryDescriptors.get(0)).getFactory().createResolver(project, resolver, resolverProvider);
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ILoader createJavaLoader(String qualifierSeparator, boolean forWorkspace) {
            ArrayList<IResolverFactoryDescriptor> factoryDescriptors;
            List<IResolverFactoryDescriptor> list = RESOLVER_FACTORY_DESCRIPTORS;
            synchronized (list) {
                factoryDescriptors = new ArrayList<IResolverFactoryDescriptor>(RESOLVER_FACTORY_DESCRIPTORS);
            }
            Object res = factoryDescriptors.isEmpty() ? new JavaLoader(qualifierSeparator, forWorkspace) : ((IResolverFactoryDescriptor)factoryDescriptors.get(0)).getFactory().createJavaLoader(qualifierSeparator, forWorkspace);
            return res;
        }

        public IQualifiedNameResolver createResolver(URI uri, ClassLoader classLoader, EPackage.Registry ePackageRegistry, String qualifierSeparator, boolean forWorkspace) {
            ClassLoaderQualifiedNameResolver res;
            if (uri.isPlatformPlugin()) {
                String bundleName = uri.segment(1);
                Bundle bundle = Platform.getBundle((String)bundleName);
                res = new OSGiQualifiedNameResolver(bundle, ePackageRegistry, qualifierSeparator);
            } else if (uri.isPlatformResource()) {
                String projectName = uri.segment(1);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                res = QueryPlugin.getPlugin().createQualifiedNameResolver(classLoader, ePackageRegistry, project, qualifierSeparator, forWorkspace);
            } else if (uri.isFile()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.path()));
                IProject project = file.getProject();
                res = QueryPlugin.getPlugin().createQualifiedNameResolver(classLoader, ePackageRegistry, project, qualifierSeparator, forWorkspace);
            } else {
                res = new ClassLoaderQualifiedNameResolver(classLoader, ePackageRegistry, qualifierSeparator);
            }
            return res;
        }
    }
}

