/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.internal.view.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ui.interpreter.internal.InterpreterImages;
import org.eclipse.acceleo.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.acceleo.ui.interpreter.view.Variable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class DeleteVariableOrValueAction
extends Action {
    private final TreeViewer variableViewer;

    public DeleteVariableOrValueAction(TreeViewer viewer) {
        super(InterpreterMessages.getString("interpreter.action.deletevariable.name"));
        this.setImageDescriptor(InterpreterImages.getImageDescriptor("delete_action.gif"));
        this.setDisabledImageDescriptor(InterpreterImages.getImageDescriptor("delete_action_disabled.gif"));
        this.variableViewer = viewer;
    }

    public Tree getTree() {
        if (this.variableViewer == null) {
            return null;
        }
        return this.variableViewer.getTree();
    }

    public boolean isEnabled() {
        TreeItem[] selectedtems;
        return this.getTree() != null && !this.getTree().isDisposed() && (selectedtems = this.getTree().getSelection()) != null && selectedtems.length > 0;
    }

    public void run() {
        if (this.getTree() == null || this.getTree().isDisposed()) {
            return;
        }
        Object input = this.variableViewer.getInput();
        TreeItem[] selectedtems = this.getTree().getSelection();
        if (selectedtems == null || selectedtems.length == 0) {
            return;
        }
        int i = 0;
        while (i < selectedtems.length) {
            TreeItem item = selectedtems[i];
            if (item.getData() instanceof Variable) {
                ((List)input).remove(item.getData());
            } else if (item.getParentItem() != null && item.getParentItem().getData() instanceof Variable) {
                Variable variable = (Variable)item.getParentItem().getData();
                Object variableValue = variable.getValue();
                if (item.getData().equals(variableValue)) {
                    ((List)input).remove(variable);
                } else {
                    List value = (List)variableValue;
                    value.remove(item.getData());
                    if (value.size() == 1) {
                        variable.setValue(value.get(0));
                    }
                }
            }
            ++i;
        }
        this.variableViewer.refresh();
    }

    protected List<Variable> getCurrentVariables() {
        TreeItem[] selectedtems;
        ArrayList<Variable> result = new ArrayList<Variable>();
        if (this.getTree() != null && !this.getTree().isDisposed() && (selectedtems = this.getTree().getSelection()) != null && selectedtems.length > 0) {
            int i = 0;
            while (i < selectedtems.length) {
                TreeItem item = selectedtems[i];
                if (item.getData() instanceof Variable) {
                    result.add((Variable)item.getData());
                }
                ++i;
            }
        }
        return result;
    }
}

