/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.evaluation.QueryService;
import org.eclipse.acceleo.aql.evaluation.TemplateService;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Declaration;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;

public class DeclarationSwitch
extends ComposedSwitch<List<Object>> {
    private final IAcceleoValidationResult acceleoValidationResult;
    private final IQualifiedNameQueryEnvironment queryEnvironment;
    private final boolean withCompatibleServices;
    private String contextQualifiedName;

    public DeclarationSwitch(IAcceleoValidationResult acceleoValidationResult, IQualifiedNameQueryEnvironment queryEnvironment, boolean withCompatibleServices) {
        this.addSwitch((Switch)new AQLDeclarationSwitch());
        this.addSwitch(new AcceleoDeclarationSwitch());
        this.acceleoValidationResult = acceleoValidationResult;
        this.queryEnvironment = queryEnvironment;
        this.withCompatibleServices = withCompatibleServices;
    }

    public List<Object> getDeclarations(String contextQualifiedName, EObject eObject) {
        this.contextQualifiedName = contextQualifiedName;
        return (List)this.doSwitch(eObject);
    }

    private List<IService<?>> getCompatibleServices(IService<?> service) {
        ArrayList res = new ArrayList();
        IQualifiedNameLookupEngine lookupEngine = this.queryEnvironment.getLookupEngine();
        lookupEngine.pushImportsContext(this.contextQualifiedName, this.contextQualifiedName);
        try {
            List possibleServices = lookupEngine.getRegisteredServices().stream().filter(s -> s.getName().equals(service.getName()) && s.getNumberOfParameters() == service.getNumberOfParameters()).collect(Collectors.toList());
            ArrayList currentCompatibleServices = new ArrayList();
            currentCompatibleServices.add(service);
            ArrayList<IService> newCompatibleServices = new ArrayList<IService>();
            do {
                for (IService iService : currentCompatibleServices) {
                    List serviceParameterTypes = iService.getParameterTypes((IReadOnlyQueryEnvironment)this.queryEnvironment);
                    block5: for (IService registeredService : possibleServices) {
                        List registeredServiceParameterTypes = registeredService.getParameterTypes((IReadOnlyQueryEnvironment)this.queryEnvironment);
                        int i = 0;
                        while (i < iService.getNumberOfParameters()) {
                            boolean isAssignable = false;
                            for (IType serviceParameterType : (Set)serviceParameterTypes.get(i)) {
                                for (IType registeredServiceParameterType : (Set)registeredServiceParameterTypes.get(i)) {
                                    if (!serviceParameterType.isAssignableFrom(registeredServiceParameterType) && !registeredServiceParameterType.isAssignableFrom(serviceParameterType)) continue;
                                    isAssignable = true;
                                    break;
                                }
                                if (!isAssignable) continue block5;
                            }
                            ++i;
                        }
                        if (res.contains(registeredService)) continue;
                        newCompatibleServices.add(registeredService);
                    }
                }
                res.addAll(newCompatibleServices);
                currentCompatibleServices = newCompatibleServices;
                newCompatibleServices = new ArrayList();
            } while (!currentCompatibleServices.isEmpty());
        }
        finally {
            lookupEngine.popContext(this.contextQualifiedName);
        }
        return res;
    }

    private class AQLDeclarationSwitch
    extends AstSwitch<List<Object>> {
        private AQLDeclarationSwitch() {
        }

        public List<Object> caseVarRef(VarRef varRef) {
            ArrayList<Object> res = new ArrayList<Object>();
            Declaration declaration = DeclarationSwitch.this.acceleoValidationResult.getDeclaration(varRef);
            if (declaration != null) {
                res.add(declaration);
            } else {
                Variable variable = DeclarationSwitch.this.acceleoValidationResult.getDeclarationVariable(varRef);
                if (variable != null) {
                    res.add(variable);
                }
            }
            return res;
        }

        public List<Object> caseCall(Call call) {
            ArrayList<Object> res = new ArrayList<Object>();
            List<IService<?>> services = DeclarationSwitch.this.acceleoValidationResult.getDeclarationIService(call);
            if (DeclarationSwitch.this.withCompatibleServices) {
                for (IService<?> service : services) {
                    res.addAll(DeclarationSwitch.this.getCompatibleServices(service));
                }
            } else {
                res.addAll(services);
            }
            return res;
        }

        public List<Object> caseStringLiteral(StringLiteral stringLiteral) {
            Object res = this.isInFeatureAccessCall(stringLiteral) ? this.caseCall((Call)stringLiteral.eContainer()) : Collections.emptyList();
            return res;
        }

        private boolean isInFeatureAccessCall(StringLiteral stringLiteral) {
            Call call;
            EObject container = stringLiteral.eContainer();
            boolean res = container instanceof Call ? "aqlFeatureAccess".equals((call = (Call)container).getServiceName()) && call.getArguments().size() == 2 && call.getArguments().get(1) == stringLiteral : false;
            return res;
        }

        public List<Object> caseDeclaration(Declaration declaration) {
            ArrayList<Object> res = new ArrayList<Object>();
            res.add(declaration);
            return res;
        }

        public List<Object> defaultCase(EObject object) {
            return Collections.emptyList();
        }
    }

    private class AcceleoDeclarationSwitch
    extends AcceleoSwitch<List<Object>> {
        private AcceleoDeclarationSwitch() {
        }

        @Override
        public List<Object> caseModuleReference(ModuleReference moduleReference) {
            ArrayList<Object> res = new ArrayList<Object>();
            IQualifiedNameResolver resolver = DeclarationSwitch.this.queryEnvironment.getLookupEngine().getResolver();
            Object resolved = resolver.resolve(moduleReference.getQualifiedName());
            if (resolved != null) {
                res.add(resolved);
            }
            return res;
        }

        @Override
        public List<Object> caseTemplate(Template template) {
            ArrayList<Object> res = new ArrayList<Object>();
            TemplateService templateService = new TemplateService(template, null, null, null);
            if (DeclarationSwitch.this.withCompatibleServices) {
                res.addAll(DeclarationSwitch.this.getCompatibleServices((IService<?>)templateService));
            } else {
                res.add((Object)templateService);
            }
            return res;
        }

        @Override
        public List<Object> caseQuery(Query query) {
            ArrayList<Object> res = new ArrayList<Object>();
            QueryService queryService = new QueryService(query, null, null, null);
            if (DeclarationSwitch.this.withCompatibleServices) {
                res.addAll(DeclarationSwitch.this.getCompatibleServices((IService<?>)queryService));
            } else {
                res.add((Object)queryService);
            }
            return res;
        }

        @Override
        public List<Object> caseVariable(Variable variable) {
            ArrayList<Object> res = new ArrayList<Object>();
            res.add(variable);
            return res;
        }

        @Override
        public List<Object> caseModule(Module module) {
            ArrayList<Object> res = new ArrayList<Object>();
            res.add(module);
            return res;
        }

        @Override
        public List<Object> defaultCase(EObject object) {
            return Collections.emptyList();
        }
    }
}

