/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.debug;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Statement;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.AcceleoProfilerEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.ide.evaluation.strategy.AcceleoWorkspaceWriterFactory;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.aql.profiler.IProfiler;
import org.eclipse.acceleo.aql.profiler.ProfilerFactory;
import org.eclipse.acceleo.aql.profiler.ProfilerPackage;
import org.eclipse.acceleo.aql.profiler.ProfilerUtils;
import org.eclipse.acceleo.debug.AbstractDSLDebugger;
import org.eclipse.acceleo.debug.DSLSource;
import org.eclipse.acceleo.debug.DebuggerProgressMonitor;
import org.eclipse.acceleo.debug.IDSLDebugger;
import org.eclipse.acceleo.debug.event.IDSLDebugEventProcessor;
import org.eclipse.acceleo.debug.util.FrameVariable;
import org.eclipse.acceleo.debug.util.StackFrame;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.swt.widgets.Display;

public class AcceleoDebugger
extends AbstractDSLDebugger {
    public static final String MODULE = "module";
    public static final String MODEL = "model";
    public static final String DESTINATION = "destination";
    public static final String OPTIONS = "options";
    public static final Type OPTION_MAP_TYPE = new TypeToken<LinkedHashMap<String, String>>(){}.getType();
    public static final String PROFILE_MODEL = "profileModel";
    public static final String PROFILE_MODEL_REPRESENTATION = "modelRepresentation";
    private IQualifiedNameQueryEnvironment queryEnvironment;
    private ResourceSet resourceSetForModels;
    private URI destination;
    private Map<String, String> options;
    private URI profileModelURI;
    private ProfilerUtils.Representation profilerModelRepresentation;
    private AcceleoAstResult astResult;
    private Resource model;
    private String newLine;
    private URI logURI;
    private AcceleoDebugEvaluator evaluator;
    private IResource moduleFile;

    public AcceleoDebugger(IDSLDebugEventProcessor target) {
        super(target);
    }

    public void initialize(boolean noDebug, Map<String, Object> arguments) {
        String profilerModelRepresentationString;
        this.setNoDebug(noDebug);
        URI moduleURI = URI.createURI((String)((String)arguments.get(MODULE)));
        URI modelURI = URI.createURI((String)((String)arguments.get(MODEL)));
        this.destination = URI.createURI((String)((String)arguments.get(DESTINATION)));
        String optionString = (String)arguments.get(OPTIONS);
        this.options = optionString != null ? (Map<Object, Object>)new Gson().fromJson(optionString, OPTION_MAP_TYPE) : new LinkedHashMap<String, String>();
        String profileModel = (String)arguments.get(PROFILE_MODEL);
        if (profileModel != null) {
            this.profileModelURI = URI.createURI((String)profileModel);
        }
        if ((profilerModelRepresentationString = (String)arguments.get(PROFILE_MODEL_REPRESENTATION)) != null) {
            this.profilerModelRepresentation = ProfilerUtils.Representation.valueOf((String)profilerModelRepresentationString);
        }
        this.moduleFile = LSPEclipseUtils.findResourceFor((String)((String)arguments.get(MODULE)));
        IProject project = this.moduleFile.getProject();
        IQualifiedNameResolver resolver = QueryPlugin.getPlugin().createQualifiedNameResolver(AcceleoPlugin.getPlugin().getClass().getClassLoader(), project, "::", false);
        this.newLine = this.options.getOrDefault("newLine", System.lineSeparator());
        this.logURI = AcceleoUtil.getlogURI((URI)this.destination, (String)this.options.get("logURI"));
        ArrayList exceptions = new ArrayList();
        this.resourceSetForModels = AQLUtils.createResourceSetForModels(exceptions, (Object)((Object)this), (ResourceSet)new ResourceSetImpl(), this.options);
        for (Exception exception : exceptions) {
            this.consolePrint(exception.getMessage());
        }
        try {
            this.model = this.resourceSetForModels.getResource(modelURI, true);
        }
        catch (Exception e) {
            this.consolePrint(e.getMessage());
        }
        this.queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(this.options, (IQualifiedNameResolver)resolver, (ResourceSet)this.resourceSetForModels, (boolean)false);
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), (AcceleoEvaluator)this.evaluator));
        resolver.addLoader(QueryPlugin.getPlugin().createJavaLoader("::", false));
        java.net.URI moduleBinaryURI = resolver.getBinaryURI(java.net.URI.create(moduleURI.toString()));
        String moduleQualifiedName = resolver.getQualifiedName(moduleBinaryURI);
        Object resolved = resolver.resolve(moduleQualifiedName);
        if (resolved instanceof Module) {
            this.astResult = ((Module)resolved).getAst();
            AcceleoUtil.registerEPackage((IQualifiedNameQueryEnvironment)this.queryEnvironment, (IQualifiedNameResolver)resolver, (Module)((Module)resolved));
        }
    }

    public void start() {
        new Thread((Runnable)new GenerateRunnable(), "Acceleo Debug Thread").start();
    }

    protected void generateNoDebug(IQualifiedNameQueryEnvironment environment, Module module, Resource modelResource) {
        AcceleoEvaluator noDebugEvaluator;
        IProfiler profiler;
        if (this.profileModelURI != null && this.profilerModelRepresentation != null) {
            String workspaceModuleFilePath = this.moduleFile.getFullPath().toString();
            URI startFileURI = URI.createPlatformResourceURI((String)workspaceModuleFilePath, (boolean)true);
            profiler = ProfilerUtils.getProfiler((String)startFileURI.toString(), (ProfilerUtils.Representation)this.profilerModelRepresentation, (ProfilerFactory)ProfilerPackage.eINSTANCE.getProfilerFactory());
            noDebugEvaluator = new AcceleoProfilerEvaluator(environment.getLookupEngine(), this.newLine, profiler);
        } else {
            noDebugEvaluator = new AcceleoEvaluator(environment.getLookupEngine(), this.newLine);
            profiler = null;
        }
        IQualifiedNameResolver resolver = environment.getLookupEngine().getResolver();
        resolver.clearLoaders();
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), noDebugEvaluator));
        resolver.addLoader(QueryPlugin.getPlugin().createJavaLoader("::", false));
        DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(modelResource.getResourceSet().getURIConverter(), (IWriterFactory)new AcceleoWorkspaceWriterFactory());
        AcceleoUtil.generate((AcceleoEvaluator)noDebugEvaluator, (IQualifiedNameQueryEnvironment)environment, (Module)module, (Resource)modelResource, (IAcceleoGenerationStrategy)strategy, (URI)this.getDestination(), (URI)this.logURI, (Monitor)new DebuggerProgressMonitor((IDSLDebugger)this));
        if (noDebugEvaluator.getGenerationResult().getDiagnostic().getSeverity() != 0) {
            this.printDiagnostic(noDebugEvaluator.getGenerationResult().getDiagnostic(), "");
        }
        this.printSummary(noDebugEvaluator.getGenerationResult());
        if (profiler != null) {
            try {
                profiler.save(this.profileModelURI);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void disconnect() {
        if (this.queryEnvironment != null && this.resourceSetForModels != null) {
            AQLUtils.cleanResourceSetForModels((Object)((Object)this), (ResourceSet)this.resourceSetForModels);
            AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)this.queryEnvironment, (ResourceSet)this.resourceSetForModels);
        }
    }

    public boolean canStepInto(Long threadID, EObject instruction) {
        return false;
    }

    public boolean validateVariableValue(Long threadID, String variableName, String value) {
        return false;
    }

    public Object getVariableValue(Long threadID, String stackName, String variableName, String value) {
        return null;
    }

    public void setVariableValue(Long threadID, String stackName, String variableName, Object value) {
    }

    public EObject getInstruction(String path, long line, long column) {
        ASTNode res;
        AcceleoAstResult moduleAstResult = null;
        try {
            Object resolved;
            IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
            java.net.URI binaryURI = resolver.getBinaryURI(new java.net.URI("file://" + path));
            String moduleQualifiedName = resolver.getQualifiedName(binaryURI);
            if (moduleQualifiedName != null && (resolved = resolver.resolve(moduleQualifiedName)) instanceof Module) {
                moduleAstResult = ((Module)resolved).getAst();
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (moduleAstResult != null) {
            ASTNode instruction = moduleAstResult.getAstNode((int)line, (int)column);
            if (column == 0L) {
                while (instruction != null) {
                    if (this.isAcceleoInstruction((EObject)instruction)) break;
                    instruction = instruction.eContainer();
                }
                res = instruction;
            } else {
                res = instruction;
            }
        } else {
            res = null;
        }
        return res;
    }

    private boolean isAcceleoInstruction(EObject eObject) {
        return eObject instanceof Statement;
    }

    public DSLSource getSource(EObject instruction) {
        DSLSource res = null;
        String path = null;
        Module module = this.getModule(instruction);
        if (module != null) {
            AcceleoAstResult moduleAstResult = module.getAst();
            IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
            String moduleQualifiedName = resolver.getQualifiedName((Object)moduleAstResult.getModule());
            java.net.URI moduleSourceURI = resolver.getSourceURI(moduleQualifiedName);
            path = URIUtil.toFile((java.net.URI)moduleSourceURI).toString();
            if (instruction instanceof AcceleoASTNode) {
                int startLine = moduleAstResult.getStartLine((ASTNode)((AcceleoASTNode)instruction));
                int startColumn = moduleAstResult.getStartColumn((ASTNode)((AcceleoASTNode)instruction));
                int endLine = moduleAstResult.getEndLine((ASTNode)((AcceleoASTNode)instruction));
                int endColumn = moduleAstResult.getEndColumn((ASTNode)((AcceleoASTNode)instruction));
                res = new DSLSource(path, (long)(startLine + 1), (long)(startColumn + 1), (long)(endLine + 1), (long)(endColumn + 1));
            } else if (instruction instanceof Expression) {
                int startLine = moduleAstResult.getStartLine((ASTNode)((Expression)instruction));
                int startColumn = moduleAstResult.getStartColumn((ASTNode)((Expression)instruction));
                int endLine = moduleAstResult.getEndLine((ASTNode)((Expression)instruction));
                int endColumn = moduleAstResult.getEndColumn((ASTNode)((Expression)instruction));
                res = new DSLSource(path, (long)(startLine + 1), (long)(startColumn + 1), (long)(endLine + 1), (long)(endColumn + 1));
            } else if (instruction instanceof VariableDeclaration) {
                int startLine = moduleAstResult.getStartLine((ASTNode)((VariableDeclaration)instruction));
                int startColumn = moduleAstResult.getStartColumn((ASTNode)((VariableDeclaration)instruction));
                int endLine = moduleAstResult.getEndLine((ASTNode)((VariableDeclaration)instruction));
                int endColumn = moduleAstResult.getEndColumn((ASTNode)((VariableDeclaration)instruction));
                res = new DSLSource(path, (long)(startLine + 1), (long)(startColumn + 1), (long)(endLine + 1), (long)(endColumn + 1));
            } else {
                res = null;
            }
        }
        return res;
    }

    private Module getModule(EObject instruction) {
        Module res = null;
        EObject current = instruction;
        while (current != null) {
            if (current instanceof Module) {
                res = (Module)current;
                break;
            }
            current = current.eContainer();
        }
        return res;
    }

    protected URI getDestination() {
        return this.destination;
    }

    protected void printDiagnostic(Diagnostic diagnostic, String indentation) {
        Object nextIndentation = indentation;
        if (diagnostic.getMessage() != null) {
            this.consolePrint(indentation);
            switch (diagnostic.getSeverity()) {
                case 1: {
                    this.consolePrint("INFO ");
                    break;
                }
                case 2: {
                    this.consolePrint("WARNING ");
                    break;
                }
                case 4: {
                    this.consolePrint("ERROR ");
                }
            }
            if (!diagnostic.getData().isEmpty() && diagnostic.getData().get(0) instanceof ASTNode) {
                this.consolePrint(AcceleoUtil.getLocation((ASTNode)((ASTNode)diagnostic.getData().get(0))));
            }
            this.consolePrint(": " + diagnostic.getMessage() + this.newLine);
            nextIndentation = (String)nextIndentation + "\t";
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(child, (String)nextIndentation);
        }
    }

    protected void printSummary(GenerationResult result) {
        int nbErrors = 0;
        int nbWarnings = 0;
        int nbInfos = 0;
        for (Diagnostic diagnostic : result.getDiagnostic().getChildren()) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    ++nbErrors;
                    break;
                }
                case 2: {
                    ++nbWarnings;
                    break;
                }
                case 1: {
                    ++nbInfos;
                    break;
                }
            }
        }
        String message = "Files: " + result.getGeneratedFiles().size() + ", Lost Files: " + result.getLostFiles().size() + ", Errors: " + nbErrors + ", Warnings: " + nbWarnings + ", Infos: " + nbInfos + ".";
        this.consolePrint(message + this.newLine);
    }

    public FrameVariable getFrameVariable(String name, Object value) {
        FrameVariable res = new FrameVariable();
        res.setName(name);
        res.setValue(value);
        res.setReadOnly(true);
        return res;
    }

    public boolean shouldBreak(EObject instruction) {
        boolean res = super.shouldBreak(instruction) ? this.evaluator.shouldBreak(instruction) : false;
        return res;
    }

    private final class AcceleoDebugEvaluator
    extends AcceleoEvaluator {
        private static final String BLOCK_OUTPUT_VARIABLE = "blockOutput";
        private Deque<List<String>> blockTextLists;
        private final Map<URI, Integer> breakPointHitCounts;

        AcceleoDebugEvaluator(IQualifiedNameQueryEnvironment queryEnvironment, String newLine, Map<URI, Integer> breakPointHitCounts) {
            super(queryEnvironment.getLookupEngine(), newLine);
            this.blockTextLists = new ArrayDeque<List<String>>();
            this.breakPointHitCounts = breakPointHitCounts;
        }

        private void pushBlockTextList() {
            this.blockTextLists.addLast(new ArrayList());
        }

        private List<String> popBlockTextList() {
            return this.blockTextLists.removeLast();
        }

        public Object doSwitch(EObject eObject) {
            if (AcceleoDebugger.this.isTerminated()) {
                return null;
            }
            if (eObject instanceof Template || eObject instanceof Query) {
                AcceleoDebugger.this.pushStackFrame(Thread.currentThread().getId(), eObject);
            } else if (eObject instanceof Block) {
                this.pushBlockTextList();
            }
            try {
                if (AcceleoDebugger.this.isAcceleoInstruction(eObject)) {
                    StackFrame currentFrame = AcceleoDebugger.this.peekStackFrame(Thread.currentThread().getId());
                    currentFrame.setInstruction(eObject);
                    LinkedHashMap<String, FrameVariable> variables = new LinkedHashMap<String, FrameVariable>();
                    for (Map.Entry entry : this.peekVariables().entrySet()) {
                        variables.put((String)entry.getKey(), AcceleoDebugger.this.getFrameVariable((String)entry.getKey(), entry.getValue()));
                    }
                    currentFrame.setVariables(variables);
                    currentFrame.getVariables().put(BLOCK_OUTPUT_VARIABLE, AcceleoDebugger.this.getFrameVariable(BLOCK_OUTPUT_VARIABLE, this.blockTextLists.peekLast()));
                    if (!AcceleoDebugger.this.control(Thread.currentThread().getId(), eObject)) {
                        Thread.currentThread().interrupt();
                    }
                }
                Object object = super.doSwitch(eObject);
                return object;
            }
            finally {
                if (eObject instanceof Template || eObject instanceof Query) {
                    AcceleoDebugger.this.popStackFrame(Thread.currentThread().getId());
                } else if (eObject instanceof Block) {
                    this.popBlockTextList();
                }
            }
        }

        protected List<String> createBlockTextsList(Block block) {
            return this.blockTextLists.peekLast();
        }

        public boolean shouldBreak(EObject instruction) {
            String logExpression;
            URI uri;
            Integer count;
            Object value;
            String conditionExpression = AcceleoDebugger.this.getBreakpointAttributes(instruction, "condition");
            boolean res = conditionExpression != null ? (value = this.evaluateExpression(conditionExpression)) == null || value instanceof Boolean && (Boolean)value != false : true;
            if (res && (count = this.breakPointHitCounts.get(uri = EcoreUtil.getURI((EObject)instruction))) != null && count > 0) {
                this.breakPointHitCounts.put(uri, count - 1);
                res = false;
            }
            if (res && (logExpression = AcceleoDebugger.this.getBreakpointAttributes(instruction, "logMessage")) != null) {
                Object value2 = this.evaluateExpression(logExpression);
                if (value2 != null) {
                    AcceleoDebugger.this.consolePrint(value2.toString());
                }
                res = false;
            }
            return res;
        }

        private Object evaluateExpression(String expression) {
            Object res;
            AQLUtils.AcceleoAQLResult result = AQLUtils.parseWhileAqlExpression((String)expression.toString());
            if (result.getAstResult().getDiagnostic().getSeverity() == 4) {
                AcceleoDebugger.this.consolePrint("parsing error: " + expression + AcceleoDebugger.this.newLine);
                AcceleoDebugger.this.printDiagnostic(result.getAstResult().getDiagnostic(), "");
                res = null;
            } else {
                EvaluationResult value = AcceleoDebugger.this.evaluator.getAqlEngine().eval(result.getAstResult(), this.peekVariables());
                if (value.getDiagnostic().getSeverity() == 4) {
                    AcceleoDebugger.this.consolePrint("evaluation error: " + expression + AcceleoDebugger.this.newLine);
                    AcceleoDebugger.this.printDiagnostic(result.getAstResult().getDiagnostic(), "");
                    res = null;
                } else {
                    res = value.getResult();
                }
            }
            return res;
        }
    }

    private final class GenerateRunnable
    implements Runnable {
        private GenerateRunnable() {
        }

        @Override
        public void run() {
            IContainer container;
            Module module = AcceleoDebugger.this.astResult.getModule();
            long threadID = Thread.currentThread().getId();
            AcceleoDebugger.this.spawnRunningThread(threadID, Thread.currentThread().getName(), (EObject)module);
            try {
                if (AcceleoDebugger.this.isNoDebug()) {
                    AcceleoDebugger.this.generateNoDebug(AcceleoDebugger.this.queryEnvironment, module, AcceleoDebugger.this.model);
                } else {
                    AcceleoDebugger.this.evaluator = new AcceleoDebugEvaluator(AcceleoDebugger.this.queryEnvironment, AcceleoDebugger.this.newLine, this.getBreakPointsHitCounts());
                    IQualifiedNameResolver resolver = AcceleoDebugger.this.queryEnvironment.getLookupEngine().getResolver();
                    resolver.clearLoaders();
                    resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), (AcceleoEvaluator)AcceleoDebugger.this.evaluator));
                    resolver.addLoader(QueryPlugin.getPlugin().createJavaLoader("::", false));
                    DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(AcceleoDebugger.this.model.getResourceSet().getURIConverter(), (IWriterFactory)new AcceleoWorkspaceWriterFactory());
                    AcceleoUtil.generate((AcceleoEvaluator)AcceleoDebugger.this.evaluator, (IQualifiedNameQueryEnvironment)AcceleoDebugger.this.queryEnvironment, (Module)module, (Resource)AcceleoDebugger.this.model, (IAcceleoGenerationStrategy)strategy, (URI)AcceleoDebugger.this.getDestination(), (URI)AcceleoDebugger.this.logURI, (Monitor)new DebuggerProgressMonitor((IDSLDebugger)AcceleoDebugger.this));
                    if (AcceleoDebugger.this.evaluator.getGenerationResult().getDiagnostic().getSeverity() != 0) {
                        AcceleoDebugger.this.printDiagnostic(AcceleoDebugger.this.evaluator.getGenerationResult().getDiagnostic(), "");
                    }
                    AcceleoDebugger.this.printSummary(AcceleoDebugger.this.evaluator.getGenerationResult());
                }
            }
            catch (Throwable throwable) {
                Display.getDefault().syncExec(new Runnable(threadID){
                    private final /* synthetic */ long val$threadID;
                    {
                        this.val$threadID = l;
                    }

                    @Override
                    public void run() {
                        AcceleoDebugger.this.terminate(this.val$threadID);
                        AcceleoDebugger.this.terminated(this.val$threadID);
                        AcceleoDebugger.this.terminated();
                    }
                });
                throw throwable;
            }
            Display.getDefault().syncExec(new /* invalid duplicate definition of identical inner class */);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace != null && (container = workspace.getRoot().getContainerForLocation((IPath)new Path(AcceleoDebugger.this.destination.toFileString()))) != null) {
                try {
                    container.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        }

        private Map<URI, Integer> getBreakPointsHitCounts() {
            HashMap<URI, Integer> res = new HashMap<URI, Integer>();
            for (Map.Entry entry : AcceleoDebugger.this.getBreakpoints().entrySet()) {
                String hitCondition = (String)((Map)entry.getValue()).get("hitCondition");
                if (hitCondition == null) continue;
                try {
                    res.put((URI)entry.getKey(), Integer.valueOf(hitCondition));
                }
                catch (NumberFormatException e) {
                    AcceleoDebugger.this.consolePrint("hit condition is not an integer: " + hitCondition + AcceleoDebugger.this.newLine);
                }
            }
            return res;
        }
    }
}

