/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.cdo.tests.services.configurator;

import java.util.LinkedHashMap;
import org.eclipse.acceleo.query.cdo.services.configurator.CDOResourceSetConfigurator;
import org.eclipse.acceleo.query.cdo.tests.CDOServer;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.view.CDOViewSetPackageRegistryImpl;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.junit.Assert;
import org.junit.Test;

public class CDOResourceSetConfiguratorTests {
    @Test(expected=LifecycleException.class)
    public void wrongServer() {
        CDOResourceSetConfigurator configurator = new CDOResourceSetConfigurator();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("CDOServer", "tcp://127.0.0.1:12345");
        options.put("CDORepository", "testRepo");
        options.put("CDOLogin", "user");
        options.put("CDOPassword", "WrongPassword");
        ResourceSet rs = configurator.createResourceSetForModels((Object)this, options);
        configurator.cleanResourceSetForModels((Object)this);
    }

    @Test
    public void withAuth() {
        CDOServer server = new CDOServer(true);
        server.start();
        try {
            CDOResourceSetConfigurator configurator = new CDOResourceSetConfigurator();
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            options.put("CDOServer", "tcp://127.0.0.1:12345");
            options.put("CDORepository", "testRepo");
            options.put("CDOLogin", "user");
            options.put("CDOPassword", "password");
            ResourceSet rs = configurator.createResourceSetForModels((Object)this, options);
            configurator.cleanResourceSetForModels((Object)this);
            Assert.assertEquals((Object)true, (Object)(rs.getPackageRegistry() instanceof CDOViewSetPackageRegistryImpl));
        }
        finally {
            server.stop();
        }
    }

    @Test(expected=SecurityException.class)
    public void withAuthWrongPassword() {
        CDOServer server = new CDOServer(true);
        server.start();
        try {
            CDOResourceSetConfigurator configurator = new CDOResourceSetConfigurator();
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            options.put("CDOServer", "tcp://127.0.0.1:12345");
            options.put("CDORepository", "testRepo");
            options.put("CDOLogin", "user");
            options.put("CDOPassword", "WrongPassword");
            ResourceSet rs = configurator.createResourceSetForModels((Object)this, options);
            configurator.cleanResourceSetForModels((Object)this);
        }
        finally {
            server.stop();
        }
    }

    @Test
    public void withoutAuth() {
        CDOServer server = new CDOServer(false);
        server.start();
        try {
            CDOResourceSetConfigurator configurator = new CDOResourceSetConfigurator();
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            options.put("CDOServer", "tcp://127.0.0.1:12345");
            options.put("CDORepository", "testRepo");
            ResourceSet rs = configurator.createResourceSetForModels((Object)this, options);
            configurator.cleanResourceSetForModels((Object)this);
            Assert.assertEquals((Object)true, (Object)(rs.getPackageRegistry() instanceof CDOViewSetPackageRegistryImpl));
        }
        finally {
            server.stop();
        }
    }

    @Test(expected=RemoteException.class)
    public void withoutAuthWrongRepo() {
        CDOServer server = new CDOServer(true);
        server.start();
        try {
            CDOResourceSetConfigurator configurator = new CDOResourceSetConfigurator();
            LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
            options.put("CDOServer", "tcp://127.0.0.1:12345");
            options.put("CDORepository", "WrongRepository");
            options.put("CDOLogin", "user");
            options.put("CDOPassword", "password");
            ResourceSet rs = configurator.createResourceSetForModels((Object)this, options);
            configurator.cleanResourceSetForModels((Object)this);
        }
        finally {
            server.stop();
        }
    }
}

