/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Binding;
import org.eclipse.acceleo.ErrorBinding;
import org.eclipse.acceleo.ErrorBlockComment;
import org.eclipse.acceleo.ErrorComment;
import org.eclipse.acceleo.ErrorExpression;
import org.eclipse.acceleo.ErrorExpressionStatement;
import org.eclipse.acceleo.ErrorFileStatement;
import org.eclipse.acceleo.ErrorForStatement;
import org.eclipse.acceleo.ErrorIfStatement;
import org.eclipse.acceleo.ErrorImport;
import org.eclipse.acceleo.ErrorLetStatement;
import org.eclipse.acceleo.ErrorMetamodel;
import org.eclipse.acceleo.ErrorModule;
import org.eclipse.acceleo.ErrorModuleDocumentation;
import org.eclipse.acceleo.ErrorModuleElementDocumentation;
import org.eclipse.acceleo.ErrorModuleReference;
import org.eclipse.acceleo.ErrorProtectedArea;
import org.eclipse.acceleo.ErrorQuery;
import org.eclipse.acceleo.ErrorTemplate;
import org.eclipse.acceleo.ErrorVariable;
import org.eclipse.acceleo.ForStatement;
import org.eclipse.acceleo.IfStatement;
import org.eclipse.acceleo.LetStatement;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.TypedElement;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposal;
import org.eclipse.acceleo.aql.completion.proposals.AcceleoCompletionProposalsProvider;
import org.eclipse.acceleo.aql.completion.proposals.syntax.AcceleoSyntacticCompletionProposals;
import org.eclipse.acceleo.aql.completion.proposals.templates.AcceleoCodeTemplateCompletionProposal;
import org.eclipse.acceleo.aql.completion.proposals.templates.AcceleoCodeTemplateCompletionProposalsProvider;
import org.eclipse.acceleo.aql.completion.proposals.templates.AcceleoCodeTemplates;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.parser.AstCompletor;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.acceleo.query.runtime.ICompletionResult;
import org.eclipse.acceleo.query.runtime.IProposalFilter;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.BasicFilter;
import org.eclipse.acceleo.query.runtime.impl.CompletionServices;
import org.eclipse.acceleo.query.runtime.impl.QueryCompletionEngine;
import org.eclipse.acceleo.query.runtime.impl.completion.EClassifierCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EEnumLiteralCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EFeatureCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.EOperationServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.completion.VariableDeclarationCompletionProposal;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class AcceleoAstCompletor
extends AcceleoSwitch<List<AcceleoCompletionProposal>> {
    private static final Comparator<ICompletionProposal> COMPLETION_PROPOSAL_COMPARATOR = new ProposalComparator();
    private static final String SPACE = " ";
    private final IQualifiedNameQueryEnvironment queryEnvironment;
    private final IAcceleoValidationResult acceleoValidationResult;
    private final QueryCompletionEngine aqlCompletionEngine;
    private final AstCompletor astCompletor;
    private final AcceleoCompletionProposalsProvider acceleoCompletionProposalProvider;
    private final String newLine;
    private final AcceleoCodeTemplates acceleoCodeTemplates;
    private String computedModuleName;
    private String moduleSourceFragment;

    public AcceleoAstCompletor(IQualifiedNameQueryEnvironment queryEnvironment, IAcceleoValidationResult acceleoValidationResult, String newLine) {
        this.queryEnvironment = Objects.requireNonNull(queryEnvironment);
        this.acceleoValidationResult = Objects.requireNonNull(acceleoValidationResult);
        this.astCompletor = new AstCompletor(new CompletionServices((IReadOnlyQueryEnvironment)this.queryEnvironment));
        this.aqlCompletionEngine = new QueryCompletionEngine((IReadOnlyQueryEnvironment)queryEnvironment);
        this.acceleoCompletionProposalProvider = new AcceleoCompletionProposalsProvider(newLine);
        this.newLine = newLine;
        this.acceleoCodeTemplates = new AcceleoCodeTemplates(newLine);
    }

    public List<AcceleoCompletionProposal> getCompletion(String computedModuleName, String sourceFragment, EObject acceleoElementToComplete) {
        this.computedModuleName = computedModuleName;
        this.moduleSourceFragment = sourceFragment;
        return (List)this.doSwitch(acceleoElementToComplete);
    }

    @Override
    public List<AcceleoCompletionProposal> caseModule(Module moduleToComplete) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (!moduleToComplete.getModuleElements().stream().anyMatch(moduleElement -> moduleElement instanceof Query || moduleElement instanceof Template)) {
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.IMPORT));
        }
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.TEMPLATE));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.QUERY));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.MODULE_ELEMENT_DOCUMENTATION));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.COMMENT));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.BLOCK_COMMENT));
        res.add(AcceleoCodeTemplateCompletionProposalsProvider.NEW_COMMENT_MAIN);
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorComment(ErrorComment errorComment) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorComment.getMissingEndHeader() != -1) {
            if (errorComment instanceof ErrorBlockComment) {
                res.add(AcceleoSyntacticCompletionProposals.BLOCK_COMMENT_END);
            } else {
                res.add(AcceleoSyntacticCompletionProposals.COMMENT_END);
            }
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorModuleDocumentation(ErrorModuleDocumentation errorModuleDocumentation) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorModuleDocumentation.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.DOCUMENTATION_END);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorModuleElementDocumentation(ErrorModuleElementDocumentation errorModuleElementDocumentation) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorModuleElementDocumentation.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.DOCUMENTATION_END);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorModule(ErrorModule errorModule) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorModule.getMissingOpenParenthesis() != -1) {
            if (errorModule.getName() == null) {
                res.add(new AcceleoCodeTemplateCompletionProposal(this.computedModuleName, this.computedModuleName, AcceleoPackage.Literals.MODULE));
            } else {
                res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
            }
        } else if (errorModule.getMissingEPackage() != -1) {
            ArrayList candidateMetamodelURIs = new ArrayList(EPackage.Registry.INSTANCE.keySet());
            Collections.sort(candidateMetamodelURIs);
            for (String nsURI : candidateMetamodelURIs) {
                String metamodelString = "'" + nsURI + "'";
                res.add(new AcceleoCompletionProposal(nsURI, metamodelString, AcceleoPackage.Literals.METAMODEL));
            }
        } else if (errorModule.getMissingCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            res.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
        } else if (errorModule.getMissingEndHeader() != -1) {
            if (errorModule.getExtends() == null) {
                res.add(AcceleoSyntacticCompletionProposals.MODULE_HEADER_END);
                res.add(AcceleoSyntacticCompletionProposals.MODULE_EXTENSION);
            } else {
                String referenceQualifiedName = errorModule.getExtends().getQualifiedName();
                List<AcceleoCompletionProposal> refenceCompletions = this.getReferenceCompletion(referenceQualifiedName);
                if (!refenceCompletions.isEmpty()) {
                    res.addAll(refenceCompletions);
                } else {
                    res.add(AcceleoSyntacticCompletionProposals.MODULE_HEADER_END);
                }
            }
        } else {
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.MODULE));
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.MODULE_DOCUMENTATION));
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.COMMENT));
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.BLOCK_COMMENT));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorMetamodel(ErrorMetamodel errorMetamodel) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorMetamodel.getFragment() != null) {
            for (String nsURI : EPackage.Registry.INSTANCE.keySet()) {
                if (!nsURI.contains(errorMetamodel.getFragment())) continue;
                res.add(new AcceleoCompletionProposal(nsURI, nsURI, AcceleoPackage.Literals.METAMODEL));
            }
        } else if (errorMetamodel.getMissingEndQuote() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.QUOTE_DOUBLE);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorImport(ErrorImport errorImport) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorImport.getMissingEnd() != -1) {
            String referenceQualifiedName = errorImport.getModule().getQualifiedName();
            List<AcceleoCompletionProposal> refenceCompletions = this.getReferenceCompletion(referenceQualifiedName);
            if (!refenceCompletions.isEmpty()) {
                res.addAll(refenceCompletions);
            } else {
                res.add(AcceleoSyntacticCompletionProposals.IMPORT_END);
            }
        }
        return res;
    }

    private List<AcceleoCompletionProposal> getReferenceCompletion(String referenceQualifiedName) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (this.queryEnvironment.getLookupEngine().getResolver().resolve(referenceQualifiedName) == null) {
            ArrayList availableQualifiedNames = new ArrayList(this.queryEnvironment.getLookupEngine().getResolver().getAvailableQualifiedNames());
            Collections.sort(availableQualifiedNames);
            for (String qualifiedName : availableQualifiedNames) {
                if (referenceQualifiedName != null && !qualifiedName.contains(referenceQualifiedName)) continue;
                res.add(new AcceleoCodeTemplateCompletionProposal(qualifiedName, qualifiedName, AcceleoPackage.Literals.MODULE_REFERENCE));
            }
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorModuleReference(ErrorModuleReference errorModuleReference) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        ArrayList availableQualifiedNames = new ArrayList(this.queryEnvironment.getLookupEngine().getResolver().getAvailableQualifiedNames());
        Collections.sort(availableQualifiedNames);
        for (String qualifiedName : availableQualifiedNames) {
            res.add(new AcceleoCodeTemplateCompletionProposal(qualifiedName, qualifiedName, AcceleoPackage.Literals.MODULE_REFERENCE));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorTemplate(ErrorTemplate errorTemplate) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorTemplate.getMissingVisibility() != -1) {
            res.addAll(AcceleoSyntacticCompletionProposals.MODULE_ELEMENT_VISIBILITY_KINDS);
        } else if (errorTemplate.getMissingName() != -1) {
            String sampleTemplateName = "myTemplate";
            res.add(new AcceleoCodeTemplateCompletionProposal(sampleTemplateName, sampleTemplateName, AcceleoPackage.Literals.TEMPLATE));
        } else if (errorTemplate.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorTemplate.getMissingParameters() != -1) {
            String sampleParameterName = "myParameter";
            res.add(new AcceleoCodeTemplateCompletionProposal(sampleParameterName, sampleParameterName, AcceleoPackage.Literals.TEMPLATE));
        } else if (errorTemplate.getMissingCloseParenthesis() != -1) {
            if (!errorTemplate.getParameters().isEmpty()) {
                Variable parameter = (Variable)errorTemplate.getParameters().get(errorTemplate.getParameters().size() - 1);
                LinkedHashSet<IType> types = this.getPossibleTypes(parameter);
                if (types.stream().filter(t -> !(t instanceof NothingType)).collect(Collectors.toList()).isEmpty()) {
                    res.addAll(this.getAqlCompletionProposals(Collections.emptyMap(), this.acceleoValidationResult.getValidationResult(parameter.getType())));
                } else {
                    res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
                    res.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
                }
            } else {
                res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
                res.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
            }
        } else if (errorTemplate.getMissingGuardOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorTemplate.getGuard() != null && errorTemplate.getGuard().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorTemplate), this.acceleoValidationResult.getValidationResult(errorTemplate.getGuard().getAst())));
        } else if (errorTemplate.getMissingGuardCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorTemplate), this.acceleoValidationResult.getValidationResult(errorTemplate.getGuard().getAst())));
        } else if (errorTemplate.getPost() != null && errorTemplate.getPost().getAst().getAst() instanceof Error) {
            HashMap<String, Set<IType>> variables = new HashMap<String, Set<IType>>();
            Set<ClassType> possibleTypes = Collections.singleton(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, String.class));
            variables.put("self", possibleTypes);
            res.addAll(this.getAqlCompletionProposals(variables, this.acceleoValidationResult.getValidationResult(errorTemplate.getPost().getAst())));
        } else if (errorTemplate.getMissingPostCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorTemplate), this.acceleoValidationResult.getValidationResult(errorTemplate.getPost().getAst())));
        } else if (errorTemplate.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.TEMPLATE_HEADER_END);
            if (errorTemplate.getGuard() == null && errorTemplate.getPost() == null) {
                res.add(AcceleoSyntacticCompletionProposals.TEMPLATE_GUARD_START);
            }
            if (errorTemplate.getPost() == null) {
                res.add(AcceleoSyntacticCompletionProposals.TEMPLATE_POST_START);
            }
        } else if (errorTemplate.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.TEMPLATE_END);
            int column = this.acceleoValidationResult.getAcceleoAstResult().getEndColumn(errorTemplate);
            res.addAll(this.getStatementProposals(column));
        }
        return res;
    }

    private List<AcceleoCompletionProposal> getStatementProposals(int column) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        res.addAll(this.getBodyCompletionProposals(column));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.STATEMENT));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.COMMENT));
        res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.BLOCK_COMMENT));
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorQuery(ErrorQuery errorQuery) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorQuery.getMissingVisibility() != -1) {
            res.addAll(AcceleoSyntacticCompletionProposals.MODULE_ELEMENT_VISIBILITY_KINDS);
        } else if (errorQuery.getMissingName() != -1) {
            String sampleQueryName = "myQuery";
            res.add(new AcceleoCodeTemplateCompletionProposal(sampleQueryName, sampleQueryName, AcceleoPackage.Literals.QUERY));
        } else if (errorQuery.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorQuery.getMissingParameters() != -1) {
            String sampleParameterName = "myParameter";
            res.add(new AcceleoCodeTemplateCompletionProposal(sampleParameterName, sampleParameterName, AcceleoPackage.Literals.TEMPLATE));
        } else if (errorQuery.getMissingCloseParenthesis() != -1) {
            if (!errorQuery.getParameters().isEmpty()) {
                Variable parameter = (Variable)errorQuery.getParameters().get(errorQuery.getParameters().size() - 1);
                LinkedHashSet<IType> types = this.getPossibleTypes(parameter);
                if (types.stream().filter(t -> !(t instanceof NothingType)).collect(Collectors.toList()).isEmpty()) {
                    res.addAll(this.getAqlCompletionProposals(Collections.emptyMap(), this.acceleoValidationResult.getValidationResult(parameter.getType())));
                } else {
                    res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
                    res.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
                }
            } else {
                res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
                res.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
            }
        } else if (errorQuery.getMissingColon() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.COLON_SPACE);
        } else if (errorQuery.getMissingType() != -1) {
            IValidationResult typeValidation = this.acceleoValidationResult.getValidationResult(errorQuery.getType());
            res.addAll(this.astCompletor.getProposals(Collections.emptySet(), typeValidation).stream().map(AcceleoAstCompletor::transform).collect(Collectors.toList()));
        } else if (errorQuery.getMissingEqual() != -1) {
            LinkedHashSet<IType> types = this.getPossibleTypes(errorQuery);
            if (types.stream().filter(t -> !(t instanceof NothingType)).collect(Collectors.toList()).isEmpty()) {
                res.addAll(this.getAqlCompletionProposals(Collections.emptyMap(), this.acceleoValidationResult.getValidationResult(errorQuery.getType())));
            } else {
                res.add(AcceleoSyntacticCompletionProposals.EQUAL_SPACE);
            }
        } else if (errorQuery.getBody().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorQuery), this.acceleoValidationResult.getValidationResult(errorQuery.getBody().getAst())));
        } else if (errorQuery.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.QUERY_END);
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorQuery), this.acceleoValidationResult.getValidationResult(errorQuery.getBody().getAst())));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorVariable(ErrorVariable errorVariable) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorVariable.getMissingName() == -1) {
            if (errorVariable.getMissingColon() != -1) {
                res.add(AcceleoSyntacticCompletionProposals.COLON_SPACE);
            } else if (errorVariable.getMissingType() != -1) {
                IValidationResult typeValidation = this.acceleoValidationResult.getValidationResult(errorVariable.getType());
                res.addAll(this.astCompletor.getProposals(Collections.emptySet(), typeValidation).stream().map(AcceleoAstCompletor::transform).collect(Collectors.toList()));
            } else {
                res.addAll(this.getAqlCompletionProposals(Collections.emptyMap(), this.acceleoValidationResult.getValidationResult(errorVariable.getType())));
            }
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorExpression(ErrorExpression errorExpression) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorExpression.getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorExpression), this.acceleoValidationResult.getValidationResult(errorExpression.getAst())));
        }
        return res;
    }

    private Map<String, Set<IType>> getVariables(AcceleoASTNode scope) {
        HashMap<String, Set<IType>> res = new HashMap<String, Set<IType>>();
        AcceleoASTNode currentScope = scope;
        while (currentScope != null) {
            if (currentScope instanceof Template) {
                Template template = (Template)currentScope;
                for (Variable variable : template.getParameters()) {
                    res.put(variable.getName(), this.getPossibleTypes(variable));
                }
            } else if (currentScope instanceof Query) {
                Query query = (Query)currentScope;
                for (Variable variable : query.getParameters()) {
                    res.put(variable.getName(), this.getPossibleTypes(variable));
                }
            } else if (currentScope instanceof LetStatement) {
                LetStatement let = (LetStatement)currentScope;
                for (Binding binding : let.getVariables()) {
                    res.put(binding.getName(), this.getPossibleTypes(binding));
                }
            } else if (currentScope instanceof ForStatement) {
                ForStatement forStatement = (ForStatement)currentScope;
                res.put(forStatement.getBinding().getName(), this.getPossibleTypes(forStatement.getBinding()));
                LinkedHashSet<ClassType> possibleIndexTypes = new LinkedHashSet<ClassType>();
                possibleIndexTypes.add(new ClassType((IReadOnlyQueryEnvironment)this.queryEnvironment, Integer.class));
                res.put(forStatement.getBinding().getName() + "Index", possibleIndexTypes);
            }
            currentScope = currentScope.eContainer() instanceof AcceleoASTNode ? (AcceleoASTNode)currentScope.eContainer() : null;
        }
        return res;
    }

    private LinkedHashSet<IType> getPossibleTypes(TypedElement variable) {
        LinkedHashSet<IType> res = new LinkedHashSet<IType>();
        IValidationResult validationResult = this.acceleoValidationResult.getValidationResult(variable.getType());
        if (variable.getType() != null) {
            res.addAll(validationResult.getPossibleTypes(variable.getType().getAst()));
        }
        return res;
    }

    private Set<IType> getPossibleTypes(Binding binding) {
        LinkedHashSet<Object> res;
        if (binding.getInitExpression() != null) {
            IValidationResult validationResult = this.acceleoValidationResult.getValidationResult(binding.getInitExpression().getAst());
            res = new LinkedHashSet();
            res.addAll(validationResult.getPossibleTypes(binding.getInitExpression().getAst().getAst()));
        } else {
            res = this.getPossibleTypes((TypedElement)binding);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorBinding(ErrorBinding errorBinding) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorBinding.getMissingName() != -1) {
            String sampleVariableName = "myVariable";
            res.add(new AcceleoCodeTemplateCompletionProposal(sampleVariableName, sampleVariableName, AcceleoPackage.Literals.BINDING));
        } else if (errorBinding.getMissingColon() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.COLON_SPACE);
        } else if (errorBinding.getMissingType() != -1) {
            IValidationResult typeValidationResult = this.acceleoValidationResult.getValidationResult(errorBinding.getType());
            res.addAll(this.astCompletor.getProposals(Collections.emptySet(), typeValidationResult).stream().map(AcceleoAstCompletor::transform).collect(Collectors.toList()));
        } else if (errorBinding.getMissingAffectationSymbolePosition() != -1) {
            if (errorBinding.getType() == null && errorBinding.getTypeAql() == null) {
                res.add(AcceleoSyntacticCompletionProposals.COLON_SPACE);
            }
            res.add(new AcceleoCompletionProposal(errorBinding.getMissingAffectationSymbole(), errorBinding.getMissingAffectationSymbole() + SPACE, AcceleoPackage.Literals.BINDING));
        } else if (errorBinding.getInitExpression().getAst().getAst() instanceof Error) {
            AcceleoASTNode context = (AcceleoASTNode)errorBinding.eContainer().eContainer();
            res.addAll(this.getAqlCompletionProposals(this.getVariables(context), this.acceleoValidationResult.getValidationResult(errorBinding.getInitExpression().getAst())));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorExpressionStatement(ErrorExpressionStatement errorExpressionStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorExpressionStatement.getExpression().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorExpressionStatement), this.acceleoValidationResult.getValidationResult(errorExpressionStatement.getExpression().getAst())));
        } else if (errorExpressionStatement.getMissingEndHeader() != -1) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorExpressionStatement), this.acceleoValidationResult.getValidationResult(errorExpressionStatement.getExpression().getAst())));
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_EXPRESSION_END);
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorProtectedArea(ErrorProtectedArea errorProtectedArea) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorProtectedArea.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorProtectedArea.getId().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorProtectedArea), this.acceleoValidationResult.getValidationResult(errorProtectedArea.getId().getAst())));
        } else if (errorProtectedArea.getMissingCloseParenthesis() != -1) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorProtectedArea), this.acceleoValidationResult.getValidationResult(errorProtectedArea.getId().getAst())));
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_HEADER_CLOSE_PARENTHESIS_AND_END);
        } else if (errorProtectedArea.getMissingStartTagPrefixCloseParenthesis() != -1) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorProtectedArea), this.acceleoValidationResult.getValidationResult(errorProtectedArea.getId().getAst())));
            res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_HEADER_CLOSE_PARENTHESIS_AND_END);
        } else if (errorProtectedArea.getMissingEndTagPrefixCloseParenthesis() != -1) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorProtectedArea), this.acceleoValidationResult.getValidationResult(errorProtectedArea.getId().getAst())));
            res.add(AcceleoSyntacticCompletionProposals.CLOSE_PARENTHESIS);
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_HEADER_CLOSE_PARENTHESIS_AND_END);
        } else if (errorProtectedArea.getMissingEndHeader() != -1) {
            if (errorProtectedArea.getEndTagPrefix() == null) {
                if (errorProtectedArea.getStartTagPrefix() == null) {
                    res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_START_TAG_PREFIX);
                }
                res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_END_TAG_PREFIX);
            }
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_HEADER_END);
        } else if (errorProtectedArea.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_PROTECTED_AREA_END);
            int column = this.acceleoValidationResult.getAcceleoAstResult().getEndColumn(errorProtectedArea);
            res.addAll(this.getStatementProposals(column));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorForStatement(ErrorForStatement errorForStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorForStatement.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorForStatement.getMissingBinding() != -1) {
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.BINDING));
            res.add(AcceleoSyntacticCompletionProposals.FOR_STATEMENT_PIPE);
        } else if (errorForStatement.getMissingCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_CLOSE_PARENTHESIS_AND_END);
            if (errorForStatement.getSeparator() == null) {
                res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_SEPARATOR);
            }
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorForStatement), this.acceleoValidationResult.getValidationResult(errorForStatement.getBinding().getType())));
        } else if (errorForStatement.getSeparator() != null && errorForStatement.getSeparator().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorForStatement), this.acceleoValidationResult.getValidationResult(errorForStatement.getSeparator().getAst())));
        } else if (errorForStatement.getMissingSeparatorCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_CLOSE_PARENTHESIS_AND_END);
        } else if (errorForStatement.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_END);
            if (errorForStatement.getSeparator() == null) {
                res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_HEADER_SEPARATOR);
            }
        } else if (errorForStatement.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FOR_END);
            int column = this.acceleoValidationResult.getAcceleoAstResult().getEndColumn(errorForStatement);
            res.addAll(this.getStatementProposals(column));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorIfStatement(ErrorIfStatement errorIfStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorIfStatement.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorIfStatement.getCondition().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorIfStatement), this.acceleoValidationResult.getValidationResult(errorIfStatement.getCondition().getAst())));
        } else if (errorIfStatement.getMissingCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_HEADER_CLOSE_PARENTHESIS_AND_END);
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorIfStatement), this.acceleoValidationResult.getValidationResult(errorIfStatement.getCondition().getAst())));
        } else if (errorIfStatement.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_HEADER_END);
        } else if (errorIfStatement.getMissingEnd() != -1) {
            if (errorIfStatement.getElse() == null) {
                res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_ELSE);
                if (errorIfStatement.eContainer().eContainingFeature() == AcceleoPackage.eINSTANCE.getIfStatement_Else() || !(errorIfStatement.eContainer().eContainer() instanceof IfStatement)) {
                    res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_ELSEIF);
                }
            }
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_IF_END);
            int column = this.acceleoValidationResult.getAcceleoAstResult().getEndColumn(errorIfStatement);
            res.addAll(this.getStatementProposals(column));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorLetStatement(ErrorLetStatement errorLetStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorLetStatement.getMissingBindings() != -1) {
            res.addAll(this.acceleoCompletionProposalProvider.getProposalsFor(this.computedModuleName, AcceleoPackage.Literals.BINDING));
        } else if (errorLetStatement.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_LET_HEADER_END);
            EList bindings = errorLetStatement.getVariables();
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorLetStatement), this.acceleoValidationResult.getValidationResult(((Binding)bindings.get(bindings.size() - 1)).getType())));
        } else if (errorLetStatement.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_LET_END);
            int column = this.acceleoValidationResult.getAcceleoAstResult().getEndColumn(errorLetStatement);
            res.addAll(this.getStatementProposals(column));
        }
        return res;
    }

    @Override
    public List<AcceleoCompletionProposal> caseErrorFileStatement(ErrorFileStatement errorFileStatement) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        if (errorFileStatement.getMissingOpenParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.OPEN_PARENTHESIS);
        } else if (errorFileStatement.getUrl().getAst().getAst() instanceof Error) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorFileStatement), this.acceleoValidationResult.getValidationResult(errorFileStatement.getUrl().getAst())));
        } else if (errorFileStatement.getMissingComma() != -1) {
            res.addAll(this.getAqlCompletionProposals(this.getVariables(errorFileStatement), this.acceleoValidationResult.getValidationResult(errorFileStatement.getUrl().getAst())));
            res.add(AcceleoSyntacticCompletionProposals.COMMA_SPACE);
        } else if (errorFileStatement.getMissingOpenMode() != -1) {
            res.addAll(AcceleoSyntacticCompletionProposals.STATEMENT_FILE_OPEN_MODES);
        } else if (errorFileStatement.getMissingCloseParenthesis() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FILE_HEADER_CLOSE_PARENTHESIS_AND_END);
        } else if (errorFileStatement.getMissingEndHeader() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FILE_HEADER_END);
        } else if (errorFileStatement.getMissingEnd() != -1) {
            res.add(AcceleoSyntacticCompletionProposals.STATEMENT_FILE_END);
            int column = this.acceleoValidationResult.getAcceleoAstResult().getEndColumn(errorFileStatement);
            res.addAll(this.getStatementProposals(column));
        }
        return res;
    }

    private List<AcceleoCompletionProposal> getAqlCompletionProposals(Map<String, Set<IType>> variables, IValidationResult aqlValidationResult) {
        int startPosition = this.acceleoValidationResult.getAcceleoAstResult().getStartPosition((ASTNode)aqlValidationResult.getAstResult().getAst());
        String expression = this.moduleSourceFragment.substring(startPosition, this.moduleSourceFragment.length());
        ICompletionResult completionResult = this.aqlCompletionEngine.getCompletion(expression, expression.length(), variables);
        completionResult.sort(COMPLETION_PROPOSAL_COMPARATOR);
        List aqlProposals = completionResult.getProposals((IProposalFilter)new BasicFilter(completionResult));
        List<AcceleoCompletionProposal> aqlProposalsAsAcceleoProposals = aqlProposals.stream().map(AcceleoAstCompletor::transform).collect(Collectors.toList());
        return aqlProposalsAsAcceleoProposals;
    }

    private List<AcceleoCompletionProposal> getBodyCompletionProposals(int column) {
        ArrayList<AcceleoCompletionProposal> res = new ArrayList<AcceleoCompletionProposal>();
        Object newLinePrefix = this.newLine;
        int i = 0;
        while (i < column) {
            newLinePrefix = (String)newLinePrefix + SPACE;
            ++i;
        }
        res.add(new AcceleoCodeTemplateCompletionProposal("New For", "Inserts the following For Statement:<br/><pre>" + this.acceleoCodeTemplates.newForStatement() + "</pre>", this.acceleoCodeTemplates.newForStatement().replaceAll(this.newLine, (String)newLinePrefix), AcceleoPackage.Literals.FOR_STATEMENT));
        res.add(new AcceleoCodeTemplateCompletionProposal("New If", "Inserts the following If Statement:<br/><pre>" + this.acceleoCodeTemplates.newIfStatement() + "</pre>", this.acceleoCodeTemplates.newIfStatement().replaceAll(this.newLine, (String)newLinePrefix), AcceleoPackage.Literals.IF_STATEMENT));
        res.add(new AcceleoCodeTemplateCompletionProposal("New Let", "Inserts the following Let Statement:<br/><pre>" + this.acceleoCodeTemplates.newLetStatement() + "</pre>", this.acceleoCodeTemplates.newLetStatement().replaceAll(this.newLine, (String)newLinePrefix), AcceleoPackage.Literals.LET_STATEMENT));
        res.add(new AcceleoCodeTemplateCompletionProposal("New File", "Inserts the following File Statement:<br/><pre>" + this.acceleoCodeTemplates.newFileStatement() + "</pre>", this.acceleoCodeTemplates.newFileStatement().replaceAll(this.newLine, (String)newLinePrefix), AcceleoPackage.Literals.FILE_STATEMENT));
        res.add(new AcceleoCodeTemplateCompletionProposal("New Protected Area", "Inserts the following Protected Area Statement:<br/><pre>" + this.acceleoCodeTemplates.newProtectedAreaStatement() + "</pre>", this.acceleoCodeTemplates.newProtectedAreaStatement().replaceAll(this.newLine, (String)newLinePrefix), AcceleoPackage.Literals.PROTECTED_AREA));
        return res;
    }

    private static AcceleoCompletionProposal transform(ICompletionProposal aqlCompletionProposal) {
        String description = StringServices.NEW_LINE_PATTERN.matcher(aqlCompletionProposal.getDescription()).replaceAll("<br>");
        return new AcceleoCompletionProposal(aqlCompletionProposal.getProposal(), description, aqlCompletionProposal.getProposal(), AcceleoPackage.Literals.EXPRESSION);
    }

    private static class ProposalComparator
    implements Comparator<ICompletionProposal> {
        private ProposalComparator() {
        }

        @Override
        public int compare(ICompletionProposal o1, ICompletionProposal o2) {
            int value1 = this.getValue(o1);
            int value2 = this.getValue(o2);
            int res = o1 instanceof IServiceCompletionProposal && o2 instanceof IServiceCompletionProposal ? ((IServiceCompletionProposal)o1).getObject().getShortSignature().compareTo(((IServiceCompletionProposal)o2).getObject().getShortSignature()) : (value1 > value2 ? 1 : (value1 < value2 ? -1 : (o1 != null && o2 != null ? o1.getProposal().compareTo(o2.getProposal()) : 0)));
            return res;
        }

        private int getValue(ICompletionProposal proposal) {
            int res = proposal instanceof VariableCompletionProposal || proposal instanceof VariableDeclarationCompletionProposal ? 0 : (proposal instanceof EFeatureCompletionProposal ? 1 : (proposal instanceof IServiceCompletionProposal || proposal instanceof EOperationServiceCompletionProposal ? 2 : (proposal instanceof EClassifierCompletionProposal || proposal instanceof EEnumLiteralCompletionProposal || proposal instanceof EFeatureCompletionProposal ? 3 : 4)));
            return res;
        }
    }
}

