/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.XPathServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.Test;

public class XPathServicesValidationTest
extends AbstractServicesValidationTest {
    @Override
    public void before() throws Exception {
        super.before();
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), XPathServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)services);
    }

    @Test
    public void testAncestorsNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifier=eCls1 can't be contained"))};
            IType[] expectedReturnAllTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling ancestors:\nEClassifier=eCls1 can't be contained"))};
            this.assertValidation(expectedReturnTypes, expectedReturnAllTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testAncestorsFilterEClass() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnum())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilterEClassClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnum())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilterSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnum())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilterSetClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnum())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestors() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnum())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EClass.class)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEModelElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEEnum())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredSetClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredSetOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredSetOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls2), this.eClassifierLiteralType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifierLiteral=eCls1 can't contain directly or indirectly EClassifier=eCls2"))};
            IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling ancestors:\nEClassifierLiteral=eCls1 can't contain directly or indirectly EClassifier=eCls2"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testAncestorsFiltered() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredLoweredByTypes() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getETypedElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getETypedElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredLoweredByTypesClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getETypedElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getETypedElement())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEOperation()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredLoweredByFilterClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAncestorsFilteredNoType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        EReference ref1 = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        ref1.setName("ref1");
        ref1.setContainment(true);
        ref1.setEType((EClassifier)eCls1);
        eCls1.getEStructuralFeatures().add((Object)ref1);
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("EClassifierLiteral=eCls2 can't contain directly or indirectly EClassifier=eCls1"))};
            IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing will be left after calling ancestors:\nEClassifierLiteral=eCls2 can't contain directly or indirectly EClassifier=eCls1"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "ancestors", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testFollowingSiblingsNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testFollowingSiblings() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EClass.class)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilterEClass() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilterEClassClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilterSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilterSetClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFollowingFilteredSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFollowingFilteredSetClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFollowingFilteredSetOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFollowingFilteredSetOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls2), this.eClassifierLiteralType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls1))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testFollowingSiblingsFiltered() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredLoweredByTypes() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getENamedElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getENamedElement()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredLoweredByTypesClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getENamedElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getENamedElement()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredLoweredByFilterClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testFollowingSiblingsFilteredNoType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        EReference ref1 = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        ref1.setName("ref1");
        ref1.setContainment(true);
        ref1.setEType((EClassifier)eCls1);
        eCls1.getEStructuralFeatures().add((Object)ref1);
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls2))};
            this.assertValidation(expectedReturnTypes, "followingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testPrecedingSiblingsNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testPrecedingSiblings() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EClass.class)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilterEClass() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilterEClassClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilterSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilterSetClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredSetClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredSetOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredSetOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls2), this.eClassifierLiteralType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls1))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testPrecedingSiblingsFiltered() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredLoweredByTypes() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getENamedElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getENamedElement()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredLoweredByTypesClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getENamedElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getENamedElement()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredLoweredByFilterClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testPrecedingSiblingsFilteredNoType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        EReference ref1 = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        ref1.setName("ref1");
        ref1.setContainment(true);
        ref1.setEType((EClassifier)eCls1);
        eCls1.getEStructuralFeatures().add((Object)ref1);
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls2))};
            this.assertValidation(expectedReturnTypes, "precedingSiblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testSiblingsNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testSiblings() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EClass.class)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilterEClass() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilterEClassClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilterSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilterSetClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEAnnotation())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredNotContainedEClass() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls2), this.eClassifierLiteralType((EClassifier)eCls1)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls1))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testSiblingsFiltered() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredSetClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredSetOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredSetOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEPackage(), EcorePackage.eINSTANCE.getEClass()})};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredOnEObject() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEObject()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredOnEObjectClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EObject.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredLoweredByTypes() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getENamedElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getENamedElement()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredLoweredByTypesClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getENamedElement())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getENamedElement()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredLoweredByFilter() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredLoweredByFilterClassType() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.classType(EPackage.class), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSiblingsFilteredNoType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        EReference ref1 = EcorePackage.eINSTANCE.getEcoreFactory().createEReference();
        ref1.setName("ref1");
        ref1.setContainment(true);
        ref1.setEType((EClassifier)eCls1);
        eCls1.getEStructuralFeatures().add((Object)ref1);
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        IService<?> service = this.serviceLookUp("siblings", new Object[]{EcoreUtil.create((EClass)eCls1), eCls2});
        Assert.assertTrue((service != null ? 1 : 0) != 0);
        ArrayList<EClassifierType> argTypes = new ArrayList<EClassifierType>();
        argTypes.add(this.eClassifierType((EClassifier)eCls1));
        argTypes.add(this.eClassifierLiteralType((EClassifier)eCls2));
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.eClassifierType((EClassifier)eCls1), this.eClassifierLiteralType((EClassifier)eCls2)};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls2))};
            this.assertValidation(expectedReturnTypes, "siblings", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }
}

