/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import org.eclipse.acceleo.query.services.ComparableServices;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComparableServicesTest {
    ComparableServices comparableServices;

    @Before
    public void setup() {
        this.comparableServices = new ComparableServices();
    }

    @Test
    public void testLessThanNullNull() {
        Assert.assertFalse((boolean)this.comparableServices.lessThan(null, null));
    }

    @Test
    public void testLessThanNullTestComparable() {
        TestComparable comparable1 = new TestComparable(1);
        Assert.assertTrue((boolean)this.comparableServices.lessThan(null, (Comparable)comparable1));
    }

    @Test
    public void testLessThanTestComparableNull() {
        TestComparable comparable1 = new TestComparable(1);
        Assert.assertFalse((boolean)this.comparableServices.lessThan((Comparable)comparable1, null));
    }

    @Test
    public void testLessThan() {
        TestComparable comparable1 = new TestComparable(1);
        TestComparable comparable2 = new TestComparable(2);
        Assert.assertTrue((boolean)this.comparableServices.lessThan((Comparable)comparable1, (Comparable)comparable2));
        Assert.assertFalse((boolean)this.comparableServices.lessThan((Comparable)comparable2, (Comparable)comparable1));
        Assert.assertFalse((boolean)this.comparableServices.lessThan((Comparable)comparable1, (Comparable)comparable1));
        Assert.assertFalse((boolean)this.comparableServices.lessThan((Comparable)comparable2, (Comparable)comparable2));
    }

    @Test
    public void testLessThanEqualNullNull() {
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual(null, null));
    }

    @Test
    public void testLessThanEqualNullTestComparable() {
        TestComparable comparable1 = new TestComparable(1);
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual(null, (Comparable)comparable1));
    }

    @Test
    public void testLessThanEqualTestComparableNull() {
        TestComparable comparable1 = new TestComparable(1);
        Assert.assertFalse((boolean)this.comparableServices.lessThanEqual((Comparable)comparable1, null));
    }

    @Test
    public void testLessThanEqual() {
        TestComparable comparable1 = new TestComparable(1);
        TestComparable comparable2 = new TestComparable(2);
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual((Comparable)comparable1, (Comparable)comparable2));
        Assert.assertFalse((boolean)this.comparableServices.lessThanEqual((Comparable)comparable2, (Comparable)comparable1));
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual((Comparable)comparable1, (Comparable)comparable1));
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual((Comparable)comparable2, (Comparable)comparable2));
    }

    @Test
    public void testGreaterThanNullNull() {
        Assert.assertFalse((boolean)this.comparableServices.greaterThan(null, null));
    }

    @Test
    public void testGreaterThanNullTestComparable() {
        TestComparable comparable1 = new TestComparable(1);
        Assert.assertFalse((boolean)this.comparableServices.greaterThan(null, (Comparable)comparable1));
    }

    @Test
    public void testGreaterThanTestComparableNull() {
        TestComparable comparable1 = new TestComparable(1);
        Assert.assertTrue((boolean)this.comparableServices.greaterThan((Comparable)comparable1, null));
    }

    @Test
    public void testGreaterThan() {
        TestComparable comparable1 = new TestComparable(1);
        TestComparable comparable2 = new TestComparable(2);
        Assert.assertFalse((boolean)this.comparableServices.greaterThan((Comparable)comparable1, (Comparable)comparable2));
        Assert.assertTrue((boolean)this.comparableServices.greaterThan((Comparable)comparable2, (Comparable)comparable1));
        Assert.assertFalse((boolean)this.comparableServices.greaterThan((Comparable)comparable1, (Comparable)comparable1));
        Assert.assertFalse((boolean)this.comparableServices.greaterThan((Comparable)comparable2, (Comparable)comparable2));
    }

    @Test
    public void testGreaterThanEqualNullNull() {
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual(null, null));
    }

    @Test
    public void testGreaterThanEqualNullTestComparable() {
        TestComparable comparable1 = new TestComparable(1);
        Assert.assertFalse((boolean)this.comparableServices.greaterThanEqual(null, (Comparable)comparable1));
    }

    @Test
    public void testGreaterThanEqualTestComparableNull() {
        TestComparable comparable1 = new TestComparable(1);
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual((Comparable)comparable1, null));
    }

    @Test
    public void testGreaterThanEqual() {
        TestComparable comparable1 = new TestComparable(1);
        TestComparable comparable2 = new TestComparable(2);
        Assert.assertFalse((boolean)this.comparableServices.greaterThanEqual((Comparable)comparable1, (Comparable)comparable2));
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual((Comparable)comparable2, (Comparable)comparable1));
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual((Comparable)comparable1, (Comparable)comparable1));
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual((Comparable)comparable2, (Comparable)comparable2));
    }

    @Test
    public void testLessThanCatCat() {
        Cat meow = new Cat("Meow");
        Cat nyan = new Cat("Nyan");
        Assert.assertTrue((boolean)this.comparableServices.lessThan((Comparable)meow, (Comparable)nyan));
        Assert.assertFalse((boolean)this.comparableServices.lessThan((Comparable)nyan, (Comparable)meow));
        Assert.assertFalse((boolean)this.comparableServices.lessThan((Comparable)meow, (Comparable)meow));
    }

    @Test
    public void testLessThanCatDog() {
        Cat nyan = new Cat("Nyan");
        Dog bowwow = new Dog("Bow wow");
        Assert.assertFalse((boolean)this.comparableServices.lessThan((Comparable)nyan, (Comparable)bowwow));
        Assert.assertTrue((boolean)this.comparableServices.lessThan((Comparable)bowwow, (Comparable)nyan));
        Assert.assertFalse((boolean)this.comparableServices.lessThan((Comparable)bowwow, (Comparable)bowwow));
    }

    @Test
    public void testLessThanEqualCatCat() {
        Cat meow = new Cat("Meow");
        Cat nyan = new Cat("Nyan");
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual((Comparable)meow, (Comparable)nyan));
        Assert.assertFalse((boolean)this.comparableServices.lessThanEqual((Comparable)nyan, (Comparable)meow));
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual((Comparable)meow, (Comparable)meow));
    }

    @Test
    public void testLessThanEqualCatDog() {
        Cat nyan = new Cat("Nyan");
        Dog bowwow = new Dog("Bow wow");
        Assert.assertFalse((boolean)this.comparableServices.lessThanEqual((Comparable)nyan, (Comparable)bowwow));
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual((Comparable)bowwow, (Comparable)nyan));
        Assert.assertTrue((boolean)this.comparableServices.lessThanEqual((Comparable)bowwow, (Comparable)bowwow));
    }

    @Test
    public void testGreaterThanCatCat() {
        Cat meow = new Cat("Meow");
        Cat nyan = new Cat("Nyan");
        Assert.assertFalse((boolean)this.comparableServices.greaterThan((Comparable)meow, (Comparable)nyan));
        Assert.assertTrue((boolean)this.comparableServices.greaterThan((Comparable)nyan, (Comparable)meow));
        Assert.assertFalse((boolean)this.comparableServices.greaterThan((Comparable)meow, (Comparable)meow));
    }

    @Test
    public void testGreaterThanCatDog() {
        Cat nyan = new Cat("Nyan");
        Dog bowwow = new Dog("Bow wow");
        Assert.assertTrue((boolean)this.comparableServices.greaterThan((Comparable)nyan, (Comparable)bowwow));
        Assert.assertFalse((boolean)this.comparableServices.greaterThan((Comparable)bowwow, (Comparable)nyan));
        Assert.assertFalse((boolean)this.comparableServices.greaterThan((Comparable)bowwow, (Comparable)bowwow));
    }

    @Test
    public void testGreaterThanEqualCatCat() {
        Cat meow = new Cat("Meow");
        Cat nyan = new Cat("Nyan");
        Assert.assertFalse((boolean)this.comparableServices.greaterThanEqual((Comparable)meow, (Comparable)nyan));
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual((Comparable)nyan, (Comparable)meow));
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual((Comparable)meow, (Comparable)meow));
    }

    @Test
    public void testGreaterThanEqualCatDog() {
        Cat nyan = new Cat("Nyan");
        Dog bowwow = new Dog("Bow wow");
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual((Comparable)nyan, (Comparable)bowwow));
        Assert.assertFalse((boolean)this.comparableServices.greaterThanEqual((Comparable)bowwow, (Comparable)nyan));
        Assert.assertTrue((boolean)this.comparableServices.greaterThanEqual((Comparable)bowwow, (Comparable)bowwow));
    }

    private static interface Animal {
        public String getName();
    }

    private static class Cat
    implements Animal,
    Comparable<Animal> {
        private String name;

        public Cat(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(Animal o) {
            if (!(o instanceof Cat)) {
                return 1;
            }
            return this.name.compareTo(((Cat)o).getName());
        }
    }

    private static class Dog
    implements Animal,
    Comparable<Animal> {
        private String name;

        public Dog(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(Animal o) {
            if (!(o instanceof Dog)) {
                return -1;
            }
            return this.name.compareTo(((Dog)o).getName());
        }
    }

    public static final class TestComparable
    implements Comparable<TestComparable> {
        private final int value;

        public TestComparable(int value) {
            this.value = value;
        }

        @Override
        public int compareTo(TestComparable o) {
            int result = o == null ? this.value : this.value - o.value;
            return result;
        }
    }
}

