/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services.tests;

import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.tests.AbstractServicesValidationTest;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.junit.Test;

public class CollectionServicesValidationTest
extends AbstractServicesValidationTest {
    @Override
    public void before() throws Exception {
        super.before();
        Set services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)this.getQueryEnvironment(), CollectionServices.class);
        ServiceUtils.registerServices((IQueryEnvironment)this.getQueryEnvironment(), (Set)services);
    }

    @Test
    public void testAddListNothingString() {
        NothingType nothingType = this.nothingType("Empty");
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)nothingType), this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)nothingType), this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAddListStringNothing() {
        NothingType nothingType = this.nothingType("Empty");
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)nothingType)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)nothingType)};
        IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAddList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAddSetNothingString() {
        NothingType nothingType = this.nothingType("Empty");
        IType[] parameterTypes = new IType[]{this.setType((IType)nothingType), this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)nothingType), this.setType((IType)this.classType(String.class))};
        IType[] expectedAllReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAddSetStringNothing() {
        NothingType nothingType = this.nothingType("Empty");
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)nothingType)};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)nothingType)};
        IType[] expectedAllReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAddSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "add", parameterTypes);
    }

    @Test
    public void testAnyNoBooleanLambda() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.nothingType("expression in an any must return a boolean")};
        this.assertValidation(expectedReturnTypes, "any", parameterTypes);
    }

    @Test
    public void testAnySet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBoolean()))};
            IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
            this.assertValidation(expectedReturnTypes, "any", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAnyList() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBoolean()))};
            IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
            this.assertValidation(expectedReturnTypes, "any", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAsOrderedSetSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "asOrderedSet", parameterTypes);
    }

    @Test
    public void testAsOrderedSetList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "asOrderedSet", parameterTypes);
    }

    @Test
    public void testAsSequenceSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "asSequence", parameterTypes);
    }

    @Test
    public void testAsSequenceList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "asSequence", parameterTypes);
    }

    @Test
    public void testAsSetSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "asSet", parameterTypes);
    }

    @Test
    public void testAsSetList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "asSet", parameterTypes);
    }

    @Test
    public void testAtList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "at", parameterTypes);
    }

    @Test
    public void testAtSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "at", parameterTypes);
    }

    @Test
    public void testSortedBySet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "sortedBy", parameterTypes);
    }

    @Test
    public void testSortedByList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "sortedBy", parameterTypes);
    }

    @Test
    public void testCollectSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "collect", parameterTypes);
    }

    @Test
    public void testCollectList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "collect", parameterTypes);
    }

    @Test
    public void testConcat() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "concat", parameterTypes);
    }

    @Test
    public void testCountSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "count", parameterTypes);
    }

    @Test
    public void testCountList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "count", parameterTypes);
    }

    @Test
    public void testExcludesSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "excludes", parameterTypes);
    }

    @Test
    public void testExcludesList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "excludes", parameterTypes);
    }

    @Test
    public void testIncludesSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "includes", parameterTypes);
    }

    @Test
    public void testIncludesList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "includes", parameterTypes);
    }

    @Test
    public void testIncludingList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "including", parameterTypes);
    }

    @Test
    public void testIncludingSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "including", parameterTypes);
    }

    @Test
    public void testReverseList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "reverse", parameterTypes);
    }

    @Test
    public void testReverseSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "reverse", parameterTypes);
    }

    @Test
    public void testIndexOfList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "indexOf", parameterTypes);
    }

    @Test
    public void testIndexOfSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "indexOf", parameterTypes);
    }

    @Test
    public void testLastIndexOfList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "lastIndexOf", parameterTypes);
    }

    @Test
    public void testLastIndexOfSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "lastIndexOf", parameterTypes);
    }

    @Test
    public void testInsertAt() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class), this.classType(Double.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Double.class))};
        this.assertValidation(expectedReturnTypes, "insertAt", parameterTypes);
    }

    @Test
    public void testIntersectionSetSetNothingLeft() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)eCls1)), this.setType((IType)this.eClassifierType((EClassifier)eCls2))};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.nothingType("Nothing left after intersection of Set(EClassifier=eCls1) and Set(EClassifier=eCls2)"))};
            IType[] expectedAllReturnTypes = new IType[]{this.setType((IType)this.nothingType("Nothing left after intersection:\n Nothing left after intersection of Set(EClassifier=eCls1) and Set(EClassifier=eCls2)"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "intersection", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testIntersectionSetSetTopSubType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        EClass eCls3 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls3.setName("eCls3");
        eCls3.getESuperTypes().add((Object)eCls1);
        eCls3.getESuperTypes().add((Object)eCls2);
        ePkg.getEClassifiers().add((Object)eCls3);
        EClass eCls4 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls4.setName("eCls4");
        eCls4.getESuperTypes().add((Object)eCls1);
        eCls4.getESuperTypes().add((Object)eCls2);
        eCls4.getESuperTypes().add((Object)eCls3);
        ePkg.getEClassifiers().add((Object)eCls4);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)eCls1)), this.setType((IType)this.eClassifierType((EClassifier)eCls2))};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)eCls3))};
            this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testIntersectionSetSetSameType() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionSetSetEClassEClassifier() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(EClass.class)), this.setType((IType)this.classType(EClassifier.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(EClass.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionSetSetEClassifierEClass() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(EClassifier.class)), this.setType((IType)this.classType(EClass.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(EClass.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionListListNothingLeft() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls1)), this.sequenceType((IType)this.eClassifierType((EClassifier)eCls2))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing left after intersection of Sequence(EClassifier=eCls1) and Sequence(EClassifier=eCls2)"))};
            IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing left after intersection:\n Nothing left after intersection of Sequence(EClassifier=eCls1) and Sequence(EClassifier=eCls2)"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "intersection", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testIntersectionListListTopSubType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        EClass eCls3 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls3.setName("eCls3");
        eCls3.getESuperTypes().add((Object)eCls1);
        eCls3.getESuperTypes().add((Object)eCls2);
        ePkg.getEClassifiers().add((Object)eCls3);
        EClass eCls4 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls4.setName("eCls4");
        eCls4.getESuperTypes().add((Object)eCls1);
        eCls4.getESuperTypes().add((Object)eCls2);
        eCls4.getESuperTypes().add((Object)eCls3);
        ePkg.getEClassifiers().add((Object)eCls4);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls1)), this.sequenceType((IType)this.eClassifierType((EClassifier)eCls2))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls3))};
            this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testIntersectionListListSameType() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionListListEClassEClassifier() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(EClass.class)), this.sequenceType((IType)this.classType(EClassifier.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(EClass.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionListListEClassifierEClass() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(EClassifier.class)), this.sequenceType((IType)this.classType(EClass.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(EClass.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionListSetNothingLeft() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls1)), this.setType((IType)this.eClassifierType((EClassifier)eCls2))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing left after intersection of Sequence(EClassifier=eCls1) and Set(EClassifier=eCls2)"))};
            IType[] expectedAllReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("Nothing left after intersection:\n Nothing left after intersection of Sequence(EClassifier=eCls1) and Set(EClassifier=eCls2)"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "intersection", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testIntersectionListSetTopSubType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        EClass eCls3 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls3.setName("eCls3");
        eCls3.getESuperTypes().add((Object)eCls1);
        eCls3.getESuperTypes().add((Object)eCls2);
        ePkg.getEClassifiers().add((Object)eCls3);
        EClass eCls4 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls4.setName("eCls4");
        eCls4.getESuperTypes().add((Object)eCls1);
        eCls4.getESuperTypes().add((Object)eCls2);
        eCls4.getESuperTypes().add((Object)eCls3);
        ePkg.getEClassifiers().add((Object)eCls4);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls1)), this.setType((IType)this.eClassifierType((EClassifier)eCls2))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)eCls3))};
            this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testIntersectionListSetSameType() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionListSetEClassEClassifier() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(EClass.class)), this.setType((IType)this.classType(EClassifier.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(EClass.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionListSetEClassifierEClass() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(EClassifier.class)), this.setType((IType)this.classType(EClass.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(EClass.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionSetListNothingLeft() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)eCls1)), this.sequenceType((IType)this.eClassifierType((EClassifier)eCls2))};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.nothingType("Nothing left after intersection of Set(EClassifier=eCls1) and Sequence(EClassifier=eCls2)"))};
            IType[] expectedAllReturnTypes = new IType[]{this.setType((IType)this.nothingType("Nothing left after intersection:\n Nothing left after intersection of Set(EClassifier=eCls1) and Sequence(EClassifier=eCls2)"))};
            this.assertValidation(expectedReturnTypes, expectedAllReturnTypes, "intersection", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testIntersectionSetListTopSubType() {
        EPackage ePkg = EcorePackage.eINSTANCE.getEcoreFactory().createEPackage();
        ePkg.setName("ePkg");
        ePkg.setNsPrefix("ePkg");
        EClass eCls1 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls1.setName("eCls1");
        ePkg.getEClassifiers().add((Object)eCls1);
        EClass eCls2 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls2.setName("eCls2");
        ePkg.getEClassifiers().add((Object)eCls2);
        EClass eCls3 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls3.setName("eCls3");
        eCls3.getESuperTypes().add((Object)eCls1);
        eCls3.getESuperTypes().add((Object)eCls2);
        ePkg.getEClassifiers().add((Object)eCls3);
        EClass eCls4 = EcorePackage.eINSTANCE.getEcoreFactory().createEClass();
        eCls4.setName("eCls4");
        eCls4.getESuperTypes().add((Object)eCls1);
        eCls4.getESuperTypes().add((Object)eCls2);
        eCls4.getESuperTypes().add((Object)eCls3);
        ePkg.getEClassifiers().add((Object)eCls4);
        try {
            this.getQueryEnvironment().registerEPackage(ePkg);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)eCls1)), this.sequenceType((IType)this.eClassifierType((EClassifier)eCls2))};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)eCls3))};
            this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage(ePkg);
        }
    }

    @Test
    public void testIntersectionSetListSameType() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionSetListEClassEClassifier() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(EClass.class)), this.sequenceType((IType)this.classType(EClassifier.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(EClass.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIntersectionSetListEClassifierEClass() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(EClassifier.class)), this.sequenceType((IType)this.classType(EClass.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(EClass.class))};
        this.assertValidation(expectedReturnTypes, "intersection", parameterTypes);
    }

    @Test
    public void testIsEmptyList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "isEmpty", parameterTypes);
    }

    @Test
    public void testIsEmptySet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "isEmpty", parameterTypes);
    }

    @Test
    public void testIsUniqueSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Object.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "isUnique", parameterTypes);
    }

    @Test
    public void testIsUniqueList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Object.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "isUnique", parameterTypes);
    }

    @Test
    public void testLast() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(String.class)};
        this.assertValidation(expectedReturnTypes, "last", parameterTypes);
    }

    @Test
    public void testNotEmptyList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "notEmpty", parameterTypes);
    }

    @Test
    public void testNotEmptySet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
        this.assertValidation(expectedReturnTypes, "notEmpty", parameterTypes);
    }

    @Test
    public void testOneNoBooleanLambda() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.nothingType("expression in one must return a boolean")};
        this.assertValidation(expectedReturnTypes, "one", parameterTypes);
    }

    @Test
    public void testOneSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject()))};
            IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
            this.assertValidation(expectedReturnTypes, "one", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testOneList() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBooleanObject()))};
            IType[] expectedReturnTypes = new IType[]{this.classType(Boolean.class)};
            this.assertValidation(expectedReturnTypes, "one", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testAppend() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "append", parameterTypes);
    }

    @Test
    public void testPrepend() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "prepend", parameterTypes);
    }

    @Test
    public void testRejectNoBooleanLambda() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("expression in a reject must return a boolean"))};
        this.assertValidation(expectedReturnTypes, "reject", parameterTypes);
    }

    @Test
    public void testRejectSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBoolean()))};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
            this.assertValidation(expectedReturnTypes, "reject", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testRejectList() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBoolean()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
            this.assertValidation(expectedReturnTypes, "reject", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSelectNoBooleanLambda() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.nothingType("expression in a select must return a boolean"))};
        this.assertValidation(expectedReturnTypes, "select", parameterTypes);
    }

    @Test
    public void testSelectSet() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBoolean()))};
            IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
            this.assertValidation(expectedReturnTypes, "select", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSelectList() {
        try {
            this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
            IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.lambdaType("i", (IType)this.classType(String.class), (IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEBoolean()))};
            IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
            this.assertValidation(expectedReturnTypes, "select", parameterTypes);
        }
        finally {
            this.getQueryEnvironment().removeEPackage((EPackage)EcorePackage.eINSTANCE);
        }
    }

    @Test
    public void testSep2List() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "sep", parameterTypes);
    }

    @Test
    public void testSep2Set() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "sep", parameterTypes);
    }

    @Test
    public void testSep4List() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class), this.classType(String.class), this.classType(Double.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class)), this.sequenceType((IType)this.classType(Double.class))};
        this.assertValidation(expectedReturnTypes, "sep", parameterTypes);
    }

    @Test
    public void testSep4Set() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class), this.classType(String.class), this.classType(Double.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class)), this.sequenceType((IType)this.classType(Double.class))};
        this.assertValidation(expectedReturnTypes, "sep", parameterTypes);
    }

    @Test
    public void testSizeList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "size", parameterTypes);
    }

    @Test
    public void testSizeSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "size", parameterTypes);
    }

    @Test
    public void testSubList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "sub", parameterTypes);
    }

    @Test
    public void testSubSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "sub", parameterTypes);
    }

    @Test
    public void testSubOrderedSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "subOrderedSet", parameterTypes);
    }

    @Test
    public void testSubSequence() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "subSequence", parameterTypes);
    }

    @Test
    public void testDropOrderedSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "drop", parameterTypes);
    }

    @Test
    public void testDropSequence() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "drop", parameterTypes);
    }

    @Test
    public void testDropRightOrderedSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "dropRight", parameterTypes);
    }

    @Test
    public void testDropRightSequence() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.classType(Integer.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "dropRight", parameterTypes);
    }

    @Test
    public void testSumListInt() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Long.class)};
        this.assertValidation(expectedReturnTypes, "sum", parameterTypes);
    }

    @Test
    public void testSumListReal() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(Double.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Double.class)};
        this.assertValidation(expectedReturnTypes, "sum", parameterTypes);
    }

    @Test
    public void testSumListNotNumber() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.nothingType("sum can only be used on a collection of numbers.")};
        this.assertValidation(expectedReturnTypes, "sum", parameterTypes);
    }

    @Test
    public void testSumSetInt() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Long.class)};
        this.assertValidation(expectedReturnTypes, "sum", parameterTypes);
    }

    @Test
    public void testSumSetReal() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(Double.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Double.class)};
        this.assertValidation(expectedReturnTypes, "sum", parameterTypes);
    }

    @Test
    public void testSumSetNotNumber() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.nothingType("sum can only be used on a collection of numbers.")};
        this.assertValidation(expectedReturnTypes, "sum", parameterTypes);
    }

    @Test
    public void testMinListInt() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Long.class)};
        this.assertValidation(expectedReturnTypes, "min", parameterTypes);
    }

    @Test
    public void testMinListReal() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(Double.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Double.class)};
        this.assertValidation(expectedReturnTypes, "min", parameterTypes);
    }

    @Test
    public void testMinListNotNumber() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.nothingType("min can only be used on a collection of numbers.")};
        this.assertValidation(expectedReturnTypes, "min", parameterTypes);
    }

    @Test
    public void testMinSetInt() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Long.class)};
        this.assertValidation(expectedReturnTypes, "min", parameterTypes);
    }

    @Test
    public void testMinSetReal() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(Double.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Double.class)};
        this.assertValidation(expectedReturnTypes, "min", parameterTypes);
    }

    @Test
    public void testMinSetNotNumber() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.nothingType("min can only be used on a collection of numbers.")};
        this.assertValidation(expectedReturnTypes, "min", parameterTypes);
    }

    @Test
    public void testMaxListInt() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Long.class)};
        this.assertValidation(expectedReturnTypes, "max", parameterTypes);
    }

    @Test
    public void testMaxListReal() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(Double.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Double.class)};
        this.assertValidation(expectedReturnTypes, "max", parameterTypes);
    }

    @Test
    public void testMaxListNotNumber() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.nothingType("max can only be used on a collection of numbers.")};
        this.assertValidation(expectedReturnTypes, "max", parameterTypes);
    }

    @Test
    public void testMaxSetInt() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Long.class)};
        this.assertValidation(expectedReturnTypes, "max", parameterTypes);
    }

    @Test
    public void testMaxSetReal() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(Double.class))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Double.class)};
        this.assertValidation(expectedReturnTypes, "max", parameterTypes);
    }

    @Test
    public void testMaxSetNotNumber() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        IType[] expectedReturnTypes = new IType[]{this.nothingType("max can only be used on a collection of numbers.")};
        this.assertValidation(expectedReturnTypes, "max", parameterTypes);
    }

    @Test
    public void testUnionList() {
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class)), this.sequenceType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "union", parameterTypes);
    }

    @Test
    public void testUnionSet() {
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)this.classType(Integer.class))};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class)), this.setType((IType)this.classType(Integer.class))};
        this.assertValidation(expectedReturnTypes, "union", parameterTypes);
    }

    @Test
    public void testFilterListClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.classLiteralType(String.class)};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterListEClassifier() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterSetClass() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.classLiteralType(String.class)};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.classType(String.class))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterSetEClassifier() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEClass())};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterListEClassifierSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEClass(), EcorePackage.eINSTANCE.getEDataType()})};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEDataType()))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterSetEClassifierSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClassifier())), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEClass(), EcorePackage.eINSTANCE.getEDataType()})};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEDataType()))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterListEInt() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.classType(Integer.class)), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEInt())};
        IType[] expectedReturnTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt()))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterSetEInt() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.classType(Integer.class)), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEInt())};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEInt()))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterSetIncompatibleTypes() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.eClassifierLiteralType((EClassifier)EcorePackage.eINSTANCE.getEPackage())};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testFilterSetCompatibleAndIncompatibleTypes() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.eClassifierSetLiteralType(new EClassifier[]{EcorePackage.eINSTANCE.getEClass(), EcorePackage.eINSTANCE.getEPackage()})};
        IType[] expectedReturnTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEPackage()))};
        this.assertValidation(expectedReturnTypes, "filter", parameterTypes);
    }

    @Test
    public void testIndexOfSliceListList() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "indexOfSlice", parameterTypes);
    }

    @Test
    public void testIndexOfSliceSetList() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "indexOfSlice", parameterTypes);
    }

    @Test
    public void testIndexOfSliceListSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "indexOfSlice", parameterTypes);
    }

    @Test
    public void testIndexOfSliceSetSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "indexOfSlice", parameterTypes);
    }

    @Test
    public void testlastIndexOfSliceListList() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "lastIndexOfSlice", parameterTypes);
    }

    @Test
    public void testlastIndexOfSliceSetList() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "lastIndexOfSlice", parameterTypes);
    }

    @Test
    public void testlastIndexOfSliceListSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.sequenceType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "lastIndexOfSlice", parameterTypes);
    }

    @Test
    public void testlastIndexOfSliceSetSet() {
        this.getQueryEnvironment().registerEPackage((EPackage)EcorePackage.eINSTANCE);
        IType[] parameterTypes = new IType[]{this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass())), this.setType((IType)this.eClassifierType((EClassifier)EcorePackage.eINSTANCE.getEClass()))};
        IType[] expectedReturnTypes = new IType[]{this.classType(Integer.class)};
        this.assertValidation(expectedReturnTypes, "lastIndexOfSlice", parameterTypes);
    }
}

