/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser.tests;

import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.parser.AstSerializer;
import org.eclipse.acceleo.query.runtime.impl.QueryBuilderEngine;
import org.junit.Assert;
import org.junit.Test;

public class AstSerializerSimplifiedTests {
    private static final QueryBuilderEngine ENGINE = new QueryBuilderEngine();
    private static final AstSerializer SERIALIZER = new AstSerializer();

    @Test
    public void uselessSpaces() {
        Expression ast = ENGINE.build("  a   +   b  ").getAst();
        Assert.assertEquals((Object)"a + b", (Object)SERIALIZER.serialize(ast));
    }

    @Test
    public void uselessParenthesis() {
        Expression ast = ENGINE.build("(a)").getAst();
        Assert.assertEquals((Object)"a", (Object)SERIALIZER.serialize(ast));
    }

    @Test
    public void uselessParenthesisPrecedence() {
        Expression ast = ENGINE.build("a + (b * c)").getAst();
        Assert.assertEquals((Object)"a + b * c", (Object)SERIALIZER.serialize(ast));
    }

    @Test
    public void uselessUnderscoreFeatureAccess() {
        Expression ast = ENGINE.build("self._someFeature").getAst();
        Assert.assertEquals((Object)"self.someFeature", (Object)SERIALIZER.serialize(ast));
    }

    @Test
    public void uselessUnderscoreserviceCall() {
        Expression ast = ENGINE.build("self._someService()").getAst();
        Assert.assertEquals((Object)"self.someService()", (Object)SERIALIZER.serialize(ast));
    }

    @Test
    public void javaStyleDifferent() {
        Expression ast = ENGINE.build("a != b").getAst();
        Assert.assertEquals((Object)"a <> b", (Object)SERIALIZER.serialize(ast));
    }

    @Test
    public void javaStyleEquals() {
        Expression ast = ENGINE.build("a == b").getAst();
        Assert.assertEquals((Object)"a = b", (Object)SERIALIZER.serialize(ast));
    }
}

