/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.namespace.workspace;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspace;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;

public abstract class QueryWorkspace<P>
implements IQueryWorkspace<P> {
    private final String name;
    private final Map<P, IQueryWorkspaceQualifiedNameResolver> projectToResolver = new LinkedHashMap<P, IQueryWorkspaceQualifiedNameResolver>();
    private final Map<IQueryWorkspaceQualifiedNameResolver, P> resolverToProject = new LinkedHashMap<IQueryWorkspaceQualifiedNameResolver, P>();

    public QueryWorkspace(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IQueryWorkspaceQualifiedNameResolver getResolver(P project) {
        return this.getOrCreateResolver(project);
    }

    protected IQueryWorkspaceQualifiedNameResolver getOrCreateResolver(P project) {
        IQueryWorkspaceQualifiedNameResolver res;
        if (this.projectToResolver.containsKey(project)) {
            res = this.projectToResolver.get(project);
        } else {
            res = this.createResolver(project);
            IQueryWorkspaceQualifiedNameResolver oldResolver = this.projectToResolver.put(project, res);
            this.resolverToProject.remove(oldResolver);
            this.resolverToProject.put(res, project);
        }
        return res;
    }

    @Override
    public void addProject(P project) {
        IQueryWorkspaceQualifiedNameResolver resolver = this.getOrCreateResolver(project);
        for (IQueryWorkspaceQualifiedNameResolver dependencyResolver : resolver.getResolversDependOn()) {
            P dependency = this.resolverToProject.get(dependencyResolver);
            Set<String> resolvedQualifiedNames = dependencyResolver.getResolvedQualifiedNames();
            Set<String> dependsOn = this.invalidate(dependency, dependencyResolver, resolvedQualifiedNames);
            this.validate(dependency, (IQualifiedNameResolver)dependencyResolver, dependsOn);
        }
    }

    @Override
    public void removeProject(P project) {
        IQueryWorkspaceQualifiedNameResolver resolver = this.projectToResolver.remove(project);
        this.resolverToProject.remove(resolver);
        for (IQueryWorkspaceQualifiedNameResolver dependencyResolver : resolver.getResolversDependOn()) {
            P dependency = this.resolverToProject.get(dependencyResolver);
            this.clearQualifiedNames(dependency, dependencyResolver, resolver.getResolvedQualifiedNames());
        }
    }

    @Override
    public String addResource(P project, URI resource) {
        IQueryWorkspaceQualifiedNameResolver resolver = this.getResolver(project);
        String qualifiedName = resolver.getQualifiedName(resource);
        if (qualifiedName != null) {
            resolver.clear(Collections.singleton(qualifiedName));
            this.validate(project, (IQualifiedNameResolver)resolver, qualifiedName);
            Set<String> qualifiedNames = Collections.singleton(qualifiedName);
            LinkedHashSet<P> projectsToUpdate = new LinkedHashSet<P>();
            projectsToUpdate.add(project);
            for (IQueryWorkspaceQualifiedNameResolver dependencyResolver : resolver.getResolversDependOn()) {
                projectsToUpdate.add(this.resolverToProject.get(dependencyResolver));
            }
            for (Object projectToUpdate : projectsToUpdate) {
                Set<String> dependsOn = this.invalidate(projectToUpdate, this.getResolver(projectToUpdate), qualifiedNames);
                this.validate(projectToUpdate, (IQualifiedNameResolver)this.getResolver(projectToUpdate), dependsOn);
            }
        }
        return qualifiedName;
    }

    @Override
    public String removeResource(P project, URI resource) {
        IQueryWorkspaceQualifiedNameResolver resolver = this.getResolver(project);
        String qualifiedName = resolver.getQualifiedName(resource);
        if (qualifiedName != null && resolver.getResolvedQualifiedNames().contains(qualifiedName)) {
            Object resolved = resolver.resolve(qualifiedName);
            LinkedHashSet<String> qualifiedNames = new LinkedHashSet<String>();
            qualifiedNames.add(qualifiedName);
            if (this.needNewResolverOnChange(resolved)) {
                qualifiedNames.addAll(resolver.getResolvedQualifiedNames());
                this.replaceResolver(project, resolver);
            }
            this.propagateChanges(project, qualifiedNames);
        }
        return qualifiedName;
    }

    public void propagateChanges(P project, Set<String> qualifiedNames) {
        LinkedHashSet<P> projectsToUpdate = new LinkedHashSet<P>();
        projectsToUpdate.add(project);
        for (IQueryWorkspaceQualifiedNameResolver dependencyResolver : this.getResolver(project).getResolversDependOn()) {
            projectsToUpdate.add(this.resolverToProject.get(dependencyResolver));
        }
        for (Object projectToUpdate : projectsToUpdate) {
            this.clearQualifiedNames(projectToUpdate, this.getResolver(projectToUpdate), qualifiedNames);
        }
    }

    public void registerAndPropagateChanges(P project, String qualifiedName, Object newResolved) {
        LinkedHashSet<P> projectsToUpdate = new LinkedHashSet<P>();
        projectsToUpdate.add(project);
        for (IQueryWorkspaceQualifiedNameResolver dependencyResolver : this.getResolver(project).getResolversDependOn()) {
            projectsToUpdate.add(this.resolverToProject.get(dependencyResolver));
        }
        Set<String> qualifiedNames = Collections.singleton(qualifiedName);
        for (Object projectToUpdate : projectsToUpdate) {
            IQueryWorkspaceQualifiedNameResolver resolverToUpdate = this.getResolver(projectToUpdate);
            this.clearQualifiedNames(projectToUpdate, resolverToUpdate, qualifiedNames);
            Set<String> dependsOn = this.invalidate(project, resolverToUpdate, qualifiedNames);
            resolverToUpdate.clear(qualifiedNames);
            if (projectToUpdate == project) {
                resolverToUpdate.register(qualifiedName, newResolved);
            }
            for (String dependent : dependsOn) {
                resolverToUpdate.resolve(dependent);
            }
            this.validate(projectToUpdate, (IQualifiedNameResolver)resolverToUpdate, dependsOn);
        }
    }

    @Override
    public String moveResource(P sourceProject, URI sourceResource, P targetProject, URI targetResource) {
        IQueryWorkspaceQualifiedNameResolver targetResolver;
        String targetQualifiedName;
        LinkedHashSet<P> projectsToUpdate;
        IQueryWorkspaceQualifiedNameResolver sourceResolver = this.getResolver(sourceProject);
        String sourceQualifiedName = sourceResolver.getQualifiedName(sourceResource);
        LinkedHashMap<Object, Set> dependsOn = new LinkedHashMap<Object, Set>();
        if (sourceQualifiedName != null && sourceResolver.getResolvedQualifiedNames().contains(sourceQualifiedName)) {
            Object resolved = sourceResolver.resolve(sourceQualifiedName);
            LinkedHashSet<String> qualifiedNames = new LinkedHashSet<String>();
            qualifiedNames.add(sourceQualifiedName);
            if (this.needNewResolverOnChange(resolved)) {
                qualifiedNames.addAll(sourceResolver.getResolvedQualifiedNames());
                this.replaceResolver(sourceProject, sourceResolver);
            }
            projectsToUpdate = new LinkedHashSet();
            projectsToUpdate.add(sourceProject);
            for (IQueryWorkspaceQualifiedNameResolver dependencyResolver : this.getResolver(sourceProject).getResolversDependOn()) {
                projectsToUpdate.add(this.resolverToProject.get(dependencyResolver));
            }
            for (Object projectToUpdate : projectsToUpdate) {
                dependsOn.put(projectToUpdate, this.invalidate(projectToUpdate, this.getResolver(projectToUpdate), qualifiedNames));
                sourceResolver.clear(qualifiedNames);
            }
        }
        if ((targetQualifiedName = (targetResolver = this.getResolver(targetProject)).getQualifiedName(targetResource)) != null) {
            targetResolver.clear(Collections.singleton(targetQualifiedName));
            this.validate(targetProject, (IQualifiedNameResolver)targetResolver, targetQualifiedName);
            projectsToUpdate = new LinkedHashSet<P>();
            projectsToUpdate.add(targetProject);
            for (IQueryWorkspaceQualifiedNameResolver dependencyResolver : this.getResolver(targetProject).getResolversDependOn()) {
                projectsToUpdate.add(this.resolverToProject.get(dependencyResolver));
            }
            Set<String> qualifiedNames = Collections.singleton(targetQualifiedName);
            for (Object projectToUpdate : projectsToUpdate) {
                Set dependsOnForProject = dependsOn.computeIfAbsent(targetProject, p -> new LinkedHashSet());
                dependsOnForProject.addAll(this.invalidate(projectToUpdate, this.getResolver(projectToUpdate), qualifiedNames));
            }
        }
        for (Map.Entry entry : dependsOn.entrySet()) {
            this.validate(entry.getKey(), (IQualifiedNameResolver)this.getResolver(entry.getKey()), (Set)entry.getValue());
        }
        return targetQualifiedName;
    }

    @Override
    public String changeResource(P project, URI resource) {
        IQueryWorkspaceQualifiedNameResolver resolver = this.getResolver(project);
        String qualifiedName = resolver.getQualifiedName(resource);
        if (qualifiedName != null && resolver.getResolvedQualifiedNames().contains(qualifiedName)) {
            Object resolved = resolver.resolve(qualifiedName);
            LinkedHashSet<String> qualifiedNames = new LinkedHashSet<String>();
            qualifiedNames.add(qualifiedName);
            if (this.needNewResolverOnChange(resolved)) {
                qualifiedNames.addAll(resolver.getResolvedQualifiedNames());
                this.replaceResolver(project, resolver);
            }
            this.updateResourceContents(project, this.getResolver(project), resource);
            this.validate(project, (IQualifiedNameResolver)resolver, qualifiedName);
            this.propagateChanges(project, qualifiedNames);
        }
        return qualifiedName;
    }

    protected abstract void updateResourceContents(P var1, IQualifiedNameResolver var2, URI var3);

    protected void replaceResolver(P project, IQualifiedNameResolver resolver) {
        IQueryWorkspaceQualifiedNameResolver newResolver = this.createResolver(project);
        for (String qualifiedName : resolver.getResolvedQualifiedNames()) {
            Object resolved = resolver.resolve(qualifiedName);
            if (this.needNewResolverOnChange(resolved)) {
                newResolver.resolve(qualifiedName);
                continue;
            }
            newResolver.register(qualifiedName, resolved);
        }
        IQueryWorkspaceQualifiedNameResolver oldResolver = this.projectToResolver.put(project, newResolver);
        this.resolverToProject.remove(oldResolver);
        this.resolverToProject.put(newResolver, project);
    }

    protected void clearQualifiedNames(P project, IQualifiedNameResolver resolver, Set<String> qualifiedNames) {
        Set<String> dependsOn = this.invalidate(project, resolver, qualifiedNames);
        resolver.clear(qualifiedNames);
        for (String qualifiedName : qualifiedNames) {
            resolver.resolve(qualifiedName);
        }
        this.validate(project, resolver, dependsOn);
    }

    protected Set<String> invalidate(P project, IQualifiedNameResolver resolver, Set<String> qualifiedNames) {
        IQualifiedNameLookupEngine lookupEngine;
        LinkedHashSet<String> res = new LinkedHashSet<String>();
        for (String qualifiedName : qualifiedNames) {
            res.addAll(resolver.getDependOn(qualifiedName));
            lookupEngine = this.getLookupEngine(project, resolver, qualifiedName);
            if (lookupEngine == null) continue;
            lookupEngine.clearContext(qualifiedName);
        }
        for (String qualifiedName : res) {
            lookupEngine = this.getLookupEngine(project, resolver, qualifiedName);
            if (lookupEngine == null) continue;
            lookupEngine.clearContext(qualifiedName);
        }
        return res;
    }

    protected void validate(P project, IQualifiedNameResolver resolver, Set<String> qualifiedNames) {
        for (String qualifiedName : qualifiedNames) {
            this.validate(project, resolver, qualifiedName);
        }
    }

    protected boolean needNewResolverOnChange(Object resolved) {
        return resolved instanceof Class;
    }

    protected abstract void validate(P var1, IQualifiedNameResolver var2, String var3);

    protected abstract IQualifiedNameLookupEngine getLookupEngine(P var1, IQualifiedNameResolver var2, String var3);

    protected abstract IQueryWorkspaceQualifiedNameResolver createResolver(P var1);
}

