/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.tests.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.Metamodel;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.aql.validation.AcceleoValidator;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.aql.validation.quickfixes.AcceleoQuickFixesSwitch;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.AstPackage;
import org.eclipse.acceleo.query.parser.quickfixes.IAstQuickFix;
import org.eclipse.acceleo.query.parser.quickfixes.IAstResourceChange;
import org.eclipse.acceleo.query.parser.quickfixes.IAstTextReplacement;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.impl.namespace.ClassLoaderQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.impl.namespace.JavaLoader;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.tests.utils.MemoryURIHandler;
import org.eclipse.acceleo.tests.utils.ModuleAstSerializer;
import org.eclipse.acceleo.tests.utils.ModuleLoaderWindowsEndLine;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class AbstractLanguageTestSuite {
    private static final int BUFFER_SIZE = 8192;
    public static final String UTF_8 = "UTF-8";
    public static final char DEFAULT_END_OF_LINE_CHARACTER = '\n';
    private static MemoryURIHandler uriHandler = new MemoryURIHandler();
    protected final AcceleoAstResult astResult;
    protected final AcceleoAstResult astResultWindowsEndLine;
    protected static IQualifiedNameQueryEnvironment queryEnvironment;
    protected static IQualifiedNameQueryEnvironment queryEnvironmentWindowsEndLine;
    protected static ResourceSet resourceSetForModels;
    protected final AcceleoEvaluator evaluator;
    protected final AcceleoEvaluator evaluatorWindowsEndLine;
    protected final String memoryDestinationString;
    protected final URI memoryDestination;
    private final ModuleAstSerializer moduleAstSerializer = new ModuleAstSerializer();
    private final String testFolderPath;
    private final String qualifiedName;
    private final IAcceleoValidationResult validationResult;
    private final IAcceleoValidationResult validationResultWindowsEndLine;
    private final String moduleText;
    private final String moduleTextWindowsEndLine;

    public AbstractLanguageTestSuite(String testFolder) throws IOException {
        String encoding;
        FileInputStream is;
        GenModelPackage.eINSTANCE.getName();
        AstPackage.eINSTANCE.getName();
        AcceleoPackage.eINSTANCE.getName();
        this.memoryDestinationString = "acceleotests://" + testFolder + "/";
        this.memoryDestination = URI.createURI((String)this.memoryDestinationString);
        this.testFolderPath = testFolder;
        File testFolderFile = new File(this.testFolderPath);
        File moduleFile = this.getModuleFile(testFolderFile);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            is = new FileInputStream(moduleFile);
            try {
                encoding = new AcceleoParser().parseEncoding((InputStream)is);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var6_7 = null;
        try {
            is = new FileInputStream(moduleFile);
            try {
                this.moduleText = AcceleoUtil.getContent((InputStream)is, (String)encoding);
            }
            finally {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        this.moduleTextWindowsEndLine = this.moduleText.replaceAll("\n", "\r\n");
        Path rootPath = testFolderFile.toPath().getName(0);
        URL[] urls = new URL[]{testFolderFile.toPath().getName(0).toUri().toURL()};
        URLClassLoader classLoader = new URLClassLoader(urls, this.getClass().getClassLoader());
        ClassLoaderQualifiedNameResolver resolver = new ClassLoaderQualifiedNameResolver((ClassLoader)classLoader, "::");
        ClassLoaderQualifiedNameResolver resolverWindowsEndLine = new ClassLoaderQualifiedNameResolver((ClassLoader)classLoader, "::");
        LinkedHashMap options = new LinkedHashMap();
        ArrayList exceptions = new ArrayList();
        resourceSetForModels = AQLUtils.createResourceSetForModels(exceptions, (Object)this, (ResourceSet)this.getResourceSet(), options);
        queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)resourceSetForModels, (boolean)true);
        queryEnvironmentWindowsEndLine = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolverWindowsEndLine, (ResourceSet)resourceSetForModels, (boolean)true);
        this.evaluator = new AcceleoEvaluator(queryEnvironment.getLookupEngine(), "\n");
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), this.evaluator));
        resolver.addLoader((ILoader)new JavaLoader("::", false));
        this.evaluatorWindowsEndLine = new AcceleoEvaluator(queryEnvironmentWindowsEndLine.getLookupEngine(), "\n");
        resolverWindowsEndLine.addLoader((ILoader)new ModuleLoaderWindowsEndLine(new AcceleoParser(), this.evaluatorWindowsEndLine));
        resolverWindowsEndLine.addLoader((ILoader)new JavaLoader("::", false));
        String namespace = rootPath.relativize(testFolderFile.toPath()).toString().replace(File.separator, "::") + "::";
        this.qualifiedName = namespace + moduleFile.getName().substring(0, moduleFile.getName().lastIndexOf(46));
        Object resolved = resolver.resolve(this.qualifiedName);
        this.astResult = resolved instanceof Module ? ((Module)resolved).getAst() : null;
        Object resolvedWindowsEndLine = resolverWindowsEndLine.resolve(this.qualifiedName);
        this.astResultWindowsEndLine = resolvedWindowsEndLine instanceof Module ? ((Module)resolvedWindowsEndLine).getAst() : null;
        for (Metamodel metamodel : this.astResult.getModule().getMetamodels()) {
            if (metamodel.getReferencedPackage() == null) continue;
            queryEnvironment.registerEPackage(metamodel.getReferencedPackage());
        }
        AcceleoValidator validator = new AcceleoValidator(queryEnvironment);
        this.validationResult = validator.validate(this.astResult, this.qualifiedName);
        for (Metamodel metamodel : this.astResultWindowsEndLine.getModule().getMetamodels()) {
            if (metamodel.getReferencedPackage() == null) continue;
            queryEnvironmentWindowsEndLine.registerEPackage(metamodel.getReferencedPackage());
        }
        AcceleoValidator validatorWindowsEndLine = new AcceleoValidator(queryEnvironmentWindowsEndLine);
        this.validationResultWindowsEndLine = validatorWindowsEndLine.validate(this.astResultWindowsEndLine, this.qualifiedName);
    }

    @After
    public void after() {
        uriHandler.clear();
    }

    @AfterClass
    public static void afterClass() {
        AQLUtils.cleanResourceSetForModels((Object)queryEnvironment.getLookupEngine().getResolver(), (ResourceSet)resourceSetForModels);
        AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)queryEnvironment, (ResourceSet)resourceSetForModels);
        AQLUtils.cleanResourceSetForModels((Object)queryEnvironmentWindowsEndLine.getLookupEngine().getResolver(), (ResourceSet)resourceSetForModels);
        AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)queryEnvironmentWindowsEndLine, (ResourceSet)resourceSetForModels);
    }

    protected String getTestFolderPath() {
        return this.testFolderPath;
    }

    protected ResourceSet getResourceSet() {
        ResourceSetImpl res = new ResourceSetImpl();
        res.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        res.getURIConverter().getURIHandlers().add(0, (Object)uriHandler);
        return res;
    }

    @Test
    public void parsing() throws FileNotFoundException, IOException {
        File expectedASTFile = this.getExpectedASTFile(new File(this.testFolderPath));
        String actualAst = this.moduleAstSerializer.serialize(this.astResult);
        if (!expectedASTFile.exists()) {
            File actualASTFile = this.getActualASTFile(new File(this.testFolderPath));
            if (!actualASTFile.exists()) {
                actualASTFile.createNewFile();
            }
            AbstractLanguageTestSuite.setContent(new FileOutputStream(actualASTFile), UTF_8, actualAst);
            Assert.fail((String)"file doesn't exist.");
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream stream = new FileInputStream(expectedASTFile);){
            String expectedAst = AcceleoUtil.getContent((InputStream)stream, (String)UTF_8);
            Assert.assertEquals((Object)expectedAst, (Object)actualAst);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void parsingWindowsEndLine() throws FileNotFoundException, IOException {
        File expectedASTFileWindowsEndLine = this.getExpectedASTFileWindowsEndLine(new File(this.testFolderPath));
        String actualAst = this.moduleAstSerializer.serialize(this.astResultWindowsEndLine);
        if (!expectedASTFileWindowsEndLine.exists()) {
            File actualASTFileWindowsEndLine = this.getActualASTFileWindowsEndLine(new File(this.testFolderPath));
            if (!actualASTFileWindowsEndLine.exists()) {
                actualASTFileWindowsEndLine.createNewFile();
            }
            AbstractLanguageTestSuite.setContent(new FileOutputStream(actualASTFileWindowsEndLine), UTF_8, actualAst);
            Assert.fail((String)"file doesn't exist.");
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream stream = new FileInputStream(expectedASTFileWindowsEndLine);){
            String expectedAst = AcceleoUtil.getContent((InputStream)stream, (String)UTF_8);
            Assert.assertEquals((Object)expectedAst, (Object)actualAst);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Test
    public void validation() throws FileNotFoundException, IOException {
        List messages = this.validationResult.getValidationMessages();
        String actualContent = this.getValidationContent(messages);
        File expectedFile = this.getExpectedValidationFile(new File(this.testFolderPath));
        File actualFile = this.getActualValidationFile(new File(this.testFolderPath));
        if (!expectedFile.exists()) {
            if (!actualFile.exists() && !expectedFile.exists()) {
                actualFile.createNewFile();
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream stream = new FileOutputStream(actualFile);){
                AbstractLanguageTestSuite.setContent(stream, UTF_8, actualContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)"file doesn't exist.");
        } else {
            String expectedContent = "";
            Throwable throwable = null;
            Object var7_13 = null;
            try (FileInputStream stream = new FileInputStream(expectedFile);){
                expectedContent = AcceleoUtil.getContent((InputStream)stream, (String)UTF_8);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Assert.assertEquals((Object)expectedContent, (Object)actualContent);
        }
    }

    @Test
    public void validationWindowsEndLine() throws FileNotFoundException, IOException {
        List messages = this.validationResultWindowsEndLine.getValidationMessages();
        String actualContent = this.getValidationContent(messages);
        File expectedFileWindowsEndLine = this.getExpectedValidationFileWindowsEndLine(new File(this.testFolderPath));
        File actualFileWindowsEndLine = this.getActualValidationFileWindowsEndLine(new File(this.testFolderPath));
        if (!expectedFileWindowsEndLine.exists()) {
            if (!actualFileWindowsEndLine.exists() && !expectedFileWindowsEndLine.exists()) {
                actualFileWindowsEndLine.createNewFile();
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileOutputStream stream = new FileOutputStream(actualFileWindowsEndLine);){
                AbstractLanguageTestSuite.setContent(stream, UTF_8, actualContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)"file doesn't exist.");
        } else {
            String expectedContent = "";
            Throwable throwable = null;
            Object var7_13 = null;
            try (FileInputStream stream = new FileInputStream(expectedFileWindowsEndLine);){
                expectedContent = AcceleoUtil.getContent((InputStream)stream, (String)UTF_8);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Assert.assertEquals((Object)expectedContent, (Object)actualContent);
        }
    }

    @Test
    public void quickFixes() throws FileNotFoundException, IOException {
        String actualContent = this.getQuickFixesContent(this.validationResult, "\n", this.moduleText);
        File expectedFile = this.getExpectedQuickFixesFile(new File(this.testFolderPath));
        File actualFile = this.getActualQuickFixesFile(new File(this.testFolderPath));
        if (!expectedFile.exists()) {
            if (!actualFile.exists() && !expectedFile.exists()) {
                actualFile.createNewFile();
            }
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream stream = new FileOutputStream(actualFile);){
                AbstractLanguageTestSuite.setContent(stream, UTF_8, actualContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)"file doesn't exist.");
        } else {
            String expectedContent = "";
            Throwable throwable = null;
            Object var6_12 = null;
            try (FileInputStream stream = new FileInputStream(expectedFile);){
                expectedContent = AcceleoUtil.getContent((InputStream)stream, (String)UTF_8);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Assert.assertEquals((Object)this.getPortableString(expectedContent), (Object)this.getPortableString(actualContent));
        }
    }

    @Test
    public void quickFixesWindowsEndLine() throws FileNotFoundException, IOException {
        String actualContent = this.getQuickFixesContent(this.validationResultWindowsEndLine, "\r\n", this.moduleTextWindowsEndLine).replaceAll("\r\n", "\n");
        File expectedFile = this.getExpectedQuickFixesFileWindowsEndLine(new File(this.testFolderPath));
        File actualFile = this.getActualQuickFixesFileWindowsEndLine(new File(this.testFolderPath));
        if (!expectedFile.exists()) {
            if (!actualFile.exists() && !expectedFile.exists()) {
                actualFile.createNewFile();
            }
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream stream = new FileOutputStream(actualFile);){
                AbstractLanguageTestSuite.setContent(stream, UTF_8, actualContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Assert.fail((String)"file doesn't exist.");
        } else {
            String expectedContent = "";
            Throwable throwable = null;
            Object var6_12 = null;
            try (FileInputStream stream = new FileInputStream(expectedFile);){
                expectedContent = AcceleoUtil.getContent((InputStream)stream, (String)UTF_8);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            Assert.assertEquals((Object)this.getPortableString(expectedContent), (Object)this.getPortableString(actualContent));
        }
    }

    private String getValidationContent(List<IValidationMessage> messages) {
        String res;
        if (messages.size() != 0) {
            StringBuilder builder = new StringBuilder();
            for (IValidationMessage message : messages) {
                builder.append(message.getLevel());
                builder.append(" ");
                builder.append(message.getMessage());
                builder.append(" - ");
                builder.append(message.getStartPosition());
                builder.append(" ");
                builder.append(message.getEndPosition());
                builder.append('\n');
            }
            res = builder.substring(0, builder.length() - 1);
        } else {
            res = "";
        }
        return res;
    }

    private String getQuickFixesContent(IAcceleoValidationResult result, String endLine, String text) {
        ArrayList<Object> eObjects = new ArrayList<Object>();
        Module module = result.getAcceleoAstResult().getModule();
        eObjects.add(module);
        TreeIterator it = module.eAllContents();
        while (it.hasNext()) {
            eObjects.add((EObject)it.next());
        }
        AcceleoQuickFixesSwitch quickFixesSwitch = new AcceleoQuickFixesSwitch(queryEnvironment, result, this.qualifiedName, text, endLine);
        StringBuilder builder = new StringBuilder();
        for (EObject eObject : eObjects) {
            List quickFixes = quickFixesSwitch.getQuickFixes((ASTNode)eObject);
            if (quickFixes.isEmpty()) continue;
            builder.append(eObject.eResource().getURIFragment(eObject));
            builder.append('\n');
            for (IAstQuickFix quickFix : quickFixes) {
                builder.append(quickFix.getName());
                builder.append('\n');
                for (IAstResourceChange resourceChange : quickFix.getResourceChanges()) {
                    builder.append(resourceChange.toString());
                    builder.append('\n');
                }
                for (IAstTextReplacement replacement : quickFix.getTextReplacements()) {
                    builder.append(replacement.toString());
                    builder.append('\n');
                }
            }
        }
        String res = builder.length() != 0 ? builder.substring(0, builder.length() - 1) : builder.toString();
        return res;
    }

    protected final File getModuleFile(File testFolder) {
        return AbstractLanguageTestSuite.getTemplateFileInternal(testFolder);
    }

    protected File getFragmentsFolder(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + "fragments");
    }

    protected File getExpectedASTFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-expected-ast.txt");
    }

    protected File getActualASTFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-actual-ast.txt");
    }

    protected File getExpectedASTFileWindowsEndLine(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-WindowsEndLine-expected-ast.txt");
    }

    protected File getActualASTFileWindowsEndLine(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-WindowsEndLine-actual-ast.txt");
    }

    protected File getExpectedValidationFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-expected-validation.txt");
    }

    protected File getActualValidationFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-actual-validation.txt");
    }

    protected File getExpectedValidationFileWindowsEndLine(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-WindowsEndLine-expected-validation.txt");
    }

    protected File getActualValidationFileWindowsEndLine(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-WindowsEndLine-actual-validation.txt");
    }

    protected File getExpectedQuickFixesFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-expected-quickFixes.txt");
    }

    protected File getActualQuickFixesFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-actual-quickFixes.txt");
    }

    protected File getExpectedQuickFixesFileWindowsEndLine(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-WindowsEndLine-expected-quickFixes.txt");
    }

    protected File getActualQuickFixesFileWindowsEndLine(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-WindowsEndLine-actual-quickFixes.txt");
    }

    protected File getExpectedGeneratedFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-expected-generation.txt");
    }

    protected File getActualGeneratedFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + "-actual-generation.txt");
    }

    protected File getModelFile(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + ".xmi");
    }

    private static File getTemplateFileInternal(File testFolder) {
        return new File(String.valueOf(testFolder) + File.separator + testFolder.getName() + ".mtl");
    }

    public static Collection<Object[]> retrieveTestFolders(String folderPath) {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        File folder = new File(folderPath);
        Object[] children = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                boolean res = pathname.isDirectory() && pathname.canRead() ? AbstractLanguageTestSuite.getTemplateFileInternal(pathname).exists() : false;
                return res;
            }
        });
        Arrays.sort(children);
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            parameters.add(new Object[]{((File)child).getPath()});
            ++n2;
        }
        return parameters;
    }

    public static void setContent(OutputStream stream, String charsetName, String content) throws UnsupportedEncodingException, IOException {
        String localCharsetName = charsetName != null ? charsetName : UTF_8;
        stream.write(content.getBytes(localCharsetName));
        stream.flush();
    }

    /*
     * Loose catch block
     */
    public static long copy(URIConverter uriConverter, URI sourceURI, URI destURI) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            long l;
            OutputStream dest;
            InputStream source;
            block17: {
                block16: {
                    int n;
                    source = uriConverter.createInputStream(sourceURI);
                    dest = uriConverter.createOutputStream(destURI);
                    long nread = 0L;
                    byte[] buf = new byte[8192];
                    while ((n = source.read(buf)) > 0) {
                        dest.write(buf, 0, n);
                        nread += (long)n;
                    }
                    l = nread;
                    if (dest == null) break block16;
                    dest.close();
                }
                if (source == null) break block17;
                source.close();
            }
            return l;
            {
                catch (Throwable throwable2) {
                    try {
                        if (dest != null) {
                            dest.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (source != null) {
                            source.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected String getPortableString(String textContent) {
        String res = textContent.replaceAll("/home/.*/tests", "/home/.../tests");
        res = res.replaceAll("file:/.*/tests", "file:/.../tests");
        res = res.replaceAll("Aucun fichier ou dossier de ce type", "No such file or directory");
        res = res.replaceAll("20[^ ]* [^ ]* - Lost", "20...date and time... - Lost");
        res = res.replaceAll("@[a-f0-9]{4,8}[, )]", "@00000000 ");
        res = res.replaceAll("(\\tat [a-zA-Z0-9$./]+((<|&lt;)init(>|&gt;))?\\((Unknown Source|Native Method|[a-zA-Z0-9$./]+java:[0-9]+)\\)\n?)+", "...STACK...");
        res = res.replaceAll("127.0.0.100:12.345", "127.0.0.100:12 345");
        res = res.replaceAll("127.0.0.100:12,345", "127.0.0.100:12 345");
        return res;
    }
}

