/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.sirius.tests.services.configurator;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.query.sirius.services.configurator.SiriusResourceSetConfigurator;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.junit.Assert;
import org.junit.Test;

public class SiriusResourceSetConfiguratorTests {
    @Test(expected=IllegalArgumentException.class)
    public void createResourceSetForModelsWrongAirdURI() throws IOException {
        SiriusResourceSetConfigurator configurator = new SiriusResourceSetConfigurator();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        String currentPath = new File("resources/NotExisting.aird").getCanonicalPath();
        options.put("BaseURI", URI.createFileURI((String)currentPath).toString());
        options.put("SiriusSession", "NotExisting.aird");
        ResourceSet rs = configurator.createResourceSetForModels((Object)this, options);
        configurator.cleanResourceSetForModels((Object)this);
    }

    @Test
    public void validateWrongAirdURI() throws IOException {
        SiriusResourceSetConfigurator configurator = new SiriusResourceSetConfigurator();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        String currentPath = new File("resources/NotExisting.aird").getCanonicalPath();
        options.put("BaseURI", URI.createFileURI((String)currentPath).toString());
        options.put("SiriusSession", "NotExisting.aird");
        Map diagnostics = configurator.validate(null, options);
        Assert.assertEquals((long)1L, (long)diagnostics.size());
        List list = (List)diagnostics.get("SiriusSession");
        Assert.assertEquals((Object)true, (Object)(list != null ? 1 : 0));
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)true, (Object)((Diagnostic)list.get(0)).getMessage().contains("The Sirius session doesn't exist"));
        Assert.assertEquals((Object)true, (Object)((Diagnostic)list.get(0)).getMessage().contains("NotExisting.aird"));
    }

    @Test
    public void validate() throws IOException {
        SiriusResourceSetConfigurator configurator = new SiriusResourceSetConfigurator();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        String currentPath = new File("resources/representations.aird").getCanonicalPath();
        options.put("BaseURI", URI.createFileURI((String)currentPath).toString());
        options.put("SiriusSession", "representations.aird");
        Map diagnostics = configurator.validate(null, options);
        Assert.assertEquals((long)0L, (long)diagnostics.size());
    }
}

