/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Error;
import org.eclipse.acceleo.query.parser.CombineIterator;
import org.eclipse.acceleo.query.runtime.AcceleoQueryValidationException;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractLanguageServices;
import org.eclipse.acceleo.query.runtime.impl.ServicesValidationResult;
import org.eclipse.acceleo.query.validation.type.ClassLiteralType;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;

public class ValidationServices
extends AbstractLanguageServices {
    public static final String INTERNAL_ERROR_MSG = "An internal error occured during validation of a query";
    private static final String VARIABLE_HAS_NO_TYPES = "The %s variable has no types";
    private static final String SHOULD_NEVER_HAPPEN = "should never happen";

    public ValidationServices(IReadOnlyQueryEnvironment queryEnv) {
        super(queryEnv);
    }

    public NothingType nothing(String message, Object ... msgArgs) {
        String formatedMessage = String.format(message, msgArgs);
        return new NothingType(formatedMessage);
    }

    public Set<IType> getVariableTypes(Map<String, Set<IType>> variableTypes, String variableName) {
        try {
            LinkedHashSet<IType> res = new LinkedHashSet<IType>();
            Set<IType> types = variableTypes.get(variableName);
            if (types != null) {
                if (types.size() > 0) {
                    res.addAll(types);
                } else {
                    res.add(this.nothing(VARIABLE_HAS_NO_TYPES, variableName));
                }
            } else {
                res.add(this.nothing("Couldn't find the '%s' variable", variableName));
            }
            return res;
        }
        catch (NullPointerException e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public ServicesValidationResult call(Call call, IValidationResult validationResult, List<Set<IType>> argTypes) {
        ServicesValidationResult servicesValidationResult;
        String serviceName = call.getServiceName();
        switch (call.getType()) {
            case CALLSERVICE: {
                servicesValidationResult = this.callType(call, validationResult, serviceName, argTypes);
                break;
            }
            case CALLORAPPLY: {
                servicesValidationResult = this.callOrApplyTypes(call, validationResult, serviceName, argTypes);
                break;
            }
            case COLLECTIONCALL: {
                servicesValidationResult = this.collectionServiceCallTypes(call, validationResult, serviceName, argTypes);
                break;
            }
            default: {
                throw new UnsupportedOperationException(SHOULD_NEVER_HAPPEN);
            }
        }
        return servicesValidationResult;
    }

    public ServicesValidationResult callType(Call call, IValidationResult validationResult, String serviceName, List<Set<IType>> argTypes) {
        if (argTypes.size() == 0) {
            throw new AcceleoQueryValidationException("An internal error occured during validation of a query : at least one argument must be specified for service " + serviceName + ".");
        }
        try {
            ServicesValidationResult result = new ServicesValidationResult(this.queryEnvironment, this);
            CombineIterator it = new CombineIterator(argTypes);
            LinkedHashMap typesPerService = new LinkedHashMap();
            boolean serviceFound = false;
            boolean emptyCombination = !it.hasNext();
            ArrayList<String> notFoundSignatures = new ArrayList<String>();
            while (it.hasNext()) {
                Object currentArgTypes = it.next();
                IService<?> service = this.queryEnvironment.getLookupEngine().lookup(serviceName, currentArgTypes.toArray(new IType[currentArgTypes.size()]));
                if (service != null) {
                    LinkedHashMap<Object, Set<IType>> typeMapping = (LinkedHashMap<Object, Set<IType>>)typesPerService.get(service);
                    if (typeMapping == null) {
                        typeMapping = new LinkedHashMap<Object, Set<IType>>();
                        typesPerService.put(service, typeMapping);
                    }
                    Set<IType> serviceTypes = service.getType(call, this, validationResult, this.queryEnvironment, (List<IType>)currentArgTypes);
                    typeMapping.put(currentArgTypes, serviceTypes);
                    serviceFound = true;
                    continue;
                }
                notFoundSignatures.add(this.serviceSignature(serviceName, (List<IType>)currentArgTypes));
            }
            if (!emptyCombination) {
                if (serviceFound) {
                    for (Map.Entry entry : typesPerService.entrySet()) {
                        IService service = (IService)entry.getKey();
                        Map types = (Map)entry.getValue();
                        result.addServiceTypes(service, types);
                    }
                } else {
                    StringBuilder builder = new StringBuilder();
                    for (String signature : notFoundSignatures) {
                        builder.append(String.valueOf(String.format("Couldn't find the '%s' service", signature)) + "\n");
                    }
                    result.addServiceNotFound(this.nothing(builder.substring(0, builder.length() - 1), new Object[0]));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    public ServicesValidationResult callOrApplyTypes(Call call, IValidationResult validationResult, String serviceName, List<Set<IType>> argTypes) {
        try {
            ServicesValidationResult result = new ServicesValidationResult(this.queryEnvironment, this);
            ArrayList<Set<IType>> argTypesNoReceiver = new ArrayList<Set<IType>>(argTypes);
            Set receiverTypes = (Set)argTypesNoReceiver.remove(0);
            for (IType receiverType : receiverTypes) {
                if (receiverType instanceof SequenceType) {
                    result.merge(this.validateCallOnSequence(call, validationResult, serviceName, (SequenceType)receiverType, argTypesNoReceiver));
                    continue;
                }
                if (receiverType instanceof SetType) {
                    result.merge(this.validateCallOnSet(call, validationResult, serviceName, (SetType)receiverType, argTypesNoReceiver));
                    continue;
                }
                ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
                LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
                newReceiverTypes.add(receiverType);
                newArgTypes.add(0, newReceiverTypes);
                result.merge(this.callType(call, validationResult, serviceName, newArgTypes));
            }
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    private ServicesValidationResult validateCallOnSequence(Call call, IValidationResult validationResult, String serviceName, SequenceType receiverType, List<Set<IType>> argTypesNoReceiver) {
        try {
            ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            newReceiverTypes.add(receiverType.getCollectionType());
            newArgTypes.add(0, newReceiverTypes);
            ServicesValidationResult result = this.callOrApplyTypes(call, validationResult, serviceName, newArgTypes);
            this.flattenSequence(result);
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException("empty argument array passed to callOrApply " + serviceName, e);
        }
    }

    protected void flattenSequence(ServicesValidationResult result) {
        result.flattenSequence();
    }

    private ServicesValidationResult validateCallOnSet(Call call, IValidationResult validationResult, String serviceName, SetType receiverType, List<Set<IType>> argTypesNoReceiver) {
        try {
            ArrayList<Set<IType>> newArgTypes = new ArrayList<Set<IType>>(argTypesNoReceiver);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            newReceiverTypes.add(receiverType.getCollectionType());
            newArgTypes.add(0, newReceiverTypes);
            ServicesValidationResult result = this.callOrApplyTypes(call, validationResult, serviceName, newArgTypes);
            this.flattenSet(result);
            return result;
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException("empty argument array passed to callOrApply " + serviceName, e);
        }
    }

    protected void flattenSet(ServicesValidationResult result) {
        result.flattenSet();
    }

    public ServicesValidationResult collectionServiceCallTypes(Call call, IValidationResult validationResult, String serviceName, List<Set<IType>> argTypes) {
        ArrayList<Set<IType>> newArguments = new ArrayList<Set<IType>>(argTypes);
        try {
            Set receiverTypes = (Set)newArguments.remove(0);
            LinkedHashSet<IType> newReceiverTypes = new LinkedHashSet<IType>();
            for (IType receiverType : receiverTypes) {
                if (receiverType instanceof ClassType && receiverType.getType() == null) {
                    newReceiverTypes.add(new SetType(this.queryEnvironment, this.nothing("The Collection was empty due to a null value being wrapped as a Collection.", new Object[0])));
                    continue;
                }
                if (!(receiverType instanceof ICollectionType) && !(receiverType instanceof NothingType)) {
                    newReceiverTypes.add(new SetType(this.queryEnvironment, receiverType));
                    continue;
                }
                newReceiverTypes.add(receiverType);
            }
            newArguments.add(0, newReceiverTypes);
            return this.callType(call, validationResult, serviceName, newArguments);
        }
        catch (Exception e) {
            throw new AcceleoQueryValidationException(INTERNAL_ERROR_MSG, e);
        }
    }

    protected String serviceSignature(String serviceName, List<IType> argumentTypes) {
        StringBuilder builder = new StringBuilder();
        builder.append(serviceName).append('(');
        boolean first = true;
        for (IType argType : argumentTypes) {
            if (!first) {
                builder.append(',');
            } else {
                first = false;
            }
            builder.append(argType.toString());
        }
        return builder.append(')').toString();
    }

    public Set<IType> getErrorTypes(IValidationResult validationResult, Error error) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        for (Diagnostic diagnostic : validationResult.getAstResult().getDiagnostic().getChildren()) {
            if (!diagnostic.getData().contains(error)) continue;
            result.add(this.nothing(diagnostic.getMessage(), new Object[0]));
        }
        return result;
    }

    public IType lower(IType type1, IType type2) {
        IType result = type1 == null || type2 == null ? null : (type1.isAssignableFrom(type2) || type1.getType() == EcorePackage.eINSTANCE.getEObject() || type1.getType() == EObject.class ? (type2 instanceof EClassifierLiteralType ? new EClassifierType(this.queryEnvironment, ((EClassifierLiteralType)type2).getType()) : (type2 instanceof ClassLiteralType ? new ClassType(this.queryEnvironment, (Class<?>)((ClassLiteralType)type2).getType()) : type2)) : (type2.isAssignableFrom(type1) || type2.getType() == EcorePackage.eINSTANCE.getEObject() || type2.getType() == EObject.class ? (type1 instanceof EClassifierLiteralType ? new EClassifierType(this.queryEnvironment, ((EClassifierLiteralType)type1).getType()) : (type1 instanceof ClassLiteralType ? new ClassType(this.queryEnvironment, (Class<?>)((ClassLiteralType)type1).getType()) : type1)) : null));
        return result;
    }

    public Set<EClass> getSubTypesTopIntersection(EClass eCls1, EClass eCls2) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        Set<EClass> subTypes1 = this.queryEnvironment.getEPackageProvider().getAllSubTypes(eCls1);
        Set<EClass> subTypes2 = this.queryEnvironment.getEPackageProvider().getAllSubTypes(eCls2);
        LinkedHashSet<EClass> intersection = new LinkedHashSet<EClass>(subTypes1);
        intersection.retainAll(subTypes2);
        for (EClass eCls : intersection) {
            boolean isTopEClass = Collections.disjoint(eCls.getEAllSuperTypes(), intersection);
            if (!isTopEClass) continue;
            result.add(eCls);
        }
        return result;
    }

    public Set<IType> intersection(IType type1, IType type2) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        IType lowerType = this.lower(type1, type2);
        if (lowerType != null) {
            result.add(lowerType);
        } else if (type1 != null && type2 != null) {
            Set<EClass> eClasses1 = this.getEClasses(type1);
            Set<EClass> eClasses2 = this.getEClasses(type2);
            for (EClass eCls1 : eClasses1) {
                for (EClass eCls2 : eClasses2) {
                    for (EClass eCls : this.getSubTypesTopIntersection(eCls1, eCls2)) {
                        result.add(new EClassifierType(this.getQueryEnvironment(), (EClassifier)eCls));
                    }
                }
            }
        }
        return result;
    }

    public Set<EClass> getEClasses(IType type) {
        Set<EClassifier> eClassifiers;
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        if (type.getType() instanceof EClass) {
            result.add((EClass)type.getType());
        } else if (type.getType() instanceof Class && (eClassifiers = this.queryEnvironment.getEPackageProvider().getEClassifiers((Class)type.getType())) != null) {
            for (EClassifier eClassifier : eClassifiers) {
                if (!(eClassifier instanceof EClass)) continue;
                result.add((EClass)eClassifier);
            }
        }
        return result;
    }
}

