/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.Comment;
import org.eclipse.acceleo.Documentation;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.migration.IModuleResolver;
import org.eclipse.acceleo.aql.migration.converters.ModuleConverter;
import org.eclipse.acceleo.aql.migration.parser.DocumentationParser;
import org.eclipse.acceleo.common.utils.ModelUtils;
import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.acceleo.model.mtl.resource.EMtlResourceFactoryImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.expressions.ExpressionsPackage;

public final class ModuleMigrator {
    private static final String EMTL_EXTENSION = "emtl";
    private static final String OCL_STD_LIB_URI = "http://www.eclipse.org/ocl/1.1.0/oclstdlib.ecore";
    private ResourceSet resourceSet;
    private IModuleResolver moduleResolver;
    private final Path targetFolderPath;

    public ModuleMigrator(IModuleResolver moduleResolver, Path targetFolderPath) {
        this.moduleResolver = moduleResolver;
        this.targetFolderPath = targetFolderPath;
        this.resourceSet = ModuleMigrator.createA3ResourceSet();
    }

    public Module migrate(File emtlFile, File originMTLFile) throws IOException {
        org.eclipse.acceleo.model.mtl.Module legacyModule = (org.eclipse.acceleo.model.mtl.Module)ModelUtils.load((File)emtlFile, (ResourceSet)this.resourceSet);
        ModuleConverter moduleConverter = new ModuleConverter(this.moduleResolver, this.targetFolderPath);
        Module convertedModule = (Module)moduleConverter.convert((EObject)legacyModule);
        if (originMTLFile != null) {
            ModuleMigrator.parseModuleDocumentation(convertedModule, originMTLFile);
        }
        return convertedModule;
    }

    private static ResourceSet createA3ResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getPackageRegistry().put((Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE.getNsURI(), (Object)org.eclipse.emf.ecore.EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)EcorePackage.eINSTANCE.getNsURI(), (Object)EcorePackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)ExpressionsPackage.eINSTANCE.getNsURI(), (Object)ExpressionsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)MtlPackage.eINSTANCE.getNsURI(), (Object)MtlPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)OCL_STD_LIB_URI, (Object)ModuleMigrator.getOCLStdLibPackage());
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(EMTL_EXTENSION, new EMtlResourceFactoryImpl());
        return resourceSet;
    }

    private static void parseModuleDocumentation(Module convertedModule, File originMTLFile) throws IOException {
        String originContent = new String(Files.readAllBytes(originMTLFile.toPath()));
        String beforeModule = originContent.substring(0, originContent.indexOf("[module "));
        List<Comment> allComments = new DocumentationParser().parse(beforeModule);
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Comment comment : allComments) {
            if (comment instanceof Documentation) {
                convertedModule.setDocumentation((Documentation)comment);
                continue;
            }
            comments.add(comment);
        }
        convertedModule.getModuleElements().addAll(0, comments);
    }

    private static EPackage getOCLStdLibPackage() {
        EcoreEnvironmentFactory factory = new EcoreEnvironmentFactory();
        EcoreEnvironment environment = (EcoreEnvironment)factory.createEnvironment();
        EPackage oclStdLibPackage = (EPackage)EcoreUtil.getRootContainer((EObject)((EObject)environment.getOCLStandardLibrary().getBag()));
        environment.dispose();
        return oclStdLibPackage;
    }
}

