/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.debug.ide.ui.launch;

import org.eclipse.acceleo.aql.ls.debug.ide.AcceleoDebugPlugin;
import org.eclipse.acceleo.aql.ls.debug.ide.ui.dialog.FileSelectionDialog;
import org.eclipse.acceleo.aql.ls.debug.ide.ui.launch.AcceleoMainTab;
import org.eclipse.acceleo.aql.profiler.ProfilerUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class AcceleoProfilerMainTab
extends AcceleoMainTab {
    private String profileModel;
    private String initialProfileModel;
    private String profileModelRepresentation;
    private String initialProfileModelRepresentation;
    private Text profileModelText;
    private Combo profileModelRepresentationCombo;

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("profileModel", this.profileModel);
        configuration.setAttribute("modelRepresentation", this.profileModelRepresentation);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            if (configuration.hasAttribute("profileModel")) {
                this.profileModelText.setText(configuration.getAttribute("profileModel", ""));
                this.initialProfileModel = this.profileModel;
            }
            if (configuration.hasAttribute("modelRepresentation")) {
                this.profileModelRepresentationCombo.setText(configuration.getAttribute("modelRepresentation", ProfilerUtils.Representation.TREE.name()));
                this.initialProfileModelRepresentation = this.profileModelRepresentation;
            }
        }
        catch (CoreException e) {
            AcceleoDebugPlugin.getPlugin().log((Object)new Status(4, "org.eclipse.acceleo.aql.ls.debug.ide", "couldn't initialize from launch configuration", (Throwable)e));
        }
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        this.initialProfileModel = this.profileModel;
        this.initialProfileModelRepresentation = this.profileModelRepresentation;
        this.setDirty(this.isDirty());
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean res = super.isValid(launchConfig);
        try {
            if (res) {
                if (!launchConfig.hasAttribute("profileModel")) {
                    this.setErrorMessage("Select a profile model");
                    res = false;
                } else if (!launchConfig.hasAttribute("modelRepresentation")) {
                    this.setErrorMessage("Select a profile model representation");
                    res = false;
                }
            }
        }
        catch (CoreException e) {
            AcceleoDebugPlugin.getPlugin().log((Object)new Status(4, "org.eclipse.acceleo.aql.ls.debug.ide", "couldn't validate launch configuration", (Throwable)e));
        }
        if (res) {
            this.setErrorMessage(null);
        }
        return res;
    }

    @Override
    protected boolean isDirty() {
        return super.isDirty() || this.profileModel != this.initialProfileModel || this.profileModelRepresentation != this.initialProfileModelRepresentation;
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        this.profileModelText = this.createProfileModelEditor((Composite)this.getControl());
        this.profileModelRepresentationCombo = this.createProfileModelRepresentationEditor((Composite)this.getControl());
    }

    private Text createProfileModelEditor(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Profile model:");
        final Text res = new Text((Composite)group, 2048);
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        res.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoProfilerMainTab.this.profileModel = res.getText();
                AcceleoProfilerMainTab.this.setDirty(AcceleoProfilerMainTab.this.isDirty());
                AcceleoProfilerMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseButton = this.createPushButton((Composite)group, "Browse...", null);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AcceleoProfilerMainTab.this.handleBrowseProfileModelButton();
            }
        });
        return res;
    }

    private Combo createProfileModelRepresentationEditor(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Profile model:");
        final Combo res = new Combo((Composite)group, 2048);
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        res.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoProfilerMainTab.this.profileModelRepresentation = res.getText();
                AcceleoProfilerMainTab.this.setDirty(AcceleoProfilerMainTab.this.isDirty());
                AcceleoProfilerMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        ProfilerUtils.Representation[] representationArray = ProfilerUtils.Representation.values();
        int n = representationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfilerUtils.Representation value = representationArray[n2];
            res.add(value.name());
            ++n2;
        }
        return res;
    }

    private void handleBrowseProfileModelButton() {
        FileSelectionDialog dialog = new FileSelectionDialog(this.getShell(), "Select the profile model", this.profileModel, "mtlp", false);
        int dialogResult = dialog.open();
        if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
            String path = dialog.getFileName();
            if (path.endsWith("mtlp")) {
                this.profileModelText.setText(path);
            } else if (path.endsWith("/")) {
                this.profileModelText.setText(String.valueOf(path) + "profiling." + "mtlp");
            } else {
                this.profileModelText.setText(String.valueOf(path) + "/profiling." + "mtlp");
            }
            this.setDirty(this.isDirty());
        }
    }
}

