/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.debug.ide.ui.dialog;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public abstract class AbstractResourceSelectionDialog
extends MessageDialog {
    private static final int TABLE_MINIMUM_HEIGHT = 400;
    private static final int TABLE_MINIMUM_WIDTH = 200;
    protected boolean onlyFileSelection;
    private Text resourceText;
    private final String defaultResourceName;
    private String resourceName;

    public AbstractResourceSelectionDialog(Shell parentShell, String title, String message, String defaultResourceName, boolean onlyFile) {
        super(parentShell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.defaultResourceName = defaultResourceName;
        this.onlyFileSelection = onlyFile;
    }

    protected Control createCustomArea(Composite parent) {
        Composite container = new Composite(parent, parent.getStyle());
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.resourceText = this.createFilePathComposite(container, this.defaultResourceName);
        TreeViewer containerTreeViewer = new TreeViewer(container, 2048);
        Tree tree = containerTreeViewer.getTree();
        GridData gdTable = new GridData(4, 4, true, true, 1, 1);
        gdTable.minimumWidth = 200;
        gdTable.minimumHeight = 400;
        tree.setLayoutData((Object)gdTable);
        containerTreeViewer.setContentProvider((IContentProvider)new FilteredContentProvider());
        containerTreeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        containerTreeViewer.addSelectionChangedListener((ISelectionChangedListener)new ContainerSelectionChangedListener());
        containerTreeViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        if (this.defaultResourceName != null && !this.defaultResourceName.isEmpty()) {
            IResource resource = this.findResource(this.defaultResourceName);
            if (!resource.exists()) {
                resource = resource.getParent();
            }
            containerTreeViewer.setSelection((ISelection)new StructuredSelection((Object)resource));
        }
        containerTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AbstractResourceSelectionDialog.this.okPressed();
            }
        });
        return container;
    }

    protected Text createFilePathComposite(Composite container, String defaultName) {
        Composite fileComposite = new Composite(container, container.getStyle());
        fileComposite.setLayout((Layout)new GridLayout(2, false));
        fileComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label templateURILabel = new Label(fileComposite, container.getStyle());
        templateURILabel.setText("File: ");
        final Text res = new Text(fileComposite, 2048);
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(fileComposite, container.getStyle());
        new Label(fileComposite, container.getStyle());
        if (defaultName != null) {
            res.setText(defaultName);
            this.resourceName = defaultName;
        }
        res.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                AbstractResourceSelectionDialog.this.resourceName = res.getText();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        return res;
    }

    public String getFileName() {
        return this.resourceName;
    }

    protected abstract IResource findResource(String var1);

    protected abstract boolean isValid(IResource var1);

    private final class ContainerSelectionChangedListener
    implements ISelectionChangedListener {
        private ContainerSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean enableOkButton;
            Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
            Button okButton = AbstractResourceSelectionDialog.this.getButton(0);
            if (selected instanceof IFile) {
                IFile file = (IFile)selected;
                AbstractResourceSelectionDialog.this.resourceText.setText(file.getFullPath().toString());
                AbstractResourceSelectionDialog.this.resourceName = file.getFullPath().toString();
                enableOkButton = true;
            } else if (!AbstractResourceSelectionDialog.this.onlyFileSelection && selected instanceof IContainer) {
                IContainer container = (IContainer)selected;
                AbstractResourceSelectionDialog.this.resourceText.setText(container.getFullPath().toString());
                AbstractResourceSelectionDialog.this.resourceName = container.getFullPath().toString();
                enableOkButton = true;
            } else {
                enableOkButton = false;
            }
            if (okButton != null && !okButton.isDisposed()) {
                okButton.setEnabled(enableOkButton);
            }
        }
    }

    private final class FilteredContentProvider
    extends WorkbenchContentProvider {
        private FilteredContentProvider() {
        }

        public Object[] getChildren(Object element) {
            ArrayList<Object> res = new ArrayList<Object>();
            Object[] objectArray = super.getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (this.isValidTree(obj)) {
                    res.add(obj);
                }
                ++n2;
            }
            return res.toArray();
        }

        public boolean hasChildren(Object element) {
            return element instanceof IContainer && this.getChildren(element).length > 0;
        }

        private boolean isValidTree(Object obj) {
            boolean res = false;
            if (obj instanceof IResource && !((IResource)obj).isDerived()) {
                if (AbstractResourceSelectionDialog.this.isValid((IResource)obj)) {
                    res = true;
                } else {
                    Object[] objectArray = super.getChildren(obj);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object child = objectArray[n2];
                        if (this.isValidTree(child)) {
                            res = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            return res;
        }
    }
}

