/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.evaluation.QueryService;
import org.eclipse.acceleo.aql.evaluation.TemplateService;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.Declaration;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.util.AcceleoSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;

public class DeclarationSwitch
extends ComposedSwitch<List<Object>> {
    private final IAcceleoValidationResult acceleoValidationResult;
    private final IQualifiedNameQueryEnvironment queryEnvironment;

    public DeclarationSwitch(IAcceleoValidationResult acceleoValidationResult, IQualifiedNameQueryEnvironment queryEnvironment) {
        this.addSwitch((Switch)new AQLDeclarationSwitch());
        this.addSwitch(new AcceleoDeclarationSwitch());
        this.acceleoValidationResult = acceleoValidationResult;
        this.queryEnvironment = queryEnvironment;
    }

    public List<Object> getDeclarations(EObject eObject) {
        return (List)this.doSwitch(eObject);
    }

    private class AQLDeclarationSwitch
    extends AstSwitch<List<Object>> {
        private AQLDeclarationSwitch() {
        }

        public List<Object> caseVarRef(VarRef varRef) {
            ArrayList<Object> res = new ArrayList<Object>();
            Declaration declaration = DeclarationSwitch.this.acceleoValidationResult.getDeclaration(varRef);
            if (declaration != null) {
                res.add(declaration);
            } else {
                Variable variable = DeclarationSwitch.this.acceleoValidationResult.getDeclarationVariable(varRef);
                if (variable != null) {
                    res.add(variable);
                }
            }
            return res;
        }

        public List<Object> caseCall(Call call) {
            ArrayList<Object> res = new ArrayList<Object>();
            List<IService<?>> services = DeclarationSwitch.this.acceleoValidationResult.getDeclarationIService(call);
            res.addAll(services);
            return res;
        }

        public List<Object> caseStringLiteral(StringLiteral stringLiteral) {
            Object res = this.isInFeatureAccessCall(stringLiteral) ? this.caseCall((Call)stringLiteral.eContainer()) : Collections.emptyList();
            return res;
        }

        private boolean isInFeatureAccessCall(StringLiteral stringLiteral) {
            Call call;
            EObject container = stringLiteral.eContainer();
            boolean res = container instanceof Call ? "aqlFeatureAccess".equals((call = (Call)container).getServiceName()) && call.getArguments().size() == 2 && call.getArguments().get(1) == stringLiteral : false;
            return res;
        }

        public List<Object> caseDeclaration(Declaration declaration) {
            ArrayList<Object> res = new ArrayList<Object>();
            res.add(declaration);
            return res;
        }

        public List<Object> defaultCase(EObject object) {
            return Collections.emptyList();
        }
    }

    private class AcceleoDeclarationSwitch
    extends AcceleoSwitch<List<Object>> {
        private AcceleoDeclarationSwitch() {
        }

        @Override
        public List<Object> caseModuleReference(ModuleReference moduleReference) {
            ArrayList<Object> res = new ArrayList<Object>();
            IQualifiedNameResolver resolver = DeclarationSwitch.this.queryEnvironment.getLookupEngine().getResolver();
            Object resolved = resolver.resolve(moduleReference.getQualifiedName());
            if (resolved != null) {
                res.add(resolved);
            }
            return res;
        }

        @Override
        public List<Object> caseTemplate(Template template) {
            ArrayList<Object> res = new ArrayList<Object>();
            res.add((Object)new TemplateService(template, null, null, null));
            return res;
        }

        @Override
        public List<Object> caseQuery(Query query) {
            ArrayList<Object> res = new ArrayList<Object>();
            res.add((Object)new QueryService(query, null, null, null));
            return res;
        }

        @Override
        public List<Object> caseVariable(Variable variable) {
            ArrayList<Object> res = new ArrayList<Object>();
            res.add(variable);
            return res;
        }

        @Override
        public List<Object> caseModule(Module module) {
            ArrayList<Object> res = new ArrayList<Object>();
            res.add(module);
            return res;
        }

        @Override
        public List<Object> defaultCase(EObject object) {
            return Collections.emptyList();
        }
    }
}

