/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls;

import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServerContext;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocumentService;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspaceService;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.SaveOptions;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;

public class AcceleoLanguageServer
implements LanguageServer,
LanguageClientAware {
    private final AcceleoTextDocumentService textDocumentService;
    private final AcceleoWorkspaceService workspaceService;
    private final AcceleoLanguageServerContext acceleoLanguageServerContext;
    private final Instant creationTimestamp = Instant.now();
    private LanguageClient languageClient;

    public AcceleoLanguageServer(AcceleoLanguageServerContext acceleoLanguageServerContext) {
        this.acceleoLanguageServerContext = Objects.requireNonNull(acceleoLanguageServerContext);
        this.workspaceService = new AcceleoWorkspaceService(this);
        this.textDocumentService = new AcceleoTextDocumentService(this);
    }

    public String getLabel() {
        return String.valueOf(this.getClass().getSimpleName()) + "@" + this.hashCode() + "_" + this.creationTimestamp;
    }

    public AcceleoWorkspace createWorkspace() {
        AcceleoWorkspace workspace = this.acceleoLanguageServerContext.createWorkspace();
        workspace.setOwner(this);
        return workspace;
    }

    private void validateAll() {
        if (this.getWorkspace() != null) {
            this.getWorkspace().getAllTextDocuments().forEach(textDocument -> textDocument.validateAndPublishResults());
        }
    }

    public void connect(LanguageClient newLanguageClient) {
        this.languageClient = newLanguageClient;
        this.textDocumentService.connect(newLanguageClient);
        this.workspaceService.connect(newLanguageClient);
        this.validateAll();
        newLanguageClient.logMessage(new MessageParams(MessageType.Info, "Connected to the Acceleo Language Server, relying on Acceleo Workspace " + this.getWorkspace().getName()));
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(this.createTextDocumentSyncOptions());
        CompletionOptions completionProvider = new CompletionOptions();
        completionProvider.setResolveProvider(Boolean.valueOf(true));
        capabilities.setCompletionProvider(completionProvider);
        capabilities.setDefinitionProvider(Boolean.valueOf(true));
        capabilities.setDocumentSymbolProvider(Boolean.valueOf(true));
        capabilities.setReferencesProvider(Boolean.valueOf(true));
        InitializeResult res = new InitializeResult(capabilities);
        return CompletableFuture.completedFuture(res);
    }

    private TextDocumentSyncOptions createTextDocumentSyncOptions() {
        TextDocumentSyncOptions textDocumentSyncOptions = new TextDocumentSyncOptions();
        textDocumentSyncOptions.setChange(TextDocumentSyncKind.Full);
        textDocumentSyncOptions.setOpenClose(Boolean.valueOf(true));
        textDocumentSyncOptions.setSave(new SaveOptions(Boolean.valueOf(true)));
        textDocumentSyncOptions.setWillSave(Boolean.valueOf(true));
        textDocumentSyncOptions.setWillSaveWaitUntil(Boolean.valueOf(true));
        return textDocumentSyncOptions;
    }

    public CompletableFuture<Object> shutdown() {
        this.acceleoLanguageServerContext.deleteWorkspace(this.getWorkspace());
        if (this.languageClient != null) {
            this.languageClient.logMessage(new MessageParams(MessageType.Log, "Acceleo Language Server is shutting down"));
        }
        return CompletableFuture.completedFuture(null);
    }

    public void exit() {
    }

    public AcceleoTextDocumentService getTextDocumentService() {
        return this.textDocumentService;
    }

    public AcceleoWorkspaceService getWorkspaceService() {
        return this.workspaceService;
    }

    public AcceleoWorkspace getWorkspace() {
        return this.getWorkspaceService().getWorkspace();
    }
}

