/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.editor;

import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.Query;
import org.eclipse.acceleo.query.runtime.impl.ECrossReferenceAdapterCrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.impl.ResourceSetRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;

public class AcceleoEnvResourceFactory
extends ResourceFactoryImpl {
    private IQualifiedNameQueryEnvironment queryEnvironment;
    private IProject project;

    public AcceleoEnvResourceFactory(IProject project) {
        this.project = project;
        this.init();
    }

    public void init() {
        IQualifiedNameResolver resolver = QueryPlugin.getPlugin().createQualifiedNameResolver(AcceleoPlugin.getPlugin().getClass().getClassLoader(), this.project, "::");
        ResourceSetImpl resourceSetForModels = new ResourceSetImpl();
        ECrossReferenceAdapterCrossReferenceProvider crossReferenceProvider = new ECrossReferenceAdapterCrossReferenceProvider(ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)resourceSetForModels));
        ResourceSetRootEObjectProvider rootProvider = new ResourceSetRootEObjectProvider((ResourceSet)resourceSetForModels);
        this.queryEnvironment = Query.newQualifiedNameEnvironmentWithDefaultServices((IQualifiedNameResolver)resolver, (CrossReferenceProvider)crossReferenceProvider, (IRootEObjectProvider)rootProvider);
        AcceleoEvaluator evaluator = new AcceleoEvaluator(this.queryEnvironment.getLookupEngine());
        resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), evaluator));
        resolver.addLoader(QueryPlugin.getPlugin().createJavaLoader("::"));
    }

    public Resource createResource(URI uri) {
        String qualifiedName = uri.toString().replaceFirst("acceleoenv::", "");
        IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
        Object resolved = resolver.resolve(qualifiedName);
        if (resolved instanceof Module) {
            return ((Module)resolved).eResource();
        }
        return null;
    }

    public IFile getSourceFile(Module module) {
        IFile[] files;
        String moduleQualifiedName;
        IQualifiedNameResolver resolver = this.queryEnvironment.getLookupEngine().getResolver();
        java.net.URI sourceURI = resolver.getSourceURI(moduleQualifiedName = resolver.getQualifiedName((Object)module));
        if (sourceURI != null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(sourceURI)).length > 0) {
            return files[0];
        }
        return null;
    }
}

