/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.Declaration;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorBinding;
import org.eclipse.acceleo.query.ast.ErrorCall;
import org.eclipse.acceleo.query.ast.ErrorEClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.ErrorEnumLiteral;
import org.eclipse.acceleo.query.ast.ErrorExpression;
import org.eclipse.acceleo.query.ast.ErrorTypeLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.parser.AstBuilderListener;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.ValidationMessageLevel;
import org.eclipse.acceleo.query.runtime.impl.ServicesValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationMessage;
import org.eclipse.acceleo.query.runtime.impl.ValidationResult;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.validation.type.ClassLiteralType;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierSetLiteralType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.LambdaType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;

public class AstValidator
extends AstSwitch<Set<IType>> {
    private static final String VARIABLE_OVERRIDES_AN_EXISTING_VALUE = "Variable %s overrides an existing value.";
    private static final String ECLASSIFIER_NOT_REGISTERED = "%s is not registered in the current environment";
    private static final String EMPTY_COLLECTION = "Empty collection: %s";
    private static final String SHOULD_NEVER_HAPPEN = "should never happen";
    private static final String AMBIGUOUS_ENUM_LITERAL = "several enumliterals are matching the literal name: %s, eenum : %s and package name : %s";
    private static final String AMBIGUOUS_TYPE_LITERAL = "several types are matching the EClassifier name: %s , package name : %s";
    protected ValidationResult validationResult;
    private final ValidationServices services;
    private final Deque<Map<String, Set<IType>>> variableTypesStack = new ArrayDeque<Map<String, Set<IType>>>();
    private Set<IValidationMessage> messages = new LinkedHashSet<IValidationMessage>();
    private final Map<String, List<VarRef>> unresolvedVarRefsMapping = new HashMap<String, List<VarRef>>();
    private final Set<VarRef> unresolvedVarRef = new LinkedHashSet<VarRef>();

    public AstValidator(IReadOnlyQueryEnvironment environment) {
        this(new ValidationServices(environment));
    }

    public AstValidator(ValidationServices services) {
        this.services = services;
    }

    protected void pushVariableTypes(Map<String, Set<IType>> variableTypes) {
        this.variableTypesStack.addLast(variableTypes);
    }

    protected Map<String, Set<IType>> peekVariableTypes() {
        return this.variableTypesStack.peekLast();
    }

    protected Map<String, Set<IType>> popVariableTypes() {
        return this.variableTypesStack.removeLast();
    }

    private void addUnresolvedVarRef(VarRef varRef) {
        this.unresolvedVarRefsMapping.computeIfAbsent(varRef.getVariableName(), n -> new ArrayList()).add(varRef);
        this.unresolvedVarRef.add(varRef);
    }

    private void resolveVarRef(Declaration declaration) {
        List<VarRef> unresolved = this.unresolvedVarRefsMapping.remove(declaration.getName());
        if (unresolved != null) {
            for (VarRef varRef : unresolved) {
                this.validationResult.putResolvedVarRef(declaration, varRef);
            }
            this.unresolvedVarRef.removeAll(unresolved);
        }
    }

    private Set<IType> checkWarningsAndErrors(Expression expression, Set<IType> types) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        LinkedHashSet<IType> validationTypes = new LinkedHashSet<IType>();
        ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
        ArrayList<ValidationMessage> infoMsgs = new ArrayList<ValidationMessage>();
        for (IType type : types) {
            AstResult astResult = this.validationResult.getAstResult();
            int startPostion = this.getStartPosition(astResult, expression);
            int endPosition = astResult.getEndPosition(expression);
            if (type instanceof NothingType) {
                msgs.add(new ValidationMessage(ValidationMessageLevel.WARNING, ((NothingType)type).getMessage(), startPostion, endPosition));
            } else if (type instanceof EClassifierType) {
                if (this.services.getQueryEnvironment().getEPackageProvider().isRegistered(((EClassifierType)type).getType())) {
                    result.add(type);
                } else {
                    msgs.add(new ValidationMessage(ValidationMessageLevel.WARNING, String.format(ECLASSIFIER_NOT_REGISTERED, type), startPostion, endPosition));
                }
            } else {
                if (type instanceof ICollectionType && ((ICollectionType)type).getCollectionType() instanceof NothingType && !this.isCollectionInExtension(expression)) {
                    NothingType nothing = (NothingType)((ICollectionType)type).getCollectionType();
                    infoMsgs.add(new ValidationMessage(ValidationMessageLevel.INFO, String.format(EMPTY_COLLECTION, nothing.getMessage()), startPostion, endPosition));
                }
                result.add(type);
            }
            validationTypes.add(type);
        }
        if (result.size() == 0) {
            for (ValidationMessage message : msgs) {
                message.setLevel(ValidationMessageLevel.ERROR);
            }
        }
        this.messages.addAll(msgs);
        this.messages.addAll(infoMsgs);
        this.validationResult.addTypes(expression, validationTypes);
        return result;
    }

    private boolean isCollectionInExtension(Expression expression) {
        return expression instanceof SetInExtensionLiteral || expression instanceof SequenceInExtensionLiteral;
    }

    private int getStartPosition(AstResult astResult, Expression expression) {
        String serviceName;
        int startPostion = expression instanceof Call ? (AstBuilderListener.OPERATOR_SERVICE_NAMES.contains(serviceName = ((Call)expression).getServiceName()) ? ("not".equals(serviceName) || "-".equals(serviceName) ? astResult.getStartPosition(expression) : astResult.getStartPosition((ASTNode)((Call)expression).getArguments().get(0))) : astResult.getEndPosition((ASTNode)((Call)expression).getArguments().get(0))) : astResult.getStartPosition(expression);
        return startPostion;
    }

    @Override
    public Set<IType> caseBooleanLiteral(BooleanLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new ClassType(this.services.getQueryEnvironment(), Boolean.class));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseCall(Call call) {
        List<Set<IType>> argTypes = this.inferArgTypes(call);
        ServicesValidationResult servicesValidationResult = this.services.call(call, this.validationResult, argTypes);
        for (IService<?> resolvedService : servicesValidationResult.getResolvedServices()) {
            this.validationResult.putResolvedCall(resolvedService, call);
        }
        Set<IType> possibleTypes = servicesValidationResult.getResultingTypes();
        return this.checkWarningsAndErrors(call, possibleTypes);
    }

    private List<Set<IType>> inferArgTypes(Call call) {
        ArrayList<Set<IType>> result = new ArrayList<Set<IType>>();
        if (call.getArguments().size() == 1) {
            if ("not".equals(call.getServiceName())) {
                Expression operand = (Expression)call.getArguments().get(0);
                Set operandTypes = (Set)this.doSwitch(operand);
                result.add(operandTypes);
                this.inferNotTypes(call, operand);
            } else {
                result.add((Set)this.doSwitch((EObject)call.getArguments().get(0)));
            }
        } else if (call.getArguments().size() == 2) {
            if ("oclIsKindOf".equals(call.getServiceName())) {
                Expression receiver = (Expression)call.getArguments().get(0);
                Set receiverTypes = (Set)this.doSwitch(receiver);
                Set argTypes = (Set)this.doSwitch((EObject)call.getArguments().get(1));
                result.add(receiverTypes);
                result.add(argTypes);
                if (receiver instanceof VarRef) {
                    this.inferOclIsKindOfTypes(call, (VarRef)receiver, argTypes);
                }
            } else if ("oclIsTypeOf".equals(call.getServiceName())) {
                Expression receiver = (Expression)call.getArguments().get(0);
                Set receiverTypes = (Set)this.doSwitch(receiver);
                Set argTypes = (Set)this.doSwitch((EObject)call.getArguments().get(1));
                result.add(receiverTypes);
                result.add(argTypes);
                if (receiver instanceof VarRef) {
                    this.inferOclIsTypeOfTypes(call, (VarRef)receiver, argTypes);
                }
            } else if ("and".equals(call.getServiceName())) {
                Expression leftOperand = (Expression)call.getArguments().get(0);
                Expression rightOperand = (Expression)call.getArguments().get(1);
                Set leftOperandTypes = (Set)this.doSwitch(leftOperand);
                HashMap<String, Set<IType>> rightOperandInferredTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
                rightOperandInferredTypes.putAll(this.validationResult.getInferredVariableTypes(leftOperand, Boolean.TRUE));
                AstValidator rightValidator = new AstValidator(this.services);
                IValidationResult rightValidatorResult = rightValidator.validate(this.peekVariableTypes(), this.validationResult.getAstResult().subResult(rightOperand));
                this.pushVariableTypes(rightOperandInferredTypes);
                LinkedHashSet rightOperandTypes = new LinkedHashSet();
                try {
                    rightOperandTypes.addAll((Collection)this.doSwitch(rightOperand));
                    result.add(leftOperandTypes);
                    result.add(rightOperandTypes);
                }
                finally {
                    this.popVariableTypes();
                    this.inferAndTypes(call, this.validationResult, rightValidatorResult);
                }
            } else if ("or".equals(call.getServiceName())) {
                Expression leftOperand = (Expression)call.getArguments().get(0);
                Expression rightOperand = (Expression)call.getArguments().get(1);
                Set leftOperandTypes = (Set)this.doSwitch(leftOperand);
                HashMap<String, Set<IType>> rightOperandInferredTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
                rightOperandInferredTypes.putAll(this.validationResult.getInferredVariableTypes(leftOperand, Boolean.FALSE));
                AstValidator rightValidator = new AstValidator(this.services);
                IValidationResult rightValidatorResult = rightValidator.validate(this.peekVariableTypes(), this.validationResult.getAstResult().subResult(rightOperand));
                this.pushVariableTypes(rightOperandInferredTypes);
                LinkedHashSet rightOperandTypes = new LinkedHashSet();
                try {
                    rightOperandTypes.addAll((Collection)this.doSwitch(rightOperand));
                    result.add(leftOperandTypes);
                    result.add(rightOperandTypes);
                }
                finally {
                    this.popVariableTypes();
                    this.inferOrTypes(call, this.validationResult, rightValidatorResult);
                }
            } else {
                result.add((Set)this.doSwitch((EObject)call.getArguments().get(0)));
                result.add((Set)this.doSwitch((EObject)call.getArguments().get(1)));
            }
        } else {
            for (Expression arg : call.getArguments()) {
                result.add((Set)this.doSwitch(arg));
            }
        }
        return result;
    }

    private void inferNotTypes(Call call, Expression operand) {
        Map<String, Set<IType>> inferredOperandTrueTypes = this.validationResult.getInferredVariableTypes(operand, Boolean.TRUE);
        Map<String, Set<IType>> inferredOperandFalseTypes = this.validationResult.getInferredVariableTypes(operand, Boolean.FALSE);
        this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, inferredOperandFalseTypes);
        this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, inferredOperandTrueTypes);
    }

    private void inferOclIsKindOfTypes(Call call, VarRef varRef, Set<IType> argTypes) {
        Set<IType> originalTypes = this.peekVariableTypes().get(varRef.getVariableName());
        if (originalTypes != null) {
            LinkedHashSet<IType> inferredTrueTypes = new LinkedHashSet<IType>();
            LinkedHashSet<IType> inferredFalseTypes = new LinkedHashSet<IType>();
            StringBuilder messageWhenTrue = new StringBuilder("Always false:");
            StringBuilder messageWhenFalse = new StringBuilder("Always true:");
            for (IType originalType : originalTypes) {
                for (IType argType : argTypes) {
                    IType lowerArgType = this.services.lower(argType, argType);
                    if (lowerArgType != null && lowerArgType.isAssignableFrom(originalType)) {
                        inferredTrueTypes.add(originalType);
                        messageWhenFalse.append(String.format("\nNothing inferred when %s (%s) is not kind of %s", varRef.getVariableName(), originalType, argType));
                        continue;
                    }
                    if (originalType != null && originalType.isAssignableFrom(lowerArgType)) {
                        inferredTrueTypes.add(lowerArgType);
                        inferredFalseTypes.add(originalType);
                        continue;
                    }
                    Set<IType> intersectionTypes = this.services.intersection(originalType, lowerArgType);
                    if (intersectionTypes.isEmpty()) {
                        messageWhenTrue.append(String.format("\nNothing inferred when %s (%s) is kind of %s", varRef.getVariableName(), originalType, argType));
                        inferredFalseTypes.add(originalType);
                        continue;
                    }
                    inferredTrueTypes.addAll(intersectionTypes);
                    inferredFalseTypes.add(originalType);
                }
            }
            if (!argTypes.isEmpty()) {
                this.registerInferredTypes(call, varRef, inferredTrueTypes, inferredFalseTypes, messageWhenTrue, messageWhenFalse);
            }
        }
    }

    private void inferOclIsTypeOfTypes(Call call, VarRef varRef, Set<IType> argTypes) {
        Set<IType> originalTypes = this.peekVariableTypes().get(varRef.getVariableName());
        if (originalTypes != null) {
            LinkedHashSet<IType> inferredTrueTypes = new LinkedHashSet<IType>();
            LinkedHashSet<IType> inferredFalseTypes = new LinkedHashSet<IType>();
            StringBuilder messageWhenTrue = new StringBuilder("Always false:");
            StringBuilder messageWhenFalse = new StringBuilder("Always true:");
            for (IType originalType : originalTypes) {
                for (IType argType : argTypes) {
                    IType lowerArgType = this.services.lower(argType, argType);
                    IType lowerType = this.services.lower(originalType, lowerArgType);
                    if (lowerArgType != null && lowerArgType.isAssignableFrom(originalType) && lowerType.isAssignableFrom(lowerArgType)) {
                        inferredTrueTypes.add(lowerArgType);
                        Set<EClass> upperSubEClasses = this.getUpperSubTypes(originalType);
                        if (upperSubEClasses.isEmpty()) {
                            messageWhenFalse.append(String.format("\nNothing inferred when %s (%s) is not type of %s", varRef.getVariableName(), originalType, argType));
                            continue;
                        }
                        for (EClass upperSubEClasse : upperSubEClasses) {
                            inferredFalseTypes.add(new EClassifierType(this.services.getQueryEnvironment(), (EClassifier)upperSubEClasse));
                        }
                        continue;
                    }
                    if (lowerType != null && lowerType.isAssignableFrom(lowerArgType)) {
                        inferredTrueTypes.add(lowerArgType);
                        inferredFalseTypes.add(originalType);
                        continue;
                    }
                    messageWhenTrue.append(String.format("\nNothing inferred when %s (%s) is type of %s", varRef.getVariableName(), originalType, argType));
                    inferredFalseTypes.add(originalType);
                }
            }
            if (!argTypes.isEmpty()) {
                this.registerInferredTypes(call, varRef, inferredTrueTypes, inferredFalseTypes, messageWhenTrue, messageWhenFalse);
            }
        }
    }

    private void registerInferredTypes(Call call, VarRef varRef, Set<IType> inferredTrueTypes, Set<IType> inferredFalseTypes, StringBuilder messageWhenTrue, StringBuilder messageWhenFalse) {
        ValidationMessage message;
        int endPosition;
        int startPostion;
        AstResult astResult;
        if (!inferredTrueTypes.isEmpty()) {
            HashMap<String, Set<IType>> inferredTrueTypesMap = new HashMap<String, Set<IType>>();
            inferredTrueTypesMap.put(varRef.getVariableName(), inferredTrueTypes);
            this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, inferredTrueTypesMap);
        } else {
            astResult = this.validationResult.getAstResult();
            startPostion = astResult.getStartPosition(call);
            endPosition = astResult.getEndPosition(call);
            message = new ValidationMessage(ValidationMessageLevel.INFO, messageWhenTrue.toString(), startPostion, endPosition);
            this.messages.add(message);
        }
        if (!inferredFalseTypes.isEmpty()) {
            HashMap<String, Set<IType>> inferredFalseTypesMap = new HashMap<String, Set<IType>>();
            inferredFalseTypesMap.put(varRef.getVariableName(), inferredFalseTypes);
            this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, inferredFalseTypesMap);
        } else {
            astResult = this.validationResult.getAstResult();
            startPostion = astResult.getStartPosition(call);
            endPosition = astResult.getEndPosition(call);
            message = new ValidationMessage(ValidationMessageLevel.INFO, messageWhenFalse.toString(), startPostion, endPosition);
            this.validationResult.getMessages().add(message);
        }
    }

    private Set<EClass> getUpperSubTypes(IType iType) {
        LinkedHashSet<EClass> result = new LinkedHashSet<EClass>();
        for (EClass eCls : this.services.getEClasses(iType)) {
            Set<EClass> subEClasses = this.services.getQueryEnvironment().getEPackageProvider().getAllSubTypes(eCls);
            for (EClass subEClass : subEClasses) {
                if (!subEClass.getESuperTypes().contains((Object)eCls)) continue;
                result.add(subEClass);
            }
        }
        return result;
    }

    private void inferOrTypes(Call call, IValidationResult leftValidationResult, IValidationResult rightValidationResult) {
        Expression leftOperand = (Expression)call.getArguments().get(0);
        Expression rightOperand = (Expression)call.getArguments().get(1);
        Map<String, Set<IType>> inferredLeftVariableTypesWhenTrue = leftValidationResult.getInferredVariableTypes(leftOperand, Boolean.TRUE);
        Map<String, Set<IType>> inferredRightVariableTypesWhenTrue = rightValidationResult.getInferredVariableTypes(rightOperand, Boolean.TRUE);
        Map<String, Set<IType>> inferredLeftVariableTypesWhenFalse = leftValidationResult.getInferredVariableTypes(leftOperand, Boolean.FALSE);
        Map<String, Set<IType>> inferredRightVariableTypesWhenFalse = rightValidationResult.getInferredVariableTypes(rightOperand, Boolean.FALSE);
        Map<String, Set<IType>> orInferredTypesWhenTrue = this.unionInferredTypes(inferredLeftVariableTypesWhenTrue, inferredRightVariableTypesWhenTrue);
        Map<String, Set<IType>> orInferredTypesWhenFalse = this.intersectionInferredTypes(inferredLeftVariableTypesWhenFalse, inferredRightVariableTypesWhenFalse);
        this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, orInferredTypesWhenTrue);
        this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, orInferredTypesWhenFalse);
    }

    private Map<String, Set<IType>> unionInferredTypes(Map<String, Set<IType>> inferredLeftVariableTypes, Map<String, Set<IType>> inferredRightVariableTypes) {
        HashMap<String, Set<IType>> result = new HashMap<String, Set<IType>>();
        HashMap<String, Set<IType>> rightLocal = new HashMap<String, Set<IType>>(inferredRightVariableTypes);
        for (Map.Entry<String, Set<IType>> entry : inferredLeftVariableTypes.entrySet()) {
            LinkedHashSet inferredTypes = new LinkedHashSet(entry.getValue());
            Set inferredRightTypes = (Set)rightLocal.remove(entry.getKey());
            if (inferredRightTypes != null) {
                inferredTypes.addAll(inferredRightTypes);
            }
            result.put(entry.getKey(), inferredTypes);
        }
        result.putAll(rightLocal);
        return result;
    }

    private void inferAndTypes(Call call, IValidationResult leftValidationResult, IValidationResult rightValidationResult) {
        Expression leftOperand = (Expression)call.getArguments().get(0);
        Expression rightOperand = (Expression)call.getArguments().get(1);
        Map<String, Set<IType>> inferredLeftVariableTypesWhenTrue = leftValidationResult.getInferredVariableTypes(leftOperand, Boolean.TRUE);
        Map<String, Set<IType>> inferredRightVariableTypesWhenTrue = rightValidationResult.getInferredVariableTypes(rightOperand, Boolean.TRUE);
        Map<String, Set<IType>> inferredLeftVariableTypesWhenFalse = leftValidationResult.getInferredVariableTypes(leftOperand, Boolean.FALSE);
        Map<String, Set<IType>> inferredRightVariableTypesWhenFalse = rightValidationResult.getInferredVariableTypes(rightOperand, Boolean.FALSE);
        Map<String, Set<IType>> andInferredTypesWhenTrue = this.intersectionInferredTypes(inferredLeftVariableTypesWhenTrue, inferredRightVariableTypesWhenTrue);
        Map<String, Set<IType>> andInferredTypesWhenFalse = this.unionInferredTypes(inferredLeftVariableTypesWhenFalse, inferredRightVariableTypesWhenFalse);
        this.validationResult.putInferredVariableTypes(call, Boolean.TRUE, andInferredTypesWhenTrue);
        this.validationResult.putInferredVariableTypes(call, Boolean.FALSE, andInferredTypesWhenFalse);
    }

    private Map<String, Set<IType>> intersectionInferredTypes(Map<String, Set<IType>> inferredLeftVariableTypes, Map<String, Set<IType>> inferredRightVariableTypes) {
        HashMap<String, Set<IType>> result = new HashMap<String, Set<IType>>();
        HashMap<String, Set<IType>> rightLocal = new HashMap<String, Set<IType>>(inferredRightVariableTypes);
        for (Map.Entry<String, Set<IType>> entry : inferredLeftVariableTypes.entrySet()) {
            LinkedHashSet<IType> inferredTypes = new LinkedHashSet<IType>();
            Set inferredRightTypes = (Set)rightLocal.remove(entry.getKey());
            if (inferredRightTypes != null) {
                for (IType leftType : entry.getValue()) {
                    for (IType rightType : inferredRightTypes) {
                        inferredTypes.addAll(this.services.intersection(leftType, rightType));
                    }
                }
            } else {
                inferredTypes.addAll((Collection)entry.getValue());
            }
            result.put(entry.getKey(), inferredTypes);
        }
        result.putAll(rightLocal);
        return result;
    }

    @Override
    public Set<IType> caseCollectionTypeLiteral(CollectionTypeLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        for (IType type : (Set)this.doSwitch(object.getElementType())) {
            if (object.getValue() == List.class) {
                possibleTypes.add(new SequenceType(this.services.getQueryEnvironment(), type));
                continue;
            }
            if (object.getValue() == Set.class) {
                possibleTypes.add(new SetType(this.services.getQueryEnvironment(), type));
                continue;
            }
            throw new UnsupportedOperationException(SHOULD_NEVER_HAPPEN);
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseEnumLiteral(EnumLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        IReadOnlyQueryEnvironment queryEnvironment = this.services.getQueryEnvironment();
        Collection<EEnumLiteral> literals = queryEnvironment.getEPackageProvider().getEnumLiterals(object.getEPackageName(), object.getEEnumName(), object.getEEnumLiteralName());
        if (literals.isEmpty()) {
            possibleTypes.add(this.services.nothing("invalid enum literal: no literal registered with this name", new Object[0]));
        } else if (literals.size() > 1) {
            possibleTypes.add(this.services.nothing(AMBIGUOUS_ENUM_LITERAL, object.getEEnumLiteralName(), object.getEEnumName(), object.getEPackageName()));
        } else {
            possibleTypes.add(new EClassifierType(queryEnvironment, (EClassifier)literals.iterator().next().getEEnum()));
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseIntegerLiteral(IntegerLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new ClassType(this.services.getQueryEnvironment(), Integer.class));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Set<IType> caseLambda(Lambda object) {
        lambdaExpressionTypes = new LinkedHashSet<IType>();
        newVariableTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
        for (VariableDeclaration variableDeclaration : object.getParameters()) {
            types = (Set)this.doSwitch(variableDeclaration);
            if (newVariableTypes.containsKey(variableDeclaration.getName())) {
                lambdaExpressionTypes.add(this.services.nothing("Variable %s overrides an existing value.", new Object[]{variableDeclaration.getName()}));
            }
            newVariableTypes.put(variableDeclaration.getName(), types);
        }
        this.pushVariableTypes(newVariableTypes);
        try {
            lambdaExpressionPossibleTypes = (Set)this.doSwitch(object.getExpression());
            evaluatorName = ((VariableDeclaration)object.getParameters().get(0)).getName();
            lambdaEvaluatorPossibleTypes = (Set)newVariableTypes.get(evaluatorName);
            for (IType lambdaEvaluatorPossibleType : lambdaEvaluatorPossibleTypes) {
                for (IType lambdaExpressionType : lambdaExpressionPossibleTypes) {
                    lambdaExpressionTypes.add(new LambdaType(this.services.getQueryEnvironment(), evaluatorName, lambdaEvaluatorPossibleType, lambdaExpressionType));
                }
            }
        }
        finally {
            ** for (variableDeclaration : object.getParameters())
        }
lbl-1000:
        // 1 sources

        {
            this.resolveVarRef(variableDeclaration);
            continue;
        }
lbl27:
        // 1 sources

        this.popVariableTypes();
        return lambdaExpressionTypes;
    }

    @Override
    public Set<IType> caseRealLiteral(RealLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new ClassType(this.services.getQueryEnvironment(), Double.class));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseStringLiteral(StringLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new ClassType(this.services.getQueryEnvironment(), String.class));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseVarRef(VarRef object) {
        Set<IType> variableTypes = this.services.getVariableTypes(this.peekVariableTypes(), object.getVariableName());
        this.addUnresolvedVarRef(object);
        return this.checkWarningsAndErrors(object, variableTypes);
    }

    public IValidationResult validate(Map<String, Set<IType>> variableTypes, AstResult astResult) {
        this.validationResult = new ValidationResult(astResult);
        this.unresolvedVarRef.clear();
        this.pushVariableTypes(variableTypes);
        this.doSwitch(astResult.getAst());
        this.popVariableTypes();
        this.validationResult.getMessages().addAll(this.messages);
        this.validationResult.getUnresolvedVarRef().addAll(this.unresolvedVarRef);
        this.messages = new LinkedHashSet<IValidationMessage>();
        return this.validationResult;
    }

    @Override
    public Set<IType> caseClassTypeLiteral(ClassTypeLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new ClassLiteralType(this.services.getQueryEnvironment(), object.getValue()));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseEClassifierTypeLiteral(EClassifierTypeLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        IReadOnlyQueryEnvironment queryEnvironment = this.services.getQueryEnvironment();
        Collection<EClassifier> eClassifiers = queryEnvironment.getEPackageProvider().getTypes(object.getEPackageName(), object.getEClassifierName());
        if (eClassifiers.isEmpty()) {
            possibleTypes.add(this.services.nothing("invalid type literal %s", String.valueOf(object.getEPackageName()) + "::" + object.getEClassifierName()));
        } else if (eClassifiers.size() > 1) {
            possibleTypes.add(this.services.nothing(AMBIGUOUS_TYPE_LITERAL, object.getEClassifierName(), object.getEPackageName()));
        } else {
            possibleTypes.add(new EClassifierLiteralType(queryEnvironment, eClassifiers.iterator().next()));
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseTypeSetLiteral(TypeSetLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        LinkedHashSet<EClassifier> types = new LinkedHashSet<EClassifier>();
        EClassifierSetLiteralType possibleType = new EClassifierSetLiteralType(this.services.getQueryEnvironment(), types);
        possibleTypes.add(possibleType);
        for (TypeLiteral type : object.getTypes()) {
            Set childTypes = (Set)this.doSwitch(type);
            for (IType childType : childTypes) {
                EClassifier eClassifier;
                if (!(childType.getType() instanceof EClassifier) || types.add(eClassifier = (EClassifier)childType.getType())) continue;
                possibleTypes.add(this.services.nothing("EClassifierLiteral=%s is duplicated in the type set literal.", eClassifier.getName()));
            }
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseErrorCall(ErrorCall object) {
        for (Expression arg : object.getArguments()) {
            this.doSwitch(arg);
        }
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(this.validationResult, object));
    }

    @Override
    public Set<IType> caseErrorExpression(ErrorExpression object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(this.validationResult, object));
    }

    @Override
    public Set<IType> caseErrorTypeLiteral(ErrorTypeLiteral object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(this.validationResult, object));
    }

    @Override
    public Set<IType> caseErrorEClassifierTypeLiteral(ErrorEClassifierTypeLiteral object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(this.validationResult, object));
    }

    @Override
    public Set<IType> caseErrorEnumLiteral(ErrorEnumLiteral object) {
        return this.checkWarningsAndErrors(object, this.services.getErrorTypes(this.validationResult, object));
    }

    @Override
    public Set<IType> caseNullLiteral(NullLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        possibleTypes.add(new ClassType(this.services.getQueryEnvironment(), null));
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseSetInExtensionLiteral(SetInExtensionLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        if (!object.getValues().isEmpty()) {
            for (Expression expression : object.getValues()) {
                for (IType type : (Set)this.doSwitch(expression)) {
                    possibleTypes.add(new SetType(this.services.getQueryEnvironment(), type));
                }
            }
        } else {
            possibleTypes.add(new SetType(this.services.getQueryEnvironment(), this.services.nothing("Empty OrderedSet defined in extension", new Object[0])));
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseSequenceInExtensionLiteral(SequenceInExtensionLiteral object) {
        LinkedHashSet<IType> possibleTypes = new LinkedHashSet<IType>();
        if (!object.getValues().isEmpty()) {
            for (Expression expression : object.getValues()) {
                for (IType type : (Set)this.doSwitch(expression)) {
                    possibleTypes.add(new SequenceType(this.services.getQueryEnvironment(), type));
                }
            }
        } else {
            possibleTypes.add(new SequenceType(this.services.getQueryEnvironment(), this.services.nothing("Empty Sequence defined in extension", new Object[0])));
        }
        return this.checkWarningsAndErrors(object, possibleTypes);
    }

    @Override
    public Set<IType> caseVariableDeclaration(VariableDeclaration variableDeclaration) {
        boolean allNullType;
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        Set<IType> expressionTypes = this.validationResult.getPossibleTypes(variableDeclaration.getExpression());
        int nbNullType = 0;
        for (IType type : expressionTypes) {
            if (type instanceof ICollectionType) {
                result.add(((ICollectionType)type).getCollectionType());
                continue;
            }
            if (type.getType() == null) {
                ++nbNullType;
            }
            result.add(type);
        }
        boolean bl = allNullType = result.size() == nbNullType;
        if (variableDeclaration.getType() != null) {
            Set<IType> declaredTypes = this.getDeclarationTypes(this.services.getQueryEnvironment(), (Set)this.doSwitch(variableDeclaration.getType()));
            if (!(variableDeclaration.getType() instanceof ErrorTypeLiteral)) {
                ArrayList<IType> incompatibleTypes = new ArrayList<IType>();
                for (IType expressionType : result) {
                    boolean compatible = false;
                    for (IType declaredType : declaredTypes) {
                        if (!declaredType.isAssignableFrom(expressionType)) continue;
                        compatible = true;
                        break;
                    }
                    if (compatible) continue;
                    incompatibleTypes.add(expressionType);
                }
                if (!incompatibleTypes.isEmpty()) {
                    for (IType incompatibleType : incompatibleTypes) {
                        result.add(this.services.nothing("%s is incompatible with declaration %s.", incompatibleType, declaredTypes));
                    }
                }
                if (allNullType) {
                    result.clear();
                    result.addAll(declaredTypes);
                }
            }
        }
        return result;
    }

    @Override
    public Set<IType> caseConditional(Conditional object) {
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        Set selectorTypes = object.getPredicate() != null ? (Set)this.doSwitch(object.getPredicate()) : Collections.emptySet();
        HashMap<String, Set<IType>> trueBranchInferredTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
        trueBranchInferredTypes.putAll(this.validationResult.getInferredVariableTypes(object.getPredicate(), Boolean.TRUE));
        this.pushVariableTypes(trueBranchInferredTypes);
        LinkedHashSet trueTypes = new LinkedHashSet();
        try {
            if (object.getTrueBranch() != null) {
                trueTypes.addAll((Collection)this.doSwitch(object.getTrueBranch()));
            }
        }
        finally {
            this.popVariableTypes();
        }
        HashMap<String, Set<IType>> falseBranchInferredTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
        falseBranchInferredTypes.putAll(this.validationResult.getInferredVariableTypes(object.getPredicate(), Boolean.FALSE));
        this.pushVariableTypes(falseBranchInferredTypes);
        LinkedHashSet falseTypes = new LinkedHashSet();
        try {
            if (object.getFalseBranch() != null) {
                falseTypes.addAll((Collection)this.doSwitch(object.getFalseBranch()));
            }
        }
        finally {
            this.popVariableTypes();
        }
        if (!selectorTypes.isEmpty()) {
            boolean onlyBoolean = true;
            boolean onlyNotBoolean = true;
            ClassType booleanObjectType = new ClassType(this.services.getQueryEnvironment(), Boolean.class);
            ClassType booleanType = new ClassType(this.services.getQueryEnvironment(), Boolean.TYPE);
            for (IType type : selectorTypes) {
                boolean assignableFrom = booleanObjectType.isAssignableFrom(type) || booleanType.isAssignableFrom(type);
                onlyBoolean = onlyBoolean && assignableFrom;
                boolean bl = onlyNotBoolean = onlyNotBoolean && !assignableFrom;
                if (!onlyBoolean && !onlyNotBoolean) break;
            }
            if (onlyBoolean) {
                result.addAll(trueTypes);
                result.addAll(falseTypes);
            } else if (onlyNotBoolean) {
                result.add(this.services.nothing("The predicate never evaluates to a boolean type (%s).", selectorTypes));
            } else {
                result.add(this.services.nothing("The predicate may evaluate to a value that is not a boolean type (%s).", selectorTypes));
                result.addAll(trueTypes);
                result.addAll(falseTypes);
            }
        } else {
            result.add(this.services.nothing("The predicate never evaluates to a boolean type (%s).", selectorTypes));
        }
        return this.checkWarningsAndErrors(object, result);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Set<IType> caseLet(Let object) {
        result = new LinkedHashSet<IType>();
        newVariableTypes = new HashMap<String, Set<IType>>(this.peekVariableTypes());
        for (Binding binding : object.getBindings()) {
            bindingTypes = (Set)this.doSwitch(binding);
            if (binding.getName() == null) continue;
            if (newVariableTypes.containsKey(binding.getName())) {
                result.add(this.services.nothing("Variable %s overrides an existing value.", new Object[]{binding.getName()}));
            }
            newVariableTypes.put(binding.getName(), bindingTypes);
        }
        this.pushVariableTypes(newVariableTypes);
        try {
            bodyTypes = (Set)this.doSwitch(object.getBody());
            result.addAll(bodyTypes);
        }
        finally {
            ** for (binding : object.getBindings())
        }
lbl-1000:
        // 1 sources

        {
            this.resolveVarRef(binding);
            continue;
        }
lbl22:
        // 1 sources

        this.popVariableTypes();
        return this.checkWarningsAndErrors(object, result);
    }

    @Override
    public Set<IType> caseBinding(Binding binding) {
        Set expressionTypes = (Set)this.doSwitch(binding.getValue());
        if (binding.getType() != null) {
            Set<IType> declaredTypes = this.getDeclarationTypes(this.services.getQueryEnvironment(), (Set)this.doSwitch(binding.getType()));
            if (!(binding.getType() instanceof ErrorTypeLiteral)) {
                ArrayList<IType> incompatibleTypes = new ArrayList<IType>();
                for (IType expressionType : expressionTypes) {
                    boolean compatible = false;
                    for (IType declaredType : declaredTypes) {
                        if (!declaredType.isAssignableFrom(expressionType)) continue;
                        compatible = true;
                        break;
                    }
                    if (compatible) continue;
                    incompatibleTypes.add(expressionType);
                }
                if (!incompatibleTypes.isEmpty()) {
                    for (IType incompatibleType : incompatibleTypes) {
                        expressionTypes.add(this.services.nothing("%s is incompatible with declaration %s.", incompatibleType, declaredTypes));
                    }
                }
            }
        }
        return expressionTypes;
    }

    public Set<IType> getDeclarationTypes(IReadOnlyQueryEnvironment queryEnvironment, Set<IType> types) {
        LinkedHashSet<IType> res = new LinkedHashSet<IType>();
        for (IType iType : types) {
            Set<IType> collectionTypes;
            if (iType instanceof EClassifierLiteralType) {
                res.add(new EClassifierType(queryEnvironment, ((EClassifierLiteralType)iType).getType()));
                continue;
            }
            if (iType instanceof EClassifierSetLiteralType) {
                for (EClassifier eClassifier : ((EClassifierSetLiteralType)iType).getEClassifiers()) {
                    res.add(new EClassifierType(queryEnvironment, eClassifier));
                }
                continue;
            }
            if (iType instanceof ClassLiteralType) {
                res.add(new ClassType(queryEnvironment, (Class<?>)((ClassLiteralType)iType).getType()));
                continue;
            }
            if (iType instanceof SequenceType) {
                collectionTypes = Collections.singleton(((SequenceType)iType).getCollectionType());
                for (IType collectionType : this.getDeclarationTypes(queryEnvironment, collectionTypes)) {
                    res.add(new SequenceType(queryEnvironment, collectionType));
                }
                continue;
            }
            if (iType instanceof SetType) {
                collectionTypes = Collections.singleton(((SetType)iType).getCollectionType());
                for (IType collectionType : this.getDeclarationTypes(queryEnvironment, collectionTypes)) {
                    res.add(new SetType(queryEnvironment, collectionType));
                }
                continue;
            }
            res.add(iType);
        }
        return res;
    }

    @Override
    public Set<IType> caseErrorBinding(ErrorBinding object) {
        Set result = object.getValue() != null ? (Set)this.doSwitch(object.getValue()) : Collections.emptySet();
        return result;
    }
}

