/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.debug.ls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.acceleo.debug.IDSLDebugger;
import org.eclipse.acceleo.debug.event.IDSLDebugEventProcessor;
import org.eclipse.acceleo.debug.ls.DSLDebugServer;
import org.eclipse.acceleo.debug.ls.IDSLDebuggerFactory;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;

public class DSLDebugSocketServer {
    private static final int BACKLOG_SIZE = 50;
    private ServerSocket serverSocket;
    private Thread serverThread;

    public synchronized void start(final IDSLDebuggerFactory dslDebugFactory, String language, String host, int port) throws UnknownHostException, IOException {
        this.serverSocket = new ServerSocket(port, 50, InetAddress.getByName(host));
        this.serverThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!DSLDebugSocketServer.this.serverSocket.isClosed() && DSLDebugSocketServer.this.serverSocket.isBound()) {
                    try {
                        Socket client = DSLDebugSocketServer.this.serverSocket.accept();
                        DSLDebugServer dslDebugServer = new DSLDebugServer();
                        IDSLDebugger debugger = dslDebugFactory.createDebugger((IDSLDebugEventProcessor)dslDebugServer);
                        dslDebugServer.setDebugger(debugger);
                        Launcher launcher = DSPLauncher.createServerLauncher((IDebugProtocolServer)dslDebugServer, (InputStream)client.getInputStream(), (OutputStream)client.getOutputStream());
                        dslDebugServer.connect((IDebugProtocolClient)launcher.getRemoteProxy());
                        launcher.startListening();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }, String.valueOf(language) + " Debug Server: " + this.serverSocket.getInetAddress().getHostName() + ":" + this.serverSocket.getLocalPort());
        this.serverThread.start();
    }

    public synchronized void stop() throws IOException {
        this.serverThread.interrupt();
        this.serverSocket.close();
    }
}

