/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.IValidationMessage;
import org.eclipse.acceleo.query.runtime.IValidationResult;

public class AcceleoValidationResult
implements IAcceleoValidationResult {
    private final AcceleoAstResult astResult;
    private final Map<ASTNode, List<IValidationMessage>> messages = new LinkedHashMap<ASTNode, List<IValidationMessage>>();
    private Map<AstResult, IValidationResult> aqlValidationResults = new HashMap<AstResult, IValidationResult>();

    public AcceleoValidationResult(AcceleoAstResult astResult) {
        this.astResult = astResult;
    }

    @Override
    public AcceleoAstResult getAcceleoAstResult() {
        return this.astResult;
    }

    @Override
    public List<IValidationMessage> getValidationMessages() {
        return this.messages.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public List<IValidationMessage> getValidationMessages(ASTNode node) {
        return new ArrayList<IValidationMessage>(this.messages.getOrDefault(node, new LinkedList()));
    }

    @Override
    public IValidationResult getValidationResult(AstResult aqlAst) {
        return this.aqlValidationResults.get(aqlAst);
    }

    void addMessage(ASTNode node, IValidationMessage newMessage) {
        this.messages.computeIfAbsent(node, key -> new LinkedList()).add(newMessage);
    }

    void addMessages(ASTNode node, Collection<IValidationMessage> newMessages) {
        this.messages.computeIfAbsent(node, key -> new LinkedList()).addAll(newMessages);
    }

    public Map<AstResult, IValidationResult> getAqlValidationResults() {
        return this.aqlValidationResults;
    }
}

