/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.location;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.location.AcceleoDefinedElementAssociator;
import org.eclipse.acceleo.aql.location.AcceleoDefinitionLocator;
import org.eclipse.acceleo.aql.location.AcceleoExpressionVariablesContextProvider;
import org.eclipse.acceleo.aql.location.aql.AqlLocator;
import org.eclipse.acceleo.aql.location.aql.AqlVariablesLocalContext;
import org.eclipse.acceleo.aql.location.common.AbstractLocationLink;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.parser.AcceleoAstUtils;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.emf.ecore.EObject;

public class AcceleoLocator {
    private final IAcceleoEnvironment acceleoEnvironment;
    private final AqlLocator aqlLocator;
    private IQualifiedNameLookupEngine lookupEngine;

    public AcceleoLocator(IAcceleoEnvironment acceleoEnvironment, IQualifiedNameLookupEngine lookupEngine) {
        this.acceleoEnvironment = acceleoEnvironment;
        this.lookupEngine = lookupEngine;
        this.aqlLocator = new AqlLocator((IQueryEnvironment)this.acceleoEnvironment.getQueryEnvironment());
    }

    public List<AbstractLocationLink<?, ?>> getDeclarationLocations(AcceleoAstResult acceleoAstResult, int position) {
        return this.getDefinitionLocations(acceleoAstResult, position);
    }

    public List<AbstractLocationLink<?, ?>> getDefinitionLocations(AcceleoAstResult acceleoAstResult, int position) {
        ArrayList definitionLocations = new ArrayList();
        EObject acceleoOrAqlNodeUnderCursor = acceleoAstResult.getAstNode(position);
        if (acceleoOrAqlNodeUnderCursor != null) {
            if (acceleoOrAqlNodeUnderCursor instanceof ASTNode) {
                ASTNode astNodeUnderCursor = (ASTNode)acceleoOrAqlNodeUnderCursor;
                ASTNode elementWhoseDefinitionToLocate = (ASTNode)new AcceleoDefinedElementAssociator().doSwitch(astNodeUnderCursor);
                definitionLocations.addAll(this.getDefinitionLocations(position, elementWhoseDefinitionToLocate));
            } else if (acceleoOrAqlNodeUnderCursor instanceof Expression || acceleoOrAqlNodeUnderCursor instanceof VariableDeclaration) {
                AqlVariablesLocalContext acceleoLocalVariablesContext = this.getVariablesContext(acceleoOrAqlNodeUnderCursor);
                AstResult astResultOfAqlNode = AcceleoAstUtils.getAqlAstResultOfAqlAstElement(acceleoOrAqlNodeUnderCursor);
                definitionLocations.addAll(this.aqlLocator.getDefinitionLocations(acceleoOrAqlNodeUnderCursor, astResultOfAqlNode, acceleoLocalVariablesContext));
            }
        }
        return definitionLocations;
    }

    private AqlVariablesLocalContext getVariablesContext(EObject aqlAstElement) {
        ASTNode acceleoContainerOfAqlElement = AcceleoAstUtils.getContainerOfAqlAstElement(aqlAstElement);
        AqlVariablesLocalContext context = (AqlVariablesLocalContext)new AcceleoExpressionVariablesContextProvider(this.acceleoEnvironment).doSwitch(acceleoContainerOfAqlElement);
        return context;
    }

    private List<AbstractLocationLink<?, ?>> getDefinitionLocations(int position, ASTNode elementWhoseDefinitionToLocate) {
        ArrayList definitionLocations = new ArrayList();
        AcceleoDefinitionLocator definitionLocator = new AcceleoDefinitionLocator(this.acceleoEnvironment, this.lookupEngine);
        List linksToDefinitionLocations = (List)definitionLocator.doSwitch(elementWhoseDefinitionToLocate);
        if (linksToDefinitionLocations != null) {
            definitionLocations.addAll(linksToDefinitionLocations);
        }
        return definitionLocations;
    }
}

