/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.acceleo.ASTNode;
import org.eclipse.acceleo.DocumentedElement;
import org.eclipse.acceleo.Expression;
import org.eclipse.acceleo.Import;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.ModuleElementDocumentation;
import org.eclipse.acceleo.ModuleReference;
import org.eclipse.acceleo.ParameterDocumentation;
import org.eclipse.acceleo.Query;
import org.eclipse.acceleo.Template;
import org.eclipse.acceleo.Variable;
import org.eclipse.acceleo.aql.IAcceleoEnvironment;
import org.eclipse.acceleo.aql.location.AcceleoLocationLinkToAcceleo;
import org.eclipse.acceleo.aql.location.common.AbstractLocationLink;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.util.AcceleoSwitch;

public class AcceleoDefinitionLocator
extends AcceleoSwitch<List<AbstractLocationLink<?, ?>>> {
    private final IAcceleoEnvironment acceleoEnvironment;
    private IQualifiedNameLookupEngine lookupEngine;

    public AcceleoDefinitionLocator(IAcceleoEnvironment acceleoEnvironment, IQualifiedNameLookupEngine lookupEngine) {
        this.acceleoEnvironment = acceleoEnvironment;
        this.lookupEngine = lookupEngine;
    }

    @Override
    public List<AbstractLocationLink<?, ?>> caseVariable(Variable variable) {
        return Collections.singletonList(new AcceleoLocationLinkToAcceleo((ASTNode)variable, variable));
    }

    @Override
    public List<AbstractLocationLink<?, ?>> caseQuery(Query query) {
        return Collections.singletonList(new AcceleoLocationLinkToAcceleo((ASTNode)query, query));
    }

    @Override
    public List<AbstractLocationLink<?, ?>> caseModule(Module module) {
        return Collections.singletonList(new AcceleoLocationLinkToAcceleo((ASTNode)module, module));
    }

    @Override
    public List<AbstractLocationLink<?, ?>> caseImport(Import importStatement) {
        return (List)this.doSwitch(importStatement.getModule());
    }

    @Override
    public List<AbstractLocationLink<?, ?>> caseModuleReference(ModuleReference moduleReference) {
        Object resolved = this.lookupEngine.getResolver().resolve(moduleReference.getQualifiedName());
        if (resolved instanceof Module) {
            return Collections.singletonList(new AcceleoLocationLinkToAcceleo((ASTNode)moduleReference, (Module)resolved));
        }
        return null;
    }

    @Override
    public List<AbstractLocationLink<?, ?>> caseParameterDocumentation(ParameterDocumentation parameterDocumentation) {
        ArrayList acceleoLocationLinks = new ArrayList();
        String parameterDocumentationBodyValue = parameterDocumentation.getBody().getValue();
        String nameOfDocumentedParameter = parameterDocumentationBodyValue.substring(0, parameterDocumentationBodyValue.indexOf(32));
        ModuleElementDocumentation parent = (ModuleElementDocumentation)parameterDocumentation.eContainer();
        DocumentedElement documentedElement = parent.getDocumentedElement();
        if (documentedElement instanceof Query) {
            Query documentedQuery = (Query)documentedElement;
            List linksToQueryParametersWithMatchingName = documentedQuery.getParameters().stream().filter(parameter -> parameter.getName().equals(nameOfDocumentedParameter)).map(queryParameter -> new AcceleoLocationLinkToAcceleo((ASTNode)parameterDocumentation, (ASTNode)queryParameter)).collect(Collectors.toList());
            acceleoLocationLinks.addAll(linksToQueryParametersWithMatchingName);
        } else if (documentedElement instanceof Template) {
            Template documentedTemplate = (Template)documentedElement;
            List linksToTemplateParametersWithMatchingName = documentedTemplate.getParameters().stream().filter(parameter -> parameter.getName().equals(nameOfDocumentedParameter)).map(templateParameter -> new AcceleoLocationLinkToAcceleo((ASTNode)parameterDocumentation, (ASTNode)templateParameter)).collect(Collectors.toList());
            acceleoLocationLinks.addAll(linksToTemplateParametersWithMatchingName);
        }
        return acceleoLocationLinks;
    }

    @Override
    public List<AbstractLocationLink<?, ?>> caseExpression(Expression expression) {
        throw new IllegalArgumentException("No definition location can be located for an Acceleo expresssion.");
    }
}

