/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.debug.ide.ui.launch;

import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.acceleo.aql.ls.debug.ide.AcceleoDebugPlugin;
import org.eclipse.acceleo.aql.ls.debug.ide.ui.dialog.FileSelectionDialog;
import org.eclipse.acceleo.aql.ls.debug.ide.ui.dialog.FolderSelectionDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class AcceleoMainTab
extends AbstractLaunchConfigurationTab {
    protected static final String BROWSE = "Browse...";
    protected String module;
    protected String model;
    protected String destination;
    private String initialModule;
    private String initialModel;
    private String initialDestination;
    private Text moduleText;
    private Text modelText;
    private Text destinationText;

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.module != null) {
            configuration.setMappedResources(new IResource[]{ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.module))});
        }
        configuration.setAttribute("module", this.module);
        configuration.setAttribute("model", this.model);
        configuration.setAttribute("destination", this.destination);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            if (configuration.hasAttribute("module")) {
                this.moduleText.setText(configuration.getAttribute("module", ""));
                this.initialModule = this.module;
            }
            if (configuration.hasAttribute("model")) {
                this.modelText.setText(configuration.getAttribute("model", ""));
                this.initialModel = this.model;
            }
            if (configuration.hasAttribute("destination")) {
                this.destinationText.setText(configuration.getAttribute("destination", ""));
                this.initialDestination = this.destination;
            }
        }
        catch (CoreException e) {
            AcceleoDebugPlugin.getPlugin().log((Object)new Status(4, "org.eclipse.acceleo.aql.ls.debug.ide", "couldn't initialize from launch configuration", (Throwable)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.setDefaults(configuration);
        this.initialModule = this.module;
        this.initialModel = this.model;
        this.initialDestination = this.destination;
        this.setDirty(this.isDirty());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean res = true;
        try {
            if (launchConfig.hasAttribute("module")) {
                IFile resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(launchConfig.getAttribute("module", "")));
                if (!AcceleoPlugin.isAcceleoMain((IResource)resource)) {
                    this.setErrorMessage("The selected Acceleo module doesn't contain a main template.");
                    res = false;
                }
            } else {
                this.setErrorMessage("Select an Acceleo module with main template.");
                res = false;
            }
            if (res && !launchConfig.hasAttribute("model")) {
                this.setErrorMessage("Select a model file.");
                res = false;
            }
            if (res && !launchConfig.hasAttribute("destination")) {
                this.setErrorMessage("Select a destination folder.");
                res = false;
            }
        }
        catch (CoreException e) {
            AcceleoDebugPlugin.getPlugin().log((Object)new Status(4, "org.eclipse.acceleo.aql.ls.debug.ide", "couldn't validate launch configuration", (Throwable)e));
        }
        if (res) {
            this.setErrorMessage(null);
        }
        return res;
    }

    public String getName() {
        return "Acceleo 4";
    }

    public void createControl(Composite parent) {
        Composite control = new Composite(parent, parent.getStyle() ^ 0x300);
        control.setLayout((Layout)new GridLayout(1, false));
        this.moduleText = this.createModuleComposite(control);
        this.modelText = this.createModelComposite(control);
        this.destinationText = this.createDestinationComposite(control);
        this.setControl((Control)control);
    }

    private Text createModuleComposite(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Module file:");
        final Text res = new Text((Composite)group, 2048);
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        res.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.module = res.getText();
                AcceleoMainTab.this.setDirty(AcceleoMainTab.this.isDirty());
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseButton = this.createPushButton((Composite)group, BROWSE, null);
        browseButton.setText(BROWSE);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AcceleoMainTab.this.handleBrowseModuleButton();
            }
        });
        return res;
    }

    private Text createModelComposite(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Model file:");
        final Text res = new Text((Composite)group, 2048);
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        res.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.model = res.getText();
                AcceleoMainTab.this.setDirty(AcceleoMainTab.this.isDirty());
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseButton = this.createPushButton((Composite)group, BROWSE, null);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AcceleoMainTab.this.handleBrowseModelButton();
            }
        });
        return res;
    }

    private Text createDestinationComposite(Composite parent) {
        Group group = new Group(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        group.setText("Destination folder:");
        final Text res = new Text((Composite)group, 2048);
        res.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        res.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AcceleoMainTab.this.destination = res.getText();
                AcceleoMainTab.this.setDirty(AcceleoMainTab.this.isDirty());
                AcceleoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browseButton = this.createPushButton((Composite)group, BROWSE, null);
        browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AcceleoMainTab.this.handleBrowseDestinationButton();
            }
        });
        return res;
    }

    protected boolean isDirty() {
        return this.module != this.initialModule || this.model != this.initialModel || this.destination != this.initialDestination;
    }

    private void handleBrowseModuleButton() {
        FileSelectionDialog dialog = new FileSelectionDialog(this.getShell(), "Select a module file", this.module, "mtl", true);
        int dialogResult = dialog.open();
        if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
            this.moduleText.setText(dialog.getFileName());
            this.setDirty(this.isDirty());
        }
    }

    private void handleBrowseModelButton() {
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("Select the model file");
        String path = this.modelText.getText();
        if (path != null && path.length() > 0 && new Path(path).lastSegment().length() > 0) {
            dialog.setInitialPattern(new Path(path).lastSegment());
        } else {
            String initial = "*.xmi";
            dialog.setInitialPattern(initial);
        }
        dialog.open();
        if (dialog.getResult() != null && dialog.getResult().length > 0 && dialog.getResult()[0] instanceof IFile) {
            this.modelText.setText(((IFile)dialog.getResult()[0]).getFullPath().toString());
        }
    }

    private void handleBrowseDestinationButton() {
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), "Select the destination folder", this.destination);
        int dialogResult = dialog.open();
        if (dialogResult == 0 && !dialog.getFileName().isEmpty()) {
            this.destinationText.setText(dialog.getFileName());
            this.setDirty(this.isDirty());
        }
    }
}

